/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.cview.IncludeRefContainer;
import org.eclipse.cdt.internal.ui.cview.IncludeReferenceProxy;
import org.eclipse.cdt.ui.newui.IConfigManager;
import org.eclipse.cdt.ui.newui.ManageConfigRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ManageConfigSelector {
    private static final String EXTENSION_POINT_ID = "org.eclipse.cdt.ui.ConfigManager";
    public static final String ELEMENT_NAME = "manager";
    public static final String CLASS_NAME = "class";
    private static IConfigManager[] mgrs = null;

    public static IConfigManager getManager(IProject[] obs) {
        ManageConfigSelector.readMgrs();
        if (mgrs == null) {
            return null;
        }
        int i = 0;
        while (i < mgrs.length) {
            if (mgrs[i].canManage(obs)) {
                return mgrs[i];
            }
            ++i;
        }
        return null;
    }

    public static IConfigManager getManagerFor(Object[] obs) {
        return ManageConfigSelector.getManager(ManageConfigSelector.getProjects(obs));
    }

    public static IProject[] getProjects(Object[] obs) {
        ArrayList<IProject> lst = new ArrayList<IProject>();
        if (obs != null) {
            int i = 0;
            while (i < obs.length) {
                ICProject fCProject;
                IncludeRefContainer irc;
                IProject prj = null;
                if (obs[i] instanceof ICElement) {
                    prj = ((ICElement)obs[i]).getCProject().getProject();
                } else if (obs[i] instanceof IResource) {
                    prj = ((IResource)obs[i]).getProject();
                } else if (obs[i] instanceof IncludeRefContainer) {
                    ICProject fCProject2 = ((IncludeRefContainer)((Object)obs[i])).getCProject();
                    if (fCProject2 != null) {
                        prj = fCProject2.getProject();
                    }
                } else if (obs[i] instanceof IncludeReferenceProxy && (irc = ((IncludeReferenceProxy)((Object)obs[i])).getIncludeRefContainer()) != null && (fCProject = irc.getCProject()) != null) {
                    prj = fCProject.getProject();
                }
                if (prj != null && !lst.contains(prj) && CoreModel.getDefault().isNewStyleProject(prj)) {
                    lst.add(prj);
                }
                ++i;
            }
        }
        return lst.toArray(new IProject[lst.size()]);
    }

    private static void readMgrs() {
        if (mgrs != null) {
            return;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            return;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions == null) {
            return;
        }
        ArrayList<IConfigManager> list = new ArrayList<IConfigManager>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int k = 0;
            while (k < elements.length) {
                if (elements[k].getName().equals(ELEMENT_NAME)) {
                    IConfigManager cm = null;
                    try {
                        cm = (IConfigManager)elements[k].createExecutableExtension(CLASS_NAME);
                    }
                    catch (CoreException coreException) {}
                    if (cm != null) {
                        list.add(cm);
                    }
                }
                ++k;
            }
            ++i;
        }
        list.add(ManageConfigRunner.getDefault());
        mgrs = list.toArray(new IConfigManager[list.size()]);
    }
}

