/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TriButton
extends Composite
implements SelectionListener {
    private static final String[] ITEMS = new String[]{"No", "Yes", "?"};
    public static final int NO = 0;
    public static final int YES = 1;
    public static final int UNKNOWN = 2;
    private boolean triMode = false;
    private Button button = null;
    private Combo combo = null;
    private Label label = null;
    private List listeners = new LinkedList();

    public TriButton(Composite parent, int style) {
        this(parent, style, true);
    }

    public TriButton(Composite parent, int style, boolean _triMode) {
        super(parent, style);
        this.triMode = _triMode;
        if (this.triMode) {
            this.setLayout((Layout)new GridLayout(2, false));
            this.combo = new Combo((Composite)this, style | 8 | 4);
            this.combo.setLayoutData((Object)new GridData(1));
            this.combo.setItems(ITEMS);
            this.combo.addSelectionListener((SelectionListener)this);
            this.label = new Label((Composite)this, 0);
            this.label.setLayoutData((Object)new GridData(768));
            this.label.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    TriButton.this.processMouseUp(e);
                }
            });
        } else {
            this.setLayout((Layout)new GridLayout());
            this.button = new Button((Composite)this, style | 0x20);
            this.button.setLayoutData((Object)new GridData(768));
            this.button.addSelectionListener((SelectionListener)this);
        }
    }

    public String getText() {
        return this.triMode ? this.label.getText() : this.button.getText();
    }

    public void setText(String string) {
        if (this.triMode) {
            this.label.setText(string);
        } else {
            this.button.setText(string);
        }
    }

    public String getToolTipText() {
        return this.triMode ? this.label.getToolTipText() : this.button.getToolTipText();
    }

    public void setToolTipText(String string) {
        if (this.triMode) {
            this.label.setToolTipText(string);
            this.combo.setToolTipText(string);
        } else {
            this.button.setToolTipText(string);
        }
    }

    public boolean getSelection() {
        return this.triMode ? this.combo.getSelectionIndex() == 1 : this.button.getSelection();
    }

    public void setSelection(boolean selected) {
        if (this.triMode) {
            this.combo.select(selected ? 1 : 0);
        } else {
            this.button.setSelection(selected);
        }
    }

    public int getTriSelection() {
        return this.triMode ? this.combo.getSelectionIndex() : (this.button.getSelection() ? 1 : 0);
    }

    public void setTriSelection(int selection) {
        if (selection != 0 && selection != 1 && selection != 2) {
            selection = 0;
        }
        if (this.triMode) {
            this.combo.select(selection);
        } else {
            this.button.setSelection(selection == 1);
        }
    }

    public int getAlignment() {
        return this.triMode ? this.label.getAlignment() : this.button.getAlignment();
    }

    public void setAlignment(int alignment) {
        if (this.triMode) {
            this.label.setAlignment(alignment);
        } else {
            this.button.setAlignment(alignment);
        }
    }

    public Image getImage() {
        return this.triMode ? this.label.getImage() : this.button.getImage();
    }

    public void setImage(Image image) {
        if (this.triMode) {
            this.label.setImage(image);
        } else {
            this.button.setImage(image);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.triMode) {
            this.label.setEnabled(enabled);
            this.combo.setEnabled(enabled);
        } else {
            this.button.setEnabled(enabled);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        e.widget = this;
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((SelectionListener)it.next()).widgetDefaultSelected(e);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        e.widget = this;
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((SelectionListener)it.next()).widgetSelected(e);
        }
    }

    private void processMouseUp(MouseEvent me) {
        int x = this.combo.getSelectionIndex() + 1;
        if (x < 0 || x > 2) {
            x = 0;
        }
        this.combo.select(x);
        Event e = new Event();
        e.button = me.button;
        e.count = me.count;
        e.data = me.data;
        e.display = me.display;
        e.stateMask = me.stateMask;
        e.time = me.time;
        e.x = me.x;
        e.y = me.y;
        e.type = 13;
        e.doit = true;
        e.item = this;
        e.widget = this;
        SelectionEvent se = new SelectionEvent(e);
        this.widgetSelected(se);
    }
}

