/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine.pages;

import java.net.URL;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.templateengine.TemplateEngineUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.templateengine.uitree.UIElement;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UIComposite;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public abstract class UIPage
extends DialogPage {
    private UIComposite uiComposite;
    protected static String RESOURCES_ID = "org.eclipse.cdt.core.resources";
    private UIElement uiElement;
    private Map valueStore;
    protected String title;
    protected String pageId;
    private ImageDescriptor imageDescriptor;

    protected UIPage(String name, UIElement element, Map valueStore) {
        super(name);
        this.setTitle(name);
        this.setDescription((String)element.getAttributes().get("description"));
        try {
            String imageLoc = (String)element.getAttributes().get("image");
            if (imageLoc != null) {
                URL url = FileLocator.toFileURL((URL)FileLocator.find((Bundle)CCorePlugin.getDefault().getBundle(), (IPath)new Path(imageLoc), null));
                this.imageDescriptor = ImageDescriptor.createFromURL((URL)url);
            }
        }
        catch (Exception e) {
            TemplateEngineUtil.log((Throwable)e);
        }
        super.setImageDescriptor(this.imageDescriptor);
        this.title = name;
        this.uiElement = element;
        this.uiElement.setValues(valueStore);
        this.valueStore = valueStore;
        this.pageId = String.valueOf(CUIPlugin.getPluginId()) + "." + this.uiElement.getAttributes().get("id");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.uiComposite = new UIComposite(parent, this.uiElement, this.valueStore);
        this.uiComposite.setFocus();
        this.setControl((Control)this.uiComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(super.getControl(), this.pageId);
    }

    public Map getPageData() {
        return this.uiElement.getValues();
    }

    public Control getControl() {
        return this.uiComposite;
    }

    public UIComposite getComposite() {
        return this.uiComposite;
    }
}

