/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine.uitree.uiwidgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.ui.templateengine.uitree.InputUIElement;
import org.eclipse.cdt.ui.templateengine.uitree.UIAttributes;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UIComposite;
import org.eclipse.cdt.utils.ui.controls.FileListControl;
import org.eclipse.cdt.utils.ui.controls.IFileListChangeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class UIStringListWidget
extends InputUIElement {
    protected UIAttributes uiAttribute;
    protected FileListControl fileListControl;
    protected Label label;
    protected UIComposite uiComposite;
    protected List itemsList;

    public UIStringListWidget(UIAttributes attribute) {
        super(attribute);
        this.uiAttribute = attribute;
        this.itemsList = new ArrayList();
    }

    public Map getValues() {
        HashMap retMap = new HashMap();
        String itemString = new String();
        int i = 0;
        while (i < this.itemsList.size()) {
            itemString = String.valueOf(itemString) + this.itemsList.get(i) + "|";
            ++i;
        }
        retMap.put(this.uiAttribute.get("id"), itemString);
        return retMap;
    }

    public void setValues(Map valueMap) {
        String items = (String)valueMap.get(this.uiAttribute.get("id"));
        if (items != null) {
            items = items.trim();
            StringTokenizer st = new StringTokenizer(items, "|");
            int i = 0;
            while (st.hasMoreTokens()) {
                this.itemsList.add(st.nextToken());
                ++i;
            }
        }
    }

    public void createWidgets(UIComposite composite) {
        GridData gridData = null;
        this.uiComposite = composite;
        this.label = new Label((Composite)composite, 16384);
        this.label.setText((String)this.uiAttribute.get(InputUIElement.WIDGETLABEL));
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        gd.verticalIndent = 5;
        this.label.setLayoutData((Object)gd);
        if (this.uiAttribute.get("description") != null) {
            String tipText = (String)this.uiAttribute.get("description");
            tipText = tipText.replaceAll("\\\\r\\\\n", "\r\n");
            this.label.setToolTipText(tipText);
        }
        Composite flcComposite = new Composite((Composite)this.uiComposite, 0);
        gridData = new GridData(768);
        flcComposite.setLayout((Layout)new GridLayout());
        flcComposite.setLayoutData((Object)gridData);
        this.fileListControl = new FileListControl(flcComposite, (String)this.uiAttribute.get(InputUIElement.WIDGETLABEL), 0);
        this.fileListControl.setList((String[])this.itemsList.toArray());
        this.fileListControl.setSelection(0);
        this.fileListControl.addChangeListener(new IFileListChangeListener(){

            public void fileListChanged(FileListControl fileList, String[] oldValue, String[] newValue) {
                UIStringListWidget.this.itemsList.addAll(Arrays.asList(newValue));
            }
        });
    }

    public boolean isValid() {
        boolean retVal = true;
        String mandatory = (String)this.uiAttribute.get(InputUIElement.MANDATORY);
        if ((this.itemsList == null || this.itemsList.size() == 0) && mandatory.equalsIgnoreCase("true")) {
            retVal = false;
        }
        return retVal;
    }

    public void disposeWidget() {
        this.label.dispose();
        this.fileListControl = null;
    }
}

