/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.resources;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;

public abstract class ACBuilder
extends IncrementalProjectBuilder
implements IMarkerGenerator {
    public void addMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
        ProblemMarkerInfo problemMarkerInfo = new ProblemMarkerInfo(file, lineNumber, errorDesc, severity, errorVar, null);
        this.addMarker(problemMarkerInfo);
    }

    public void addMarker(ProblemMarkerInfo problemMarkerInfo) {
        try {
            IMarker[] cur;
            IResource markerResource = problemMarkerInfo.file;
            if (markerResource == null) {
                markerResource = this.getProject();
            }
            if ((cur = markerResource.findMarkers("org.eclipse.cdt.core.problem", true, 1)) != null && cur.length > 0) {
                int i = 0;
                while (i < cur.length) {
                    int line = (Integer)cur[i].getAttribute("location");
                    int sev = (Integer)cur[i].getAttribute("severity");
                    String mesg = (String)cur[i].getAttribute("message");
                    if (line == problemMarkerInfo.lineNumber && sev == this.mapMarkerSeverity(problemMarkerInfo.severity) && mesg.equals(problemMarkerInfo.description)) {
                        return;
                    }
                    ++i;
                }
            }
            IMarker marker = markerResource.createMarker("org.eclipse.cdt.core.problem");
            marker.setAttribute("location", problemMarkerInfo.lineNumber);
            marker.setAttribute("message", (Object)problemMarkerInfo.description);
            marker.setAttribute("severity", this.mapMarkerSeverity(problemMarkerInfo.severity));
            marker.setAttribute("lineNumber", problemMarkerInfo.lineNumber);
            marker.setAttribute("charStart", -1);
            marker.setAttribute("charEnd", -1);
            if (problemMarkerInfo.variableName != null) {
                marker.setAttribute("problem.variable", (Object)problemMarkerInfo.variableName);
            }
            if (problemMarkerInfo.externalPath != null) {
                marker.setAttribute("problem.externalLocation", (Object)problemMarkerInfo.externalPath.toOSString());
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e.getStatus());
        }
    }

    int mapMarkerSeverity(int severity) {
        switch (severity) {
            case 2: 
            case 3: {
                return 2;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }
}

