/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.util;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceAlias;

public class IndexModelUtil {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean bindingHasCElementType(IBinding binding, int[] kinds) {
        try {
            int i = 0;
            while (true) {
                if (i >= kinds.length) {
                    return false;
                }
                switch (kinds[i]) {
                    case 67: {
                        if (!(binding instanceof ICompositeType) || ((ICompositeType)binding).getKey() != 1) break;
                        return true;
                    }
                    case 69: {
                        if (!(binding instanceof ICompositeType) || ((ICompositeType)binding).getKey() != 2) break;
                        return true;
                    }
                    case 65: {
                        if (!(binding instanceof ICompositeType) || ((ICompositeType)binding).getKey() != 3) break;
                        return true;
                    }
                    case 61: {
                        if (binding instanceof ICPPNamespace) return true;
                        if (!(binding instanceof ICPPNamespaceAlias)) break;
                        return true;
                    }
                    case 63: {
                        if (!(binding instanceof IEnumeration)) break;
                        return true;
                    }
                    case 80: {
                        if (!(binding instanceof ITypedef)) break;
                        return true;
                    }
                    case 74: {
                        if (!(binding instanceof IFunction)) break;
                        return true;
                    }
                    case 76: {
                        if (!(binding instanceof IVariable)) break;
                        return true;
                    }
                }
                ++i;
            }
        }
        catch (DOMException de) {
            CCorePlugin.log(de);
        }
        return false;
    }

    public static int getElementType(IBinding binding) {
        int elementType = Integer.MIN_VALUE;
        if (binding instanceof ICompositeType) {
            ICompositeType classType = (ICompositeType)binding;
            try {
                if (classType.getKey() == 3) {
                    elementType = 65;
                } else if (classType.getKey() == 1) {
                    elementType = 67;
                } else if (classType.getKey() == 2) {
                    elementType = 69;
                }
            }
            catch (DOMException de) {
                CCorePlugin.log(de);
            }
        }
        if (binding instanceof ICPPNamespace || binding instanceof ICPPNamespaceAlias) {
            elementType = 61;
        }
        if (binding instanceof IEnumeration) {
            elementType = 63;
        }
        if (binding instanceof ITypedef) {
            elementType = 80;
        }
        if (binding instanceof IFunction) {
            elementType = 74;
        }
        if (binding instanceof IVariable) {
            elementType = 76;
        }
        return elementType;
    }

    public static String[] extractParameterTypes(IFunction function) throws DOMException {
        IParameter[] params = function.getParameters();
        String[] parameterTypes = new String[params.length];
        int i = 0;
        while (i < params.length) {
            IParameter param = params[i];
            parameterTypes[i] = ASTTypeUtil.getType(param.getType());
            ++i;
        }
        if (parameterTypes.length == 1 && parameterTypes[0].equals("void")) {
            return EMPTY_STRING_ARRAY;
        }
        return parameterTypes;
    }

    public static String extractReturnType(IFunction function) throws DOMException {
        return ASTTypeUtil.getType(function.getType().getReturnType());
    }
}

