/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDelegate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.core.runtime.PlatformObject;

public class CPPEnumeration
extends PlatformObject
implements IEnumeration,
ICPPInternalBinding {
    private IASTName enumName;

    public CPPEnumeration(IASTName name) {
        this.enumName = name;
        name.setBinding(this);
    }

    public IASTNode[] getDeclarations() {
        return null;
    }

    public IASTNode getDefinition() {
        return this.enumName;
    }

    public String getName() {
        return this.enumName.toString();
    }

    public char[] getNameCharArray() {
        return this.enumName.toCharArray();
    }

    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.enumName);
    }

    public IASTNode getPhysicalNode() {
        return this.enumName;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public IEnumerator[] getEnumerators() {
        IASTEnumerationSpecifier.IASTEnumerator[] enums = ((IASTEnumerationSpecifier)this.enumName.getParent()).getEnumerators();
        IEnumerator[] bindings = new IEnumerator[enums.length];
        int i = 0;
        while (i < enums.length) {
            bindings[i] = (IEnumerator)enums[i].getName().resolveBinding();
            ++i;
        }
        return bindings;
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPEnumerationDelegate(name, this);
    }

    public void addDefinition(IASTNode node) {
    }

    public void addDeclaration(IASTNode node) {
    }

    public void removeDeclaration(IASTNode node) {
    }

    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexType) {
            return type.isSameType(this);
        }
        return false;
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public static class CPPEnumerationDelegate
    extends CPPDelegate
    implements IEnumeration {
        public CPPEnumerationDelegate(IASTName name, IEnumeration binding) {
            super(name, binding);
        }

        public IEnumerator[] getEnumerators() throws DOMException {
            return ((IEnumeration)this.getBinding()).getEnumerators();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public boolean isSameType(IType type) {
            return ((IEnumeration)this.getBinding()).isSameType(type);
        }
    }
}

