/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTOperatorName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;

class ImplicitsAnalysis {
    private boolean hasUserDeclaredConstructor;
    private boolean hasUserDeclaredCopyConstructor;
    private boolean hasUserDeclaredCopyAssignmentOperator;
    private boolean hasUserDeclaredDestructor;

    ImplicitsAnalysis(ICPPASTCompositeTypeSpecifier compSpec) {
        boolean hasUserDeclaredCAO;
        ICPPASTFunctionDeclarator[] ctors = ImplicitsAnalysis.getUserDeclaredCtorOrDtor(compSpec, true);
        this.hasUserDeclaredConstructor = ctors.length > 0;
        this.hasUserDeclaredCopyConstructor = false;
        this.hasUserDeclaredCopyAssignmentOperator = false;
        this.hasUserDeclaredDestructor = ImplicitsAnalysis.getUserDeclaredCtorOrDtor(compSpec, false).length > 0;
        int i = 0;
        while (i < ctors.length) {
            block4: {
                ICPPASTFunctionDeclarator dcltor = ctors[i];
                IASTParameterDeclaration[] ps = dcltor.getParameters();
                if (ps.length >= 1 && ImplicitsAnalysis.paramHasTypeReferenceToTheAssociatedClassType(ps[0])) {
                    int j = 1;
                    while (j < ps.length) {
                        if (ps[j].getDeclarator().getInitializer() != null) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    this.hasUserDeclaredCopyConstructor = true;
                }
            }
            ++i;
        }
        this.hasUserDeclaredCopyAssignmentOperator = hasUserDeclaredCAO = ImplicitsAnalysis.getUserDeclaredCopyAssignmentOperators(compSpec).length > 0;
    }

    public int getImplicitsToDeclareCount() {
        return (!this.hasUserDeclaredDestructor ? 1 : 0) + (!this.hasUserDeclaredConstructor ? 1 : 0) + (!this.hasUserDeclaredCopyConstructor ? 1 : 0) + (!this.hasUserDeclaredCopyAssignmentOperator ? 1 : 0);
    }

    private static ICPPASTFunctionDeclarator[] getUserDeclaredCtorOrDtor(ICPPASTCompositeTypeSpecifier compSpec, boolean constructor) {
        ArrayList<IASTDeclarator> result = new ArrayList<IASTDeclarator>();
        IASTDeclaration[] members = compSpec.getMembers();
        char[] name = compSpec.getName().toCharArray();
        IASTDeclarator dcltor = null;
        IASTDeclSpecifier spec = null;
        int i = 0;
        while (i < members.length) {
            block8: {
                block9: {
                    block7: {
                        if (!(members[i] instanceof IASTSimpleDeclaration)) break block7;
                        IASTDeclarator[] dtors = ((IASTSimpleDeclaration)members[i]).getDeclarators();
                        if (dtors.length == 0 || dtors.length > 1) break block8;
                        dcltor = dtors[0];
                        spec = ((IASTSimpleDeclaration)members[i]).getDeclSpecifier();
                        break block9;
                    }
                    if (members[i] instanceof IASTFunctionDefinition) {
                        dcltor = ((IASTFunctionDefinition)members[i]).getDeclarator();
                        spec = ((IASTFunctionDefinition)members[i]).getDeclSpecifier();
                    }
                }
                if (dcltor instanceof ICPPASTFunctionDeclarator && spec instanceof IASTSimpleDeclSpecifier && ((IASTSimpleDeclSpecifier)spec).getType() == 0) {
                    boolean nameEquals = false;
                    if (constructor) {
                        nameEquals = CharArrayUtils.equals(dcltor.getName().toCharArray(), name);
                    } else {
                        char[] cname = dcltor.getName().toCharArray();
                        if (cname.length > 0 && cname[0] == '~') {
                            nameEquals = CharArrayUtils.equals(cname, 1, name.length, name);
                        }
                    }
                    if (nameEquals) {
                        result.add(dcltor);
                    }
                }
            }
            ++i;
        }
        return result.toArray(new ICPPASTFunctionDeclarator[result.size()]);
    }

    private static ICPPASTFunctionDeclarator[] getUserDeclaredCopyAssignmentOperators(ICPPASTCompositeTypeSpecifier compSpec) {
        ArrayList<IASTDeclarator> result = new ArrayList<IASTDeclarator>();
        IASTDeclaration[] members = compSpec.getMembers();
        IASTDeclarator dcltor = null;
        int i = 0;
        while (i < members.length) {
            block4: {
                IASTParameterDeclaration[] ps;
                block5: {
                    block3: {
                        if (!(members[i] instanceof IASTSimpleDeclaration)) break block3;
                        IASTDeclarator[] dtors = ((IASTSimpleDeclaration)members[i]).getDeclarators();
                        if (dtors.length == 0 || dtors.length > 1) break block4;
                        dcltor = dtors[0];
                        break block5;
                    }
                    if (members[i] instanceof IASTFunctionDefinition) {
                        dcltor = ((IASTFunctionDefinition)members[i]).getDeclarator();
                    }
                }
                if (dcltor instanceof ICPPASTFunctionDeclarator && CharArrayUtils.equals(dcltor.getName().toCharArray(), ICPPASTOperatorName.OPERATOR_ASSIGN) && (ps = ((ICPPASTFunctionDeclarator)dcltor).getParameters()).length == 1 && ImplicitsAnalysis.paramHasTypeReferenceToTheAssociatedClassType(ps[0])) {
                    result.add(dcltor);
                }
            }
            ++i;
        }
        return result.toArray(new ICPPASTFunctionDeclarator[result.size()]);
    }

    private static boolean paramHasTypeReferenceToTheAssociatedClassType(IASTParameterDeclaration dec) {
        boolean result = false;
        IASTDeclarator pdtor = dec.getDeclarator();
        if (pdtor.getPointerOperators().length == 1 && pdtor.getPointerOperators()[0] instanceof ICPPASTReferenceOperator && dec.getDeclSpecifier() instanceof ICPPASTNamedTypeSpecifier) {
            result = true;
        }
        return result;
    }

    public boolean hasUserDeclaredConstructor() {
        return this.hasUserDeclaredConstructor;
    }

    public boolean hasUserDeclaredCopyConstructor() {
        return this.hasUserDeclaredCopyConstructor;
    }

    public boolean hasUserDeclaredCopyAssignmentOperator() {
        return this.hasUserDeclaredCopyAssignmentOperator;
    }

    public boolean hasUserDeclaredDestructor() {
        return this.hasUserDeclaredDestructor;
    }
}

