/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.composite;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPCompositeBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.index.composite.CompositingNotImplementedError;
import org.eclipse.cdt.internal.core.index.composite.ICompositesFactory;

public abstract class CompositeScope
implements IIndexScope {
    protected final ICompositesFactory cf;
    protected final IIndexFragmentBinding rbinding;

    public CompositeScope(ICompositesFactory cf, IIndexFragmentBinding rbinding) {
        if (cf == null || rbinding == null) {
            throw new NullPointerException();
        }
        this.cf = cf;
        this.rbinding = rbinding;
    }

    public final IScope getParent() throws DOMException {
        IIndexScope rscope = (IIndexScope)this.rbinding.getScope();
        if (rscope != null) {
            return this.cf.getCompositeScope(rscope);
        }
        return null;
    }

    public IName getScopeName() throws DOMException {
        if (this.rbinding instanceof IScope) {
            return ((IScope)((Object)this.rbinding)).getScopeName();
        }
        return null;
    }

    protected final void fail() {
        throw new CompositingNotImplementedError();
    }

    public IBinding getRawScopeBinding() {
        return this.rbinding;
    }

    protected final IBinding processUncertainBinding(IBinding binding) {
        if (binding instanceof IIndexFragmentBinding) {
            return this.cf.getCompositeBinding((IIndexFragmentBinding)binding);
        }
        if (binding instanceof ProblemBinding) {
            return binding;
        }
        if (binding instanceof CPPCompositeBinding) {
            return new CPPCompositeBinding(this.processUncertainBindings(((CPPCompositeBinding)binding).getBindings()));
        }
        if (binding == null) {
            return null;
        }
        if (binding instanceof ICPPSpecialization) {
            return binding;
        }
        CCorePlugin.log("CompositeFactory unsure how to process: " + binding.getClass().getName());
        return binding;
    }

    protected final IBinding[] processUncertainBindings(IBinding[] frgBindings) {
        IBinding[] result = new IBinding[frgBindings == null ? 0 : frgBindings.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.processUncertainBinding(frgBindings[i]);
            ++i;
        }
        return result;
    }
}

