/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.provider;

import java.util.ArrayList;
import org.eclipse.cdt.core.index.provider.IPDOMDescriptor;
import org.eclipse.cdt.core.index.provider.IReadOnlyPDOMProvider;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.provider.IIndexFragmentProvider;
import org.eclipse.cdt.internal.core.index.provider.PDOMCache;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.core.runtime.CoreException;

public class ReadOnlyPDOMProviderBridge
implements IIndexFragmentProvider {
    protected IReadOnlyPDOMProvider opp;

    public ReadOnlyPDOMProviderBridge(IReadOnlyPDOMProvider opp) {
        this.opp = opp;
    }

    public IIndexFragment[] getIndexFragments(ICConfigurationDescription config) throws CoreException {
        IPDOMDescriptor[] descs = this.opp.getDescriptors(config);
        ArrayList<PDOM> preresult = new ArrayList<PDOM>();
        if (descs != null) {
            int i = 0;
            while (i < descs.length) {
                PDOM pdom = PDOMCache.getInstance().getPDOM(descs[i].getLocation(), descs[i].getIndexLocationConverter());
                if (pdom != null) {
                    preresult.add(pdom);
                }
                ++i;
            }
        }
        return preresult.toArray(new IIndexFragment[preresult.size()]);
    }

    public boolean providesFor(ICProject cproject) throws CoreException {
        return this.opp.providesFor(cproject);
    }
}

