/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model.ext;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICCompositeTypeScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateScope;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.ext.CElementHandle;
import org.eclipse.cdt.internal.core.model.ext.EnumerationHandle;
import org.eclipse.cdt.internal.core.model.ext.EnumeratorHandle;
import org.eclipse.cdt.internal.core.model.ext.FieldHandle;
import org.eclipse.cdt.internal.core.model.ext.FunctionDeclarationHandle;
import org.eclipse.cdt.internal.core.model.ext.FunctionHandle;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.core.model.ext.MethodDeclarationHandle;
import org.eclipse.cdt.internal.core.model.ext.MethodHandle;
import org.eclipse.cdt.internal.core.model.ext.NamespaceHandle;
import org.eclipse.cdt.internal.core.model.ext.StructureHandle;
import org.eclipse.cdt.internal.core.model.ext.StructureTemplateHandle;
import org.eclipse.cdt.internal.core.model.ext.TypedefHandle;
import org.eclipse.cdt.internal.core.model.ext.VariableHandle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;

public class CElementHandleFactory {
    private CElementHandleFactory() {
    }

    public static ICElementHandle create(ITranslationUnit tu, IBinding binding, boolean isDefinition, IRegion region, long timestamp) throws CoreException {
        try {
            return CElementHandleFactory.internalCreate(tu, binding, isDefinition, region, timestamp);
        }
        catch (DOMException dOMException) {
            return null;
        }
    }

    public static ICElementHandle internalCreate(ITranslationUnit tu, IBinding binding, boolean definition, IRegion region, long timestamp) throws CoreException, DOMException {
        ICElement parentElement = CElementHandleFactory.create(tu, binding.getScope());
        if (parentElement == null) {
            return null;
        }
        CElementHandle element = null;
        if (binding instanceof ICPPMethod) {
            element = definition ? new MethodHandle(parentElement, (ICPPMethod)binding) : new MethodDeclarationHandle(parentElement, (ICPPMethod)binding);
        } else if (binding instanceof IFunction) {
            element = definition ? new FunctionHandle(parentElement, (IFunction)binding) : new FunctionDeclarationHandle(parentElement, (IFunction)binding);
        } else if (binding instanceof IField) {
            element = new FieldHandle(parentElement, (IField)binding);
        } else if (binding instanceof IVariable) {
            if (binding instanceof IParameter) {
                return null;
            }
            element = new VariableHandle(parentElement, (IVariable)binding);
        } else if (binding instanceof IEnumeration) {
            element = new EnumerationHandle(parentElement, (IEnumeration)binding);
        } else if (binding instanceof IEnumerator) {
            element = new EnumeratorHandle(parentElement, (IEnumerator)binding);
        } else if (binding instanceof ICompositeType) {
            element = binding instanceof ICPPClassTemplate ? new StructureTemplateHandle(parentElement, (ICompositeType)binding) : new StructureHandle(parentElement, (ICompositeType)binding);
        } else if (binding instanceof ICPPNamespace) {
            element = new NamespaceHandle(parentElement, (ICPPNamespace)binding);
        } else if (binding instanceof ITypedef) {
            element = new TypedefHandle(parentElement, (ITypedef)binding);
        }
        if (element != null && region != null) {
            element.setRangeOfID(region, timestamp);
        }
        return element;
    }

    private static ICElement create(ITranslationUnit tu, IScope scope) throws DOMException {
        if (scope == null) {
            return tu;
        }
        IName scopeName = scope.getScopeName();
        if (scopeName == null) {
            if (scope.getParent() == null) {
                return tu;
            }
            if (scope instanceof ICPPTemplateScope) {
                return CElementHandleFactory.create(tu, scope.getParent());
            }
            return null;
        }
        ICElement parentElement = CElementHandleFactory.create(tu, scope.getParent());
        if (parentElement == null) {
            return null;
        }
        CElementHandle element = null;
        if (scope instanceof ICPPClassScope) {
            ICPPClassType type = ((ICPPClassScope)scope).getClassType();
            element = new StructureHandle(parentElement, type);
        } else if (scope instanceof ICCompositeTypeScope) {
            ICompositeType type = ((ICCompositeTypeScope)scope).getCompositeType();
            element = new StructureHandle(parentElement, type);
        } else {
            if (scope instanceof ICPPBlockScope) {
                return null;
            }
            if (scope instanceof ICPPNamespaceScope) {
                element = new NamespaceHandle(parentElement, new String(scopeName.toCharArray()));
            }
        }
        return element;
    }
}

