/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexChangeListener;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexerStateListener;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguageMappingChangeListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexManager;
import org.eclipse.cdt.internal.core.index.IndexChangeEvent;
import org.eclipse.cdt.internal.core.index.IndexFactory;
import org.eclipse.cdt.internal.core.index.IndexerStateEvent;
import org.eclipse.cdt.internal.core.index.provider.IndexProviderManager;
import org.eclipse.cdt.internal.core.pdom.CModelListener;
import org.eclipse.cdt.internal.core.pdom.CProjectDescriptionListener;
import org.eclipse.cdt.internal.core.pdom.IPDOM;
import org.eclipse.cdt.internal.core.pdom.IndexUpdatePolicy;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.cdt.internal.core.pdom.LanguageMappingChangeListener;
import org.eclipse.cdt.internal.core.pdom.Messages;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.PDOMIndexerJob;
import org.eclipse.cdt.internal.core.pdom.PDOMProxy;
import org.eclipse.cdt.internal.core.pdom.TeamPDOMExportOperation;
import org.eclipse.cdt.internal.core.pdom.TeamPDOMImportOperation;
import org.eclipse.cdt.internal.core.pdom.WritablePDOM;
import org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMProjectIndexLocationConverter;
import org.eclipse.cdt.internal.core.pdom.indexer.DeltaAnalyzer;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMRebuildTask;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMUpdateTask;
import org.eclipse.cdt.internal.core.pdom.indexer.TriggerNotificationTask;
import org.eclipse.cdt.internal.core.pdom.indexer.nulli.PDOMNullIndexer;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class PDOMManager
implements IWritableIndexManager,
PDOM.IListener {
    private static final String SETTINGS_FOLDER_NAME = ".settings";
    private static final QualifiedName dbNameProperty;
    private static final ISchedulingRule NOTIFICATION_SCHEDULING_RULE;
    private static final ISchedulingRule INDEXER_SCHEDULING_RULE;
    private Object fTaskQueueMutex = new Object();
    private PDOMIndexerJob fIndexerJob;
    private IPDOMIndexerTask fCurrentTask;
    private LinkedList fTaskQueue = new LinkedList();
    private int fCompletedSources;
    private int fCompletedHeaders;
    private Map fProjectToPDOM = new HashMap();
    private Map fFileToProject = new HashMap();
    private ListenerList fChangeListeners = new ListenerList();
    private ListenerList fStateListeners = new ListenerList();
    private IndexChangeEvent fIndexChangeEvent = new IndexChangeEvent();
    private IndexerStateEvent fIndexerStateEvent = new IndexerStateEvent();
    private CModelListener fCModelListener = new CModelListener(this);
    private ILanguageMappingChangeListener fLanguageChangeListener = new LanguageMappingChangeListener(this);
    private ICProjectDescriptionListener fProjectDescriptionListener = new CProjectDescriptionListener(this);
    private IndexFactory fIndexFactory = new IndexFactory(this);
    private IndexProviderManager fIndexProviderManager = new IndexProviderManager();
    private HashMap fUpdatePolicies = new HashMap();
    private HashMap fPrefListeners = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.pdom.PDOMManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        dbNameProperty = new QualifiedName("org.eclipse.cdt.core", "pdomName");
        NOTIFICATION_SCHEDULING_RULE = new PerInstanceSchedulingRule();
        INDEXER_SCHEDULING_RULE = new PerInstanceSchedulingRule();
    }

    public Job startup() {
        Job postStartupJob = new Job(CCorePlugin.getResourceString("CCorePlugin.startupJob")){

            protected IStatus run(IProgressMonitor monitor) {
                PDOMManager.this.postStartup();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == PDOMManager.this;
            }
        };
        postStartupJob.setSystem(true);
        return postStartupJob;
    }

    protected void postStartup() {
        this.initializeDatabaseCache();
        this.fIndexProviderManager.startup();
        CoreModel model = CoreModel.getDefault();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fCModelListener, 16);
        model.addElementChangedListener(this.fCModelListener);
        LanguageManager.getInstance().registerLanguageChangeListener(this.fLanguageChangeListener);
        CCorePlugin.getDefault().getProjectDescriptionManager().addCProjectDescriptionListener(this.fProjectDescriptionListener, 16);
        try {
            ICProject[] projects = model.getCModel().getCProjects();
            int i = 0;
            while (i < projects.length) {
                this.addProject(projects[i]);
                ++i;
            }
        }
        catch (CModelException e) {
            CCorePlugin.log((Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        CCorePlugin.getDefault().getProjectDescriptionManager().removeCProjectDescriptionListener(this.fProjectDescriptionListener);
        CoreModel model = CoreModel.getDefault();
        model.removeElementChangedListener(this.fCModelListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fCModelListener);
        LanguageManager.getInstance().unregisterLanguageChangeListener(this.fLanguageChangeListener);
        PDOMIndexerJob jobToCancel = null;
        Object object = this.fTaskQueueMutex;
        synchronized (object) {
            this.fTaskQueue.clear();
            jobToCancel = this.fIndexerJob;
        }
        if (jobToCancel != null) {
            if (!$assertionsDisabled && Thread.holdsLock(this.fTaskQueueMutex)) {
                throw new AssertionError();
            }
            jobToCancel.cancelJobs(null, false);
        }
    }

    private void initializeDatabaseCache() {
        this.adjustCacheSize();
        CCorePlugin.getDefault().getPluginPreferences().addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                String prop = event.getProperty();
                if (prop.equals("org.eclipse.cdt.core.indexDBCacheSizePct") || prop.equals("org.eclipse.cdt.core.maxIndexDBCacheSizeMB")) {
                    PDOMManager.this.adjustCacheSize();
                }
            }
        });
    }

    protected void adjustCacheSize() {
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
        int cachePct = prefs.getInt("org.eclipse.cdt.core.indexDBCacheSizePct");
        int cacheMax = prefs.getInt("org.eclipse.cdt.core.maxIndexDBCacheSizeMB");
        cachePct = Math.max(1, Math.min(50, cachePct));
        cacheMax = Math.max(1, cacheMax);
        long m1 = Runtime.getRuntime().maxMemory() / 100L * (long)cachePct;
        long m2 = Math.min(m1, (long)cacheMax * 1024L * 1024L);
        ChunkCache.getSharedInstance().setMaxSize(m2);
    }

    public IndexProviderManager getIndexProviderManager() {
        return this.fIndexProviderManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPDOM getPDOM(ICProject project) throws CoreException {
        Map map = this.fProjectToPDOM;
        synchronized (map) {
            IProject rproject = project.getProject();
            IPDOM pdom = (IPDOM)this.fProjectToPDOM.get(rproject);
            if (pdom == null) {
                pdom = new PDOMProxy();
                this.fProjectToPDOM.put(rproject, pdom);
            }
            return pdom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WritablePDOM getOrCreatePDOM(ICProject project) throws CoreException {
        Map map = this.fProjectToPDOM;
        synchronized (map) {
            WritablePDOM pdom;
            IProject rproject = project.getProject();
            IPDOM pdomProxy = (IPDOM)this.fProjectToPDOM.get(rproject);
            if (pdomProxy instanceof WritablePDOM) {
                return (WritablePDOM)pdomProxy;
            }
            String dbName = rproject.getPersistentProperty(dbNameProperty);
            File dbFile = null;
            if (dbName != null) {
                dbFile = this.fileFromDatabaseName(dbName);
                if (!dbFile.exists()) {
                    dbFile = null;
                    dbName = null;
                } else {
                    ICProject currentCOwner = (ICProject)this.fFileToProject.get(dbFile);
                    if (currentCOwner != null) {
                        IProject currentOwner = currentCOwner.getProject();
                        if (!currentOwner.exists()) {
                            this.fFileToProject.remove(dbFile);
                            dbFile.delete();
                        }
                        dbName = null;
                        dbFile = null;
                    }
                }
            }
            boolean fromScratch = false;
            if (dbName == null) {
                dbName = this.createNewDatabaseName(project);
                dbFile = this.fileFromDatabaseName(dbName);
                this.storeDatabaseName(rproject, dbName);
                fromScratch = true;
            }
            if (!(pdom = new WritablePDOM(dbFile, new PDOMProjectIndexLocationConverter(rproject), LanguageManager.getInstance().getPDOMLinkageFactoryMappings())).isSupportedVersion() || fromScratch) {
                try {
                    pdom.acquireWriteLock();
                }
                catch (InterruptedException e) {
                    throw new CoreException(CCorePlugin.createStatus(Messages.PDOMManager_creationOfIndexInterrupted, e));
                }
                if (fromScratch) {
                    pdom.setCreatedFromScratch(true);
                } else {
                    pdom.clear();
                    pdom.setClearedBecauseOfVersionMismatch(true);
                }
                PDOMManager.writeProjectPDOMProperties(pdom, rproject);
                pdom.releaseWriteLock();
            }
            pdom.addListener(this);
            this.fFileToProject.put(dbFile, project);
            this.fProjectToPDOM.put(rproject, pdom);
            if (pdomProxy instanceof PDOMProxy) {
                ((PDOMProxy)pdomProxy).setDelegate(pdom);
            }
            return pdom;
        }
    }

    private void storeDatabaseName(IProject rproject, String dbName) throws CoreException {
        rproject.setPersistentProperty(dbNameProperty, dbName);
    }

    private String createNewDatabaseName(ICProject project) {
        String dbName;
        File file;
        long time = System.currentTimeMillis();
        while ((file = this.fileFromDatabaseName(dbName = this.getDefaultName(project, time++))).exists()) {
        }
        return dbName;
    }

    private File fileFromDatabaseName(String dbName) {
        return CCorePlugin.getDefault().getStateLocation().append(dbName).toFile();
    }

    private String getDefaultName(ICProject project, long time) {
        return String.valueOf(project.getElementName()) + "." + time + ".pdom";
    }

    public String getDefaultIndexerId() {
        return this.getIndexerId(null);
    }

    public void setDefaultIndexerId(String indexerId) {
        IndexerPreferences.setDefaultIndexerId(indexerId);
    }

    public String getIndexerId(ICProject project) {
        IProject prj = project != null ? project.getProject() : null;
        return IndexerPreferences.get(prj, "indexerId", "org.eclipse.cdt.core.nullindexer");
    }

    public void setIndexerId(ICProject project, String indexerId) {
        IProject prj = project.getProject();
        IndexerPreferences.set(prj, "indexerId", indexerId);
        CCoreInternals.savePreferences(prj);
    }

    protected void onPreferenceChange(ICProject cproject, IEclipsePreferences.PreferenceChangeEvent event) {
        if ("updatePolicy".equals(event.getKey())) {
            this.changeUpdatePolicy(cproject);
        } else {
            IProject project = cproject.getProject();
            if (project.exists() && project.isOpen()) {
                try {
                    this.changeIndexer(cproject);
                }
                catch (Exception e) {
                    CCorePlugin.log(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeUpdatePolicy(ICProject cproject) {
        if (!$assertionsDisabled && Thread.holdsLock(this.fProjectToPDOM)) {
            throw new AssertionError();
        }
        HashMap hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            IPDOMIndexerTask task;
            IndexUpdatePolicy policy = this.getPolicy(cproject);
            if (policy != null && (task = policy.changePolicy(IndexerPreferences.getUpdatePolicy(cproject.getProject()))) != null) {
                this.enqueue(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeIndexer(ICProject cproject) throws CoreException {
        if (!$assertionsDisabled && Thread.holdsLock(this.fProjectToPDOM)) {
            throw new AssertionError();
        }
        IPDOMIndexer oldIndexer = this.getIndexer(cproject);
        if (oldIndexer == null) {
            return;
        }
        IProject prj = cproject.getProject();
        String newid = IndexerPreferences.get(prj, "indexerId", "org.eclipse.cdt.core.nullindexer");
        Properties props = IndexerPreferences.getProperties(prj);
        HashMap hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            oldIndexer = this.getIndexer(cproject);
            if (oldIndexer != null) {
                if (oldIndexer.getID().equals(newid) && !oldIndexer.needsToRebuildForProperties(props)) {
                    oldIndexer.setProperties(props);
                    return;
                }
                IPDOMIndexer indexer = this.createIndexer(cproject, newid, props);
                this.registerIndexer(cproject, indexer);
                this.createPolicy(cproject).clearTUs();
                this.enqueue(new PDOMRebuildTask(indexer));
            }
        }
        if (oldIndexer != null) {
            this.stopIndexer(oldIndexer);
        }
    }

    private void registerIndexer(ICProject project, IPDOMIndexer indexer) throws CoreException {
        if (!$assertionsDisabled && !Thread.holdsLock(this.fUpdatePolicies)) {
            throw new AssertionError();
        }
        indexer.setProject(project);
        this.registerPreferenceListener(project);
        this.createPolicy(project).setIndexer(indexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPDOMIndexer getIndexer(ICProject project) {
        if (!$assertionsDisabled && Thread.holdsLock(this.fProjectToPDOM)) {
            throw new AssertionError();
        }
        HashMap hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            IndexUpdatePolicy policy = this.getPolicy(project);
            if (policy != null) {
                return policy.getIndexer();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexer(ICProject project, IProgressMonitor pm) {
        if (!$assertionsDisabled && Thread.holdsLock(this.fProjectToPDOM)) {
            throw new AssertionError();
        }
        IProject prj = project.getProject();
        try {
            IPDOMIndexer indexer;
            Properties props;
            HashMap hashMap = this.fUpdatePolicies;
            synchronized (hashMap) {
                boolean rebuild;
                WritablePDOM pdom = this.getOrCreatePDOM(project);
                props = IndexerPreferences.getProperties(prj);
                indexer = this.createIndexer(project, this.getIndexerId(project), props);
                boolean bl = rebuild = pdom.isClearedBecauseOfVersionMismatch() || pdom.isCreatedFromScratch();
                if (rebuild) {
                    if ("org.eclipse.cdt.core.nullindexer".equals(indexer.getID())) {
                        rebuild = false;
                    }
                    pdom.setClearedBecauseOfVersionMismatch(false);
                    pdom.setCreatedFromScratch(false);
                }
                if (!rebuild) {
                    this.registerIndexer(project, indexer);
                    IPDOMIndexerTask task = this.createPolicy(project).createTask();
                    if (task != null) {
                        this.enqueue(task);
                    } else {
                        this.enqueue(new TriggerNotificationTask(this, pdom));
                    }
                    return;
                }
            }
            TeamPDOMImportOperation operation = new TeamPDOMImportOperation(project);
            operation.run(pm);
            HashMap hashMap2 = this.fUpdatePolicies;
            synchronized (hashMap2) {
                props = IndexerPreferences.getProperties(prj);
                indexer = this.createIndexer(project, this.getIndexerId(project), props);
                this.registerIndexer(project, indexer);
                this.createPolicy(project).clearTUs();
                IPDOMIndexerTask task = null;
                task = operation.wasSuccessful() ? new PDOMUpdateTask(indexer, 2) : new PDOMRebuildTask(indexer);
                this.enqueue(task);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    private IPDOMIndexer createIndexer(ICProject project, String indexerId, Properties props) throws CoreException {
        IPDOMIndexer indexer = null;
        IExtension indexerExt = Platform.getExtensionRegistry().getExtension("org.eclipse.cdt.core.CIndexer", indexerId);
        if (indexerExt != null) {
            IConfigurationElement[] elements = indexerExt.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                if ("run".equals(element.getName())) {
                    try {
                        indexer = (IPDOMIndexer)element.createExecutableExtension("class");
                        indexer.setProperties(props);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                    break;
                }
                ++i;
            }
        }
        if (indexer == null) {
            indexer = new PDOMNullIndexer();
        }
        return indexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(IPDOMIndexerTask subjob) {
        Object object = this.fTaskQueueMutex;
        synchronized (object) {
            this.fTaskQueue.addLast(subjob);
            if (this.fIndexerJob == null) {
                this.fCompletedSources = 0;
                this.fCompletedHeaders = 0;
                this.fIndexerJob = new PDOMIndexerJob(this);
                this.fIndexerJob.setRule(INDEXER_SCHEDULING_RULE);
                this.fIndexerJob.schedule();
                this.notifyState(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IPDOMIndexerTask getNextTask() {
        IPDOMIndexerTask result = null;
        Object object = this.fTaskQueueMutex;
        synchronized (object) {
            if (this.fTaskQueue.isEmpty()) {
                this.fCurrentTask = null;
                this.fIndexerJob = null;
                this.notifyState(0);
            } else {
                if (this.fCurrentTask != null) {
                    IndexerProgress info = this.fCurrentTask.getProgressInformation();
                    this.fCompletedSources += info.fCompletedSources;
                    this.fCompletedHeaders += info.fCompletedHeaders;
                }
                result = this.fCurrentTask = (IPDOMIndexerTask)this.fTaskQueue.removeFirst();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelledJob(boolean byManager) {
        Object object = this.fTaskQueueMutex;
        synchronized (object) {
            this.fCurrentTask = null;
            if (!byManager) {
                this.fTaskQueue.clear();
            }
            if (this.fTaskQueue.isEmpty()) {
                this.fIndexerJob = null;
                this.notifyState(0);
            } else {
                this.fIndexerJob = new PDOMIndexerJob(this);
                this.fIndexerJob.setRule(INDEXER_SCHEDULING_RULE);
                this.fIndexerJob.schedule();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIndexerIdle() {
        Object object = this.fTaskQueueMutex;
        synchronized (object) {
            return this.fCurrentTask == null && this.fTaskQueue.isEmpty();
        }
    }

    void addProject(final ICProject cproject) {
        final IProject project = cproject.getProject();
        Job addProject = new Job(Messages.PDOMManager_StartJob_name){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("", 100);
                if (project.isOpen() && PDOMManager.this.isFullyCreated(project)) {
                    this.syncronizeProjectSettings(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (PDOMManager.this.getIndexer(cproject) == null) {
                        PDOMManager.this.createIndexer(cproject, (IProgressMonitor)new SubProgressMonitor(monitor, 99));
                    }
                }
                return Status.OK_STATUS;
            }

            private void syncronizeProjectSettings(IProject project2, IProgressMonitor monitor) {
                try {
                    IFolder settings = project2.getFolder(PDOMManager.SETTINGS_FOLDER_NAME);
                    settings.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
                monitor.done();
            }

            public boolean belongsTo(Object family) {
                return family == PDOMManager.this;
            }
        };
        ISchedulingRule rule = project.getWorkspace().getRuleFactory().refreshRule((IResource)project.getFolder(SETTINGS_FOLDER_NAME));
        if (project.contains(rule)) {
            rule = new MultiRule(new ISchedulingRule[]{project, INDEXER_SCHEDULING_RULE});
        } else if (!rule.contains((ISchedulingRule)project)) {
            rule = new MultiRule(new ISchedulingRule[]{rule, project, INDEXER_SCHEDULING_RULE});
        }
        addProject.setRule(rule);
        addProject.setSystem(true);
        addProject.schedule();
    }

    private boolean isFullyCreated(IProject project) {
        ICProjectDescription desc = CProjectDescriptionManager.getInstance().getProjectDescription(project, false);
        return desc != null && !desc.isCdtProjectCreating();
    }

    private void registerPreferenceListener(ICProject project) {
        IProject prj = project.getProject();
        PCL pcl = (PCL)this.fPrefListeners.get(prj);
        if (pcl == null) {
            pcl = new PCL(project);
            this.fPrefListeners.put(prj, pcl);
        }
        IndexerPreferences.addChangeListener(prj, pcl);
        Preferences pref = CCorePlugin.getDefault().getPluginPreferences();
        pref.addPropertyChangeListener((Preferences.IPropertyChangeListener)pcl);
    }

    private void unregisterPreferenceListener(ICProject project) {
        IProject prj = project.getProject();
        PCL pcl = (PCL)this.fPrefListeners.remove(prj);
        if (pcl != null) {
            IndexerPreferences.removeChangeListener(prj, pcl);
            Preferences pref = CCorePlugin.getDefault().getPluginPreferences();
            pref.removePropertyChangeListener((Preferences.IPropertyChangeListener)pcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeProject(ICProject project, ICElementDelta delta) throws CoreException {
        if (!$assertionsDisabled && Thread.holdsLock(this.fProjectToPDOM)) {
            throw new AssertionError();
        }
        IPDOMIndexer indexer = this.getIndexer(project);
        if (indexer != null && indexer.getID().equals("org.eclipse.cdt.core.nullindexer")) {
            return;
        }
        DeltaAnalyzer deltaAnalyzer = new DeltaAnalyzer();
        deltaAnalyzer.analyzeDelta(delta);
        ITranslationUnit[] added = deltaAnalyzer.getAddedTUs();
        ITranslationUnit[] changed = deltaAnalyzer.getChangedTUs();
        ITranslationUnit[] removed = deltaAnalyzer.getRemovedTUs();
        if (added.length > 0 || changed.length > 0 || removed.length > 0) {
            HashMap hashMap = this.fUpdatePolicies;
            synchronized (hashMap) {
                IndexUpdatePolicy policy = this.createPolicy(project);
                IPDOMIndexerTask task = policy.handleDelta(added, changed, removed);
                if (task != null) {
                    this.enqueue(task);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexUpdatePolicy createPolicy(ICProject project) {
        if (!$assertionsDisabled && Thread.holdsLock(this.fProjectToPDOM)) {
            throw new AssertionError();
        }
        HashMap hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            IndexUpdatePolicy policy = (IndexUpdatePolicy)this.fUpdatePolicies.get(project);
            if (policy == null) {
                policy = new IndexUpdatePolicy(project, IndexerPreferences.getUpdatePolicy(project.getProject()));
                this.fUpdatePolicies.put(project, policy);
            }
            return policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexUpdatePolicy getPolicy(ICProject project) {
        HashMap hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            return (IndexUpdatePolicy)this.fUpdatePolicies.get(project);
        }
    }

    public void preDeleteProject(ICProject cproject) {
        this.preRemoveProject(cproject, true);
    }

    public void preCloseProject(ICProject cproject) {
        this.preRemoveProject(cproject, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preRemoveProject(ICProject cproject, final boolean delete) {
        if (!$assertionsDisabled && Thread.holdsLock(this.fProjectToPDOM)) {
            throw new AssertionError();
        }
        IPDOMIndexer indexer = this.getIndexer(cproject);
        if (indexer != null) {
            this.stopIndexer(indexer);
        }
        this.unregisterPreferenceListener(cproject);
        Object pdom = null;
        Map map = this.fProjectToPDOM;
        synchronized (map) {
            IProject rproject = cproject.getProject();
            pdom = this.fProjectToPDOM.remove(rproject);
            if (pdom instanceof WritablePDOM && !delete) {
                this.fFileToProject.remove(((WritablePDOM)pdom).getDB().getLocation());
            }
        }
        if (pdom instanceof WritablePDOM) {
            final WritablePDOM finalpdom = pdom;
            Job job = new Job(Messages.PDOMManager_ClosePDOMJob){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        finalpdom.acquireWriteLock();
                        try {
                            try {
                                finalpdom.close();
                                if (delete) {
                                    finalpdom.getDB().getLocation().delete();
                                }
                            }
                            catch (CoreException e) {
                                CCorePlugin.log(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_4 = null;
                            finalpdom.releaseWriteLock();
                            throw throwable;
                        }
                        {
                            Object var3_5 = null;
                            finalpdom.releaseWriteLock();
                            return Status.OK_STATUS;
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
        map = this.fUpdatePolicies;
        synchronized (map) {
            this.fUpdatePolicies.remove(cproject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProject(ICProject cproject, ICElementDelta delta) {
        Map map = this.fProjectToPDOM;
        synchronized (map) {
            IProject rproject = cproject.getProject();
            this.fProjectToPDOM.remove(rproject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopIndexer(IPDOMIndexer indexer) {
        if (!$assertionsDisabled && Thread.holdsLock(this.fProjectToPDOM)) {
            throw new AssertionError();
        }
        ICProject project = indexer.getProject();
        HashMap hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            IndexUpdatePolicy policy = this.getPolicy(project);
            if (policy != null && policy.getIndexer() == indexer) {
                policy.clearTUs();
                policy.setIndexer(null);
            }
        }
        this.cancelIndexerJobs(indexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelIndexerJobs(IPDOMIndexer indexer) {
        PDOMIndexerJob jobToCancel = null;
        Object object = this.fTaskQueueMutex;
        synchronized (object) {
            Iterator iter = this.fTaskQueue.iterator();
            while (iter.hasNext()) {
                IPDOMIndexerTask task = (IPDOMIndexerTask)iter.next();
                if (task.getIndexer() != indexer) continue;
                iter.remove();
            }
            jobToCancel = this.fIndexerJob;
        }
        if (jobToCancel != null) {
            if (!$assertionsDisabled && Thread.holdsLock(this.fTaskQueueMutex)) {
                throw new AssertionError();
            }
            jobToCancel.cancelJobs(indexer, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindex(ICProject project) {
        if (!$assertionsDisabled && Thread.holdsLock(this.fProjectToPDOM)) {
            throw new AssertionError();
        }
        IPDOMIndexer indexer = null;
        HashMap hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            indexer = this.getIndexer(project);
        }
        if (indexer != null) {
            this.cancelIndexerJobs(indexer);
        }
        hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            indexer = this.getIndexer(project);
            if (indexer != null) {
                this.createPolicy(project).clearTUs();
                this.enqueue(new PDOMRebuildTask(indexer));
            }
        }
    }

    public void addIndexChangeListener(IIndexChangeListener listener) {
        this.fChangeListeners.add((Object)listener);
    }

    public void removeIndexChangeListener(IIndexChangeListener listener) {
        this.fChangeListeners.remove((Object)listener);
    }

    public void addIndexerStateListener(IIndexerStateListener listener) {
        this.fStateListeners.add((Object)listener);
    }

    public void removeIndexerStateListener(IIndexerStateListener listener) {
        this.fStateListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyState(final int state) {
        if (state == 0) {
            Object object = this.fTaskQueueMutex;
            synchronized (object) {
                this.fTaskQueueMutex.notifyAll();
            }
        }
        if (this.fStateListeners.isEmpty()) {
            return;
        }
        Job notify = new Job(Messages.PDOMManager_notifyJob_label){

            protected IStatus run(IProgressMonitor monitor) {
                PDOMManager.this.fIndexerStateEvent.setState(state);
                Object[] listeners = PDOMManager.this.fStateListeners.getListeners();
                monitor.beginTask(Messages.PDOMManager_notifyTask_message, listeners.length);
                int i = 0;
                while (i < listeners.length) {
                    IIndexerStateListener listener = (IIndexerStateListener)listeners[i];
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(this, listener){
                        final /* synthetic */ 5 this$1;
                        private final /* synthetic */ IIndexerStateListener val$listener;
                        {
                            this.this$1 = var1_1;
                            this.val$listener = iIndexerStateListener;
                        }

                        public void handleException(Throwable exception) {
                            CCorePlugin.log(exception);
                        }

                        public void run() throws Exception {
                            this.val$listener.indexChanged(PDOMManager.access$3(5.access$0(this.this$1)));
                        }
                    });
                    monitor.worked(1);
                    ++i;
                }
                return Status.OK_STATUS;
            }

            static /* synthetic */ PDOMManager access$0(5 var0) {
                return var0.PDOMManager.this;
            }
        };
        notify.setRule(NOTIFICATION_SCHEDULING_RULE);
        notify.setSystem(true);
        notify.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleChange(PDOM pdom) {
        ICProject project;
        if (this.fChangeListeners.isEmpty()) {
            return;
        }
        Map map = this.fProjectToPDOM;
        synchronized (map) {
            project = (ICProject)this.fFileToProject.get(pdom.getPath());
        }
        if (project != null) {
            final ICProject finalProject = project;
            Job notify = new Job(Messages.PDOMManager_notifyJob_label){

                protected IStatus run(IProgressMonitor monitor) {
                    PDOMManager.this.fIndexChangeEvent.setAffectedProject(finalProject);
                    Object[] listeners = PDOMManager.this.fChangeListeners.getListeners();
                    monitor.beginTask(Messages.PDOMManager_notifyTask_message, listeners.length);
                    int i = 0;
                    while (i < listeners.length) {
                        IIndexChangeListener listener = (IIndexChangeListener)listeners[i];
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(this, listener){
                            final /* synthetic */ 7 this$1;
                            private final /* synthetic */ IIndexChangeListener val$listener;
                            {
                                this.this$1 = var1_1;
                                this.val$listener = iIndexChangeListener;
                            }

                            public void handleException(Throwable exception) {
                                CCorePlugin.log(exception);
                            }

                            public void run() throws Exception {
                                this.val$listener.indexChanged(PDOMManager.access$5(7.access$0(this.this$1)));
                            }
                        });
                        monitor.worked(1);
                        ++i;
                    }
                    return Status.OK_STATUS;
                }

                static /* synthetic */ PDOMManager access$0(7 var0) {
                    return var0.PDOMManager.this;
                }
            };
            notify.setRule(NOTIFICATION_SCHEDULING_RULE);
            notify.setSystem(true);
            notify.schedule();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean joinIndexer(final int waitMaxMillis, final IProgressMonitor monitor) {
        boolean bl;
        if (!$assertionsDisabled && monitor == null) {
            throw new AssertionError();
        }
        Thread th = null;
        if (waitMaxMillis != -1) {
            th = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(waitMaxMillis);
                        monitor.setCanceled(true);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            };
            th.setDaemon(true);
            th.start();
        }
        try {
            block7: {
                try {
                    Job.getJobManager().join((Object)this, monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    break block7;
                }
                catch (InterruptedException interruptedException) {}
                Object var4_4 = null;
                if (th == null) return true;
                th.interrupt();
                return true;
            }
            bl = Job.getJobManager().find((Object)this).length == 0;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (th == null) throw throwable;
            th.interrupt();
            throw throwable;
        }
        Object var4_5 = null;
        if (th == null) return bl;
        th.interrupt();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean joinIndexerOld(int waitMaxMillis, IProgressMonitor monitor) {
        monitor.beginTask(Messages.PDOMManager_JoinIndexerTask, 1000);
        limit = System.currentTimeMillis() + (long)waitMaxMillis;
        try {
            currentTicks = 0;
            while (true) {
                block13: {
                    if (!monitor.isCanceled()) break block13;
                    ** GOTO lbl36
                }
                currentTicks = this.getMonitorMessage(monitor, currentTicks, 1000);
                var6_5 = this.fTaskQueueMutex;
                // MONITORENTER : var6_5
                if (!this.isIndexerIdle()) break block11;
                // MONITOREXIT : var6_5
                break;
            }
            catch (Throwable v0) {
                // MONITOREXIT : var6_5
                throw v0;
            }
            {
                block12: {
                    block11: {
                        var9_9 = null;
                        monitor.done();
                        return true;
                    }
                    wait = 1000;
                    if (waitMaxMillis < 0 || (rest = (int)(limit - System.currentTimeMillis())) >= wait) ** GOTO lbl31
                    if (rest <= 0) {
                        // MONITOREXIT : var6_5
                    } else {
                        wait = rest;
lbl31:
                        // 2 sources

                        try {
                            this.fTaskQueueMutex.wait(wait);
                            break block12;
                        }
                        catch (InterruptedException v1) {
                            // MONITOREXIT : var6_5
                        }
                    }
lbl36:
                    // 3 sources

                    var9_8 = null;
                    monitor.done();
                    return false;
                }
                // MONITOREXIT : var6_5
                continue;
            }
        }
        catch (Throwable var10_11) {
            var9_10 = null;
            monitor.done();
            throw var10_11;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMonitorMessage(IProgressMonitor monitor, int currentTicks, int base) {
        int newTick;
        if (!$assertionsDisabled && Thread.holdsLock(this.fTaskQueueMutex)) {
            throw new AssertionError();
        }
        int remainingSources = 0;
        int completedSources = 0;
        int completedHeaders = 0;
        int totalEstimate = 0;
        String detail = null;
        Object object = this.fTaskQueueMutex;
        synchronized (object) {
            IndexerProgress info;
            completedHeaders = this.fCompletedHeaders;
            completedSources = this.fCompletedSources;
            totalEstimate = this.fCompletedHeaders + this.fCompletedSources;
            Iterator iter = this.fTaskQueue.iterator();
            while (iter.hasNext()) {
                IPDOMIndexerTask task = (IPDOMIndexerTask)iter.next();
                info = task.getProgressInformation();
                remainingSources += info.getRemainingSources();
                totalEstimate += info.getTimeEstimate();
            }
            if (this.fCurrentTask != null) {
                info = this.fCurrentTask.getProgressInformation();
                remainingSources += info.getRemainingSources();
                completedHeaders += info.fCompletedHeaders;
                completedSources += info.fCompletedSources;
                detail = PDOMIndexerJob.sMonitorDetail;
                totalEstimate += info.getTimeEstimate();
            }
        }
        int totalSources = remainingSources + completedSources;
        String msg = MessageFormat.format(Messages.PDOMManager_indexMonitorDetail, new Integer(completedSources), new Integer(totalSources), new Integer(completedHeaders));
        if (detail != null) {
            msg = String.valueOf(msg) + ": " + detail;
        }
        monitor.subTask(msg);
        if (completedSources > 0 && totalEstimate >= completedSources && (newTick = completedSources * base / totalEstimate) > currentTicks) {
            monitor.worked(newTick - currentTicks);
            return newTick;
        }
        return currentTicks;
    }

    public IWritableIndex getWritableIndex(ICProject project) throws CoreException {
        return this.fIndexFactory.getWritableIndex(project);
    }

    public IIndex getIndex(ICProject project) throws CoreException {
        return this.fIndexFactory.getIndex(new ICProject[]{project}, 0);
    }

    public IIndex getIndex(ICProject[] projects) throws CoreException {
        return this.fIndexFactory.getIndex(projects, 0);
    }

    public IIndex getIndex(ICProject project, int options) throws CoreException {
        return this.fIndexFactory.getIndex(new ICProject[]{project}, options);
    }

    public IIndex getIndex(ICProject[] projects, int options) throws CoreException {
        return this.fIndexFactory.getIndex(projects, options);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportProjectPDOM(ICProject cproject, File targetLocation, IIndexLocationConverter newConverter) throws CoreException {
        boolean deleted;
        if (targetLocation.exists() && !(deleted = targetLocation.delete())) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.PDOMManager_ExistingFileCollides, targetLocation));
        }
        try {
            Object var7_13;
            WritablePDOM pdom = this.getOrCreatePDOM(cproject);
            pdom.acquireReadLock();
            String oldID = null;
            try {
                oldID = pdom.getProperty("org.eclipse.cdt.internal.core.index.fragment.id");
                ((PDOM)pdom).flush();
                FileChannel to = new FileOutputStream(targetLocation).getChannel();
                pdom.getDB().transferTo(to);
                to.close();
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                pdom.releaseReadLock();
                throw throwable;
            }
            {
                var7_13 = null;
                pdom.releaseReadLock();
            }
            WritablePDOM newPDOM = new WritablePDOM(targetLocation, pdom.getLocationConverter(), LanguageManager.getInstance().getPDOMLinkageFactoryMappings());
            newPDOM.acquireWriteLock();
            try {
                newPDOM.rewriteLocations(newConverter);
                newPDOM.setProperty("org.eclipse.cdt.internal.core.index.fragment.id", "exported." + oldID);
                newPDOM.close();
            }
            catch (Throwable throwable) {
                var7_13 = null;
                newPDOM.releaseWriteLock();
                throw throwable;
            }
            {
                var7_13 = null;
                newPDOM.releaseWriteLock();
                return;
            }
        }
        catch (IOException ioe) {
            throw new CoreException(CCorePlugin.createStatus(ioe.getMessage()));
        }
        catch (InterruptedException ie) {
            throw new CoreException(CCorePlugin.createStatus(ie.getMessage()));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importProjectPDOM(ICProject project, InputStream stream) throws CoreException, IOException {
        String newName = this.createNewDatabaseName(project);
        File newFile = this.fileFromDatabaseName(newName);
        FileOutputStream out = new FileOutputStream(newFile);
        try {
            int read;
            byte[] buffer = new byte[2048];
            while ((read = stream.read(buffer)) >= 0) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            ((OutputStream)out).close();
            throw throwable;
        }
        {
            Object var8_12 = null;
        }
        ((OutputStream)out).close();
        WritablePDOM pdom = (WritablePDOM)this.getPDOM(project);
        try {
            pdom.acquireWriteLock();
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        try {
            pdom.reloadFromFile(newFile);
            this.storeDatabaseName(project.getProject(), newName);
            PDOMManager.writeProjectPDOMProperties(pdom, project.getProject());
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            pdom.releaseWriteLock();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        pdom.releaseWriteLock();
    }

    public void export(ICProject project, String location, int options, IProgressMonitor monitor) throws CoreException {
        TeamPDOMExportOperation operation = new TeamPDOMExportOperation(project);
        operation.setTargetLocation(location);
        operation.setOptions(options);
        operation.run(monitor);
    }

    public static void writeProjectPDOMProperties(WritablePDOM pdom, IProject project) throws CoreException {
        String DELIM = "\u0000";
        String id = "org.eclipse.cdt.core.pdom.project." + DELIM + project.getName() + DELIM;
        pdom.setProperty("org.eclipse.cdt.internal.core.index.fragment.id", id);
    }

    public boolean isProjectIndexed(ICProject proj) {
        return !"org.eclipse.cdt.core.nullindexer".equals(this.getIndexerId(proj));
    }

    public void update(ICElement[] tuSelection, int options) throws CoreException {
        Map projectsToElements = this.splitSelection(tuSelection);
        Iterator i = projectsToElements.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ICProject project = (ICProject)entry.getKey();
            List filesAndFolders = (List)entry.getValue();
            this.update(project, filesAndFolders, options);
        }
    }

    private Map splitSelection(ICElement[] tuSelection) {
        HashMap result = new HashMap();
        int i = 0;
        while (i < tuSelection.length) {
            block5: {
                ICElement element = tuSelection[i];
                if (element instanceof ICProject || element instanceof ICContainer || element instanceof ITranslationUnit) {
                    ICProject project = element.getCProject();
                    ArrayList<ICElement> set = (ArrayList<ICElement>)result.get(project);
                    if (set == null) {
                        set = new ArrayList<ICElement>();
                        result.put(project, set);
                    }
                    int j = 0;
                    while (j < set.size()) {
                        ICElement other = (ICElement)set.get(j);
                        if (this.contains(other, element)) break block5;
                        if (this.contains(element, other)) {
                            set.set(j, element);
                            break block5;
                        }
                        ++j;
                    }
                    set.add(element);
                }
            }
            ++i;
        }
        return result;
    }

    private boolean contains(ICElement a, ICElement b) {
        if (a.equals(b)) {
            return true;
        }
        if ((b = b.getParent()) == null) {
            return false;
        }
        return this.contains(a, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(ICProject project, List filesAndFolders, int options) throws CoreException {
        if (!$assertionsDisabled && Thread.holdsLock(this.fProjectToPDOM)) {
            throw new AssertionError();
        }
        HashMap hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            IPDOMIndexer indexer = this.getIndexer(project);
            PDOMUpdateTask task = new PDOMUpdateTask(indexer, options);
            task.setTranslationUnitSelection(filesAndFolders);
            if (indexer != null) {
                this.enqueue(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePostBuildEvent() {
        if (!$assertionsDisabled && Thread.holdsLock(this.fProjectToPDOM)) {
            throw new AssertionError();
        }
        HashMap hashMap = this.fUpdatePolicies;
        synchronized (hashMap) {
            Iterator i = this.fUpdatePolicies.values().iterator();
            while (i.hasNext()) {
                IndexUpdatePolicy policy = (IndexUpdatePolicy)i.next();
                IPDOMIndexerTask task = policy.createTask();
                if (task == null) continue;
                this.enqueue(task);
            }
        }
    }

    private final class PCL
    implements IEclipsePreferences.IPreferenceChangeListener,
    Preferences.IPropertyChangeListener {
        private ICProject fProject;

        public PCL(ICProject prj) {
            this.fProject = prj;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (this.fProject.getProject().isOpen()) {
                PDOMManager.this.onPreferenceChange(this.fProject, event);
            }
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("org.eclipse.cdt.core.taskTags") || property.equals("org.eclipse.cdt.core.taskPriorities") || property.equals("org.eclipse.cdt.core.taskCaseSensitive")) {
                PDOMManager.this.reindex(this.fProject);
            }
        }
    }

    private static final class PerInstanceSchedulingRule
    implements ISchedulingRule {
        private PerInstanceSchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

