/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.WritablePDOM;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.Messages;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMInclude;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacro;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.core.runtime.CoreException;

public class PDOMFile
implements IIndexFragmentFile {
    private final PDOM pdom;
    private final int record;
    private static final int FIRST_NAME = 0;
    private static final int FIRST_INCLUDE = 4;
    private static final int FIRST_INCLUDED_BY = 8;
    private static final int FIRST_MACRO = 12;
    private static final int LOCATION_REPRESENTATION = 16;
    private static final int TIME_STAMP = 20;
    private static final int SCANNER_CONFIG_HASH = 28;
    private static final int RECORD_SIZE = 32;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.pdom.dom.PDOMFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PDOMFile(PDOM pdom, int record) {
        this.pdom = pdom;
        this.record = record;
    }

    public PDOMFile(PDOM pdom, IIndexFileLocation location) throws CoreException {
        this.pdom = pdom;
        Database db = pdom.getDB();
        this.record = db.malloc(32);
        String locationString = pdom.getLocationConverter().toInternalFormat(location);
        if (locationString == null) {
            throw new CoreException(CCorePlugin.createStatus(String.valueOf(Messages.getString("PDOMFile.toInternalProblem")) + location.getURI()));
        }
        IString locationDBString = db.newString(locationString);
        db.putInt(this.record + 16, locationDBString.getRecord());
        db.putLong(this.record + 20, 0L);
        this.setFirstName(null);
        this.setFirstInclude(null);
        this.setFirstIncludedBy(null);
    }

    public int getRecord() {
        return this.record;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PDOMFile) {
            PDOMFile other = (PDOMFile)obj;
            return this.pdom.equals(other.pdom) && this.record == other.record;
        }
        return false;
    }

    public final int hashCode() {
        return System.identityHashCode(this.pdom) + 41 * this.record;
    }

    public void setInternalLocation(String internalLocation) throws CoreException {
        Database db = this.pdom.getDB();
        int oldRecord = db.getInt(this.record + 16);
        db.free(oldRecord);
        db.putInt(this.record + 16, db.newString(internalLocation).getRecord());
    }

    public long getTimestamp() throws CoreException {
        Database db = this.pdom.getDB();
        return db.getLong(this.record + 20);
    }

    public void setTimestamp(long timestamp) throws CoreException {
        Database db = this.pdom.getDB();
        db.putLong(this.record + 20, timestamp);
    }

    public int getScannerConfigurationHashcode() throws CoreException {
        Database db = this.pdom.getDB();
        return db.getInt(this.record + 28);
    }

    public void setScannerConfigurationHashcode(int hashcode) throws CoreException {
        Database db = this.pdom.getDB();
        db.putInt(this.record + 28, hashcode);
    }

    public PDOMName getFirstName() throws CoreException {
        int namerec = this.pdom.getDB().getInt(this.record + 0);
        return namerec != 0 ? new PDOMName(this.pdom, namerec) : null;
    }

    public void setFirstName(PDOMName firstName) throws CoreException {
        int namerec = firstName != null ? firstName.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 0, namerec);
    }

    public PDOMInclude getFirstInclude() throws CoreException {
        int increc = this.pdom.getDB().getInt(this.record + 4);
        return increc != 0 ? new PDOMInclude(this.pdom, increc) : null;
    }

    public void setFirstInclude(PDOMInclude include) throws CoreException {
        int rec = include != null ? include.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 4, rec);
    }

    public PDOMInclude getFirstIncludedBy() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 8);
        return rec != 0 ? new PDOMInclude(this.pdom, rec) : null;
    }

    public IIndexInclude getParsedInContext() throws CoreException {
        return this.getFirstIncludedBy();
    }

    public void setFirstIncludedBy(PDOMInclude includedBy) throws CoreException {
        int rec = includedBy != null ? includedBy.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 8, rec);
    }

    public PDOMMacro getFirstMacro() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 12);
        return rec != 0 ? new PDOMMacro(this.pdom, rec) : null;
    }

    public void setFirstMacro(PDOMMacro macro) throws CoreException {
        int rec = macro != null ? macro.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 12, rec);
    }

    public void addMacros(IASTPreprocessorMacroDefinition[] macros) throws CoreException {
        if (!$assertionsDisabled && this.getFirstMacro() != null) {
            throw new AssertionError();
        }
        PDOMMacro lastMacro = null;
        int i = 0;
        while (i < macros.length) {
            IASTPreprocessorMacroDefinition macro = macros[i];
            PDOMMacro pdomMacro = new PDOMMacro(this.pdom, macro, this);
            if (lastMacro == null) {
                this.setFirstMacro(pdomMacro);
            } else {
                lastMacro.setNextMacro(pdomMacro);
            }
            lastMacro = pdomMacro;
            ++i;
        }
    }

    public void addNames(IASTName[][] names) throws CoreException {
        if (!$assertionsDisabled && this.getFirstName() != null) {
            throw new AssertionError();
        }
        HashMap<IASTName, PDOMName> nameCache = new HashMap<IASTName, PDOMName>();
        PDOMName lastName = null;
        int i = 0;
        while (i < names.length) {
            PDOMName caller;
            PDOMName pdomName;
            IASTName[] name = names[i];
            if (name[0] != null && (pdomName = this.createPDOMName(name[0], caller = (PDOMName)nameCache.get(name[1]))) != null) {
                nameCache.put(name[0], pdomName);
                if (lastName == null) {
                    this.setFirstName(pdomName);
                } else {
                    lastName.setNextInFile(pdomName);
                }
                lastName = pdomName;
            }
            ++i;
        }
    }

    private PDOMName createPDOMName(IASTName name, PDOMName caller) {
        PDOMName result = null;
        try {
            PDOMBinding binding = ((WritablePDOM)this.pdom).addBinding(name);
            if (binding != null) {
                result = new PDOMName(this.pdom, name, this, binding, caller);
                binding.getLinkageImpl().onCreateName(result, name);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return result;
    }

    public void clear(Collection contextsRemoved) throws CoreException {
        PDOMInclude include = this.getFirstInclude();
        while (include != null) {
            PDOMInclude nextInclude = include.getNextInIncludes();
            if (contextsRemoved != null && include.getPrevInIncludedByRecord() == 0) {
                contextsRemoved.add(include.getIncludesLocation());
            }
            include.delete();
            include = nextInclude;
        }
        this.setFirstInclude(include);
        PDOMMacro macro = this.getFirstMacro();
        while (macro != null) {
            PDOMMacro nextMacro = macro.getNextMacro();
            macro.delete();
            macro = nextMacro;
        }
        this.setFirstMacro(null);
        ArrayList<PDOMName> names = new ArrayList<PDOMName>();
        PDOMName name = this.getFirstName();
        while (name != null) {
            names.add(name);
            name.getPDOMBinding().getLinkageImpl().onDeleteName(name);
            name = name.getNextInFile();
        }
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            name = (PDOMName)iterator.next();
            name.delete();
        }
        this.setFirstName(null);
    }

    public void addIncludesTo(IWritableIndex.IncludeInformation[] includeInfos) throws CoreException {
        if (!$assertionsDisabled && this.getFirstInclude() != null) {
            throw new AssertionError();
        }
        PDOMInclude lastInclude = null;
        int i = 0;
        while (i < includeInfos.length) {
            IWritableIndex.IncludeInformation info = includeInfos[i];
            PDOMFile targetFile = (PDOMFile)info.fTargetFile;
            PDOMInclude pdomInclude = new PDOMInclude(this.pdom, info.fStatement, this, targetFile);
            if (targetFile != null) {
                if (!$assertionsDisabled && !(targetFile.getIndexFragment() instanceof IWritableIndexFragment)) {
                    throw new AssertionError();
                }
                targetFile.addIncludedBy(pdomInclude, info.fIsContext);
            }
            if (lastInclude == null) {
                this.setFirstInclude(pdomInclude);
            } else {
                lastInclude.setNextInIncludes(pdomInclude);
            }
            lastInclude = pdomInclude;
            ++i;
        }
    }

    public void addIncludedBy(PDOMInclude include, boolean isContext) throws CoreException {
        PDOMInclude firstIncludedBy = this.getFirstIncludedBy();
        if (firstIncludedBy != null) {
            if (isContext) {
                this.setFirstIncludedBy(include);
                include.setNextInIncludedBy(firstIncludedBy);
                firstIncludedBy.setPrevInIncludedBy(include);
            } else {
                PDOMInclude secondIncludedBy = firstIncludedBy.getNextInIncludedBy();
                if (secondIncludedBy != null) {
                    include.setNextInIncludedBy(secondIncludedBy);
                    secondIncludedBy.setPrevInIncludedBy(include);
                }
                include.setPrevInIncludedBy(firstIncludedBy);
                firstIncludedBy.setNextInIncludedBy(include);
            }
        } else {
            this.setFirstIncludedBy(include);
        }
    }

    public IIndexInclude[] getIncludes() throws CoreException {
        ArrayList<PDOMInclude> result = new ArrayList<PDOMInclude>();
        PDOMInclude include = this.getFirstInclude();
        while (include != null) {
            result.add(include);
            include = include.getNextInIncludes();
        }
        return result.toArray(new IIndexInclude[result.size()]);
    }

    public IIndexMacro[] getMacros() throws CoreException {
        ArrayList<PDOMMacro> result = new ArrayList<PDOMMacro>();
        PDOMMacro macro = this.getFirstMacro();
        while (macro != null) {
            result.add(macro);
            macro = macro.getNextMacro();
        }
        return result.toArray(new IIndexMacro[result.size()]);
    }

    public IIndexFragment getIndexFragment() {
        return this.pdom;
    }

    public IIndexName[] findNames(int offset, int length) throws CoreException {
        ArrayList<PDOMName> result = new ArrayList<PDOMName>();
        PDOMName name = this.getFirstName();
        while (name != null) {
            int nameOffset = name.getNodeOffset();
            if (nameOffset >= offset) {
                if (nameOffset == offset) {
                    if (name.getNodeLength() == length) {
                        result.add(name);
                    }
                } else if (name.isReference()) break;
            }
            name = name.getNextInFile();
        }
        return result.toArray(new IIndexName[result.size()]);
    }

    public static IIndexFragmentFile findFile(PDOM pdom, BTree btree, IIndexFileLocation location, IIndexLocationConverter strategy) throws CoreException {
        String internalRepresentation = strategy.toInternalFormat(location);
        int record = 0;
        if (internalRepresentation != null) {
            Finder finder = new Finder(pdom.getDB(), internalRepresentation);
            btree.accept(finder);
            record = finder.getRecord();
        }
        return record != 0 ? new PDOMFile(pdom, record) : null;
    }

    public IIndexFileLocation getLocation() throws CoreException {
        Database db = this.pdom.getDB();
        String raw = db.getString(db.getInt(this.record + 16)).getString();
        IIndexFileLocation result = this.pdom.getLocationConverter().fromInternalFormat(raw);
        if (result == null) {
            throw new CoreException(CCorePlugin.createStatus(String.valueOf(Messages.getString("PDOMFile.toExternalProblem")) + raw));
        }
        return result;
    }

    public boolean hasNames() throws CoreException {
        return this.getFirstName() != null;
    }

    public void convertIncludersToUnresolved() throws CoreException {
        PDOMInclude include = this.getFirstIncludedBy();
        while (include != null) {
            PDOMInclude nextInclude = include.getNextInIncludedBy();
            include.convertToUnresolved();
            include.setNextInIncludedBy(null);
            include.setPrevInIncludedBy(null);
            include = nextInclude;
        }
        this.setFirstIncludedBy(null);
    }

    public static class Comparator
    implements IBTreeComparator {
        private Database db;

        public Comparator(Database db) {
            this.db = db;
        }

        public int compare(int record1, int record2) throws CoreException {
            IString name1 = this.db.getString(this.db.getInt(record1 + 16));
            IString name2 = this.db.getString(this.db.getInt(record2 + 16));
            return name1.compare(name2, true);
        }
    }

    private static class Finder
    implements IBTreeVisitor {
        private final Database db;
        private final String rawKey;
        private int record;

        public Finder(Database db, String internalRepresentation) throws CoreException {
            this.db = db;
            this.rawKey = internalRepresentation;
        }

        public int compare(int record) throws CoreException {
            IString name = this.db.getString(this.db.getInt(record + 16));
            return name.compare(this.rawKey, true);
        }

        public boolean visit(int record) throws CoreException {
            this.record = record;
            return false;
        }

        public int getRecord() {
            return this.record;
        }
    }
}

