/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionStyleMacroParameter;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.FunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectStyleMacro;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroParameter;
import org.eclipse.core.runtime.CoreException;

public class PDOMMacro
implements IIndexMacro,
IASTFileLocation {
    private final PDOM pdom;
    private final int record;
    private IMacro macro;
    private static final int NAME = 0;
    private static final int FILE = 4;
    private static final int NAME_OFFSET = 8;
    private static final int NAME_LENGTH = 12;
    private static final int FIRST_PARAMETER = 14;
    private static final int EXPANSION = 18;
    private static final int NEXT_MACRO = 22;
    private static final int RECORD_SIZE = 26;

    public PDOMMacro(PDOM pdom, int record) {
        this.pdom = pdom;
        this.record = record;
    }

    public PDOMMacro(PDOM pdom, IASTPreprocessorMacroDefinition macro, PDOMFile file) throws CoreException {
        this.pdom = pdom;
        Database db = pdom.getDB();
        this.record = db.malloc(26);
        IASTName name = macro.getName();
        db.putInt(this.record + 0, db.newString(name.toCharArray()).getRecord());
        db.putInt(this.record + 4, file.getRecord());
        IASTFileLocation fileloc = name.getFileLocation();
        db.putInt(this.record + 8, fileloc.getNodeOffset());
        db.putShort(this.record + 12, (short)fileloc.getNodeLength());
        db.putInt(this.record + 18, db.newString(macro.getExpansion()).getRecord());
        this.setNextMacro(0);
        PDOMMacroParameter last = null;
        if (macro instanceof IASTPreprocessorFunctionStyleMacroDefinition) {
            IASTPreprocessorFunctionStyleMacroDefinition func = (IASTPreprocessorFunctionStyleMacroDefinition)macro;
            IASTFunctionStyleMacroParameter[] params = func.getParameters();
            int i = params.length - 1;
            while (i >= 0) {
                IASTFunctionStyleMacroParameter param = params[i];
                PDOMMacroParameter pdomParam = new PDOMMacroParameter(pdom, param.getParameter());
                if (last != null) {
                    pdomParam.setNextParameter(last);
                }
                last = pdomParam;
                --i;
            }
        }
        db.putInt(this.record + 14, last != null ? last.getRecord() : 0);
    }

    public int getRecord() {
        return this.record;
    }

    public void delete() throws CoreException {
        this.getNameInDB().delete();
        this.getExpansionInDB().delete();
        PDOMMacroParameter param = this.getFirstParameter();
        if (param != null) {
            param.delete();
        }
        this.pdom.getDB().free(this.record);
    }

    public IString getNameInDB() throws CoreException {
        Database db = this.pdom.getDB();
        int rec = db.getInt(this.record + 0);
        return db.getString(rec);
    }

    public IString getExpansionInDB() throws CoreException {
        Database db = this.pdom.getDB();
        int rec = db.getInt(this.record + 18);
        return db.getString(rec);
    }

    public PDOMMacro getNextMacro() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 22);
        return rec != 0 ? new PDOMMacro(this.pdom, rec) : null;
    }

    public void setNextMacro(PDOMMacro macro) throws CoreException {
        this.setNextMacro(macro != null ? macro.getRecord() : 0);
    }

    public void setNextMacro(int rec) throws CoreException {
        this.pdom.getDB().putInt(this.record + 22, rec);
    }

    public PDOMMacroParameter getFirstParameter() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 14);
        return rec != 0 ? new PDOMMacroParameter(this.pdom, rec) : null;
    }

    private char[] getMacroExpansion() {
        try {
            return this.getExpansionInDB().getChars();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[]{' '};
        }
    }

    public IMacro getMacro() throws CoreException {
        this.rebuildMacro();
        return this.macro;
    }

    private void rebuildMacro() throws CoreException {
        char[] name = this.getNameInDB().getChars();
        PDOMMacroParameter param = this.getFirstParameter();
        if (param != null) {
            ArrayList<char[]> paramList = new ArrayList<char[]>();
            while (param != null) {
                paramList.add(param.getName().getChars());
                param = param.getNextParameter();
            }
            char[][] params = (char[][])paramList.toArray((T[])new char[paramList.size()][]);
            this.macro = new FunctionStylePDOMMacro(name, params);
        } else {
            this.macro = new ObjectStylePDOMMacro(name);
        }
    }

    public char[] getSignature() {
        try {
            this.rebuildMacro();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[]{' '};
        }
        return this.macro.getSignature();
    }

    public char[] getExpansion() {
        try {
            this.rebuildMacro();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[]{' '};
        }
        return this.macro.getExpansion();
    }

    public char[] getName() {
        try {
            this.rebuildMacro();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[]{' '};
        }
        return this.macro.getName();
    }

    public IIndexFile getFile() throws CoreException {
        int filerec = this.pdom.getDB().getInt(this.record + 4);
        return filerec != 0 ? new PDOMFile(this.pdom, filerec) : null;
    }

    public int getEndingLineNumber() {
        return 0;
    }

    public String getFileName() {
        try {
            URI uri;
            PDOMFile file = (PDOMFile)this.getFile();
            if (file != null && "file".equals((uri = file.getLocation().getURI()).getScheme())) {
                return uri.getSchemeSpecificPart();
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    public int getStartingLineNumber() {
        return 0;
    }

    public IASTFileLocation asFileLocation() {
        return this;
    }

    public IASTFileLocation getFileLocation() {
        return this;
    }

    public int getNodeLength() {
        try {
            return this.pdom.getDB().getShort(this.record + 12);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    public int getNodeOffset() {
        try {
            return this.pdom.getDB().getInt(this.record + 8);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    private class FunctionStylePDOMMacro
    extends FunctionStyleMacro
    implements IIndexMacro {
        public FunctionStylePDOMMacro(char[] name, char[][] arglist) {
            super(name, null, arglist);
        }

        public char[] getExpansion() {
            return PDOMMacro.this.getMacroExpansion();
        }

        public IASTFileLocation getFileLocation() {
            return PDOMMacro.this;
        }
    }

    private class ObjectStylePDOMMacro
    extends ObjectStyleMacro
    implements IIndexMacro {
        public ObjectStylePDOMMacro(char[] name) {
            super(name, null);
        }

        public char[] getExpansion() {
            return PDOMMacro.this.getMacroExpansion();
        }

        public IASTFileLocation getFileLocation() {
            return PDOMMacro.this;
        }
    }
}

