/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.core.runtime.CoreException;

public class PDOMName
implements IIndexFragmentName,
IASTFileLocation {
    private final PDOM pdom;
    private final int record;
    private static final int FILE_REC_OFFSET = 0;
    private static final int FILE_NEXT_OFFSET = 4;
    private static final int CALLER_REC_OFFSET = 8;
    private static final int BINDING_REC_OFFSET = 12;
    private static final int BINDING_PREV_OFFSET = 16;
    private static final int BINDING_NEXT_OFFSET = 20;
    private static final int NODE_OFFSET_OFFSET = 24;
    private static final int NODE_LENGTH_OFFSET = 28;
    private static final int FLAGS = 30;
    private static final int RECORD_SIZE = 31;
    private static final int IS_DECLARATION = 1;
    private static final int IS_DEFINITION = 2;
    private static final int IS_REFERENCE = 3;
    private static final int DECL_DEF_REF_MASK = 3;
    private static final int IS_INHERITANCE_SPEC = 4;

    public PDOMName(PDOM pdom, IASTName name, PDOMFile file, PDOMBinding binding, PDOMName caller) throws CoreException {
        this.pdom = pdom;
        Database db = pdom.getDB();
        this.record = db.malloc(31);
        byte flags = 0;
        flags = name.isDefinition() ? (byte)2 : (name.isDeclaration() ? (byte)1 : 3);
        db.putByte(this.record + 30, flags);
        if (binding != null) {
            switch (flags) {
                case 2: {
                    binding.addDefinition(this);
                    break;
                }
                case 1: {
                    binding.addDeclaration(this);
                    break;
                }
                case 3: {
                    binding.addReference(this);
                }
            }
            db.putInt(this.record + 12, binding.getRecord());
        }
        db.putInt(this.record + 0, file.getRecord());
        if (caller != null) {
            db.putInt(this.record + 8, caller.getRecord());
        }
        IASTFileLocation fileloc = name.getFileLocation();
        db.putInt(this.record + 24, fileloc.getNodeOffset());
        db.putShort(this.record + 28, (short)fileloc.getNodeLength());
    }

    public PDOMName(PDOM pdom, int nameRecord) {
        this.pdom = pdom;
        this.record = nameRecord;
    }

    public int getRecord() {
        return this.record;
    }

    private int getRecField(int offset) throws CoreException {
        return this.pdom.getDB().getInt(this.record + offset);
    }

    private void setRecField(int offset, int fieldrec) throws CoreException {
        this.pdom.getDB().putInt(this.record + offset, fieldrec);
    }

    public PDOMBinding getPDOMBinding() throws CoreException {
        int bindingrec = this.getRecField(12);
        return this.pdom.getBinding(bindingrec);
    }

    public void setBinding(PDOMBinding binding) throws CoreException {
        int bindingrec = binding != null ? binding.getRecord() : 0;
        this.setRecField(12, bindingrec);
    }

    private PDOMName getNameField(int offset) throws CoreException {
        int namerec = this.getRecField(offset);
        return namerec != 0 ? new PDOMName(this.pdom, namerec) : null;
    }

    private void setNameField(int offset, PDOMName name) throws CoreException {
        int namerec = name != null ? name.getRecord() : 0;
        this.setRecField(offset, namerec);
    }

    public PDOMName getPrevInBinding() throws CoreException {
        return this.getNameField(16);
    }

    public void setPrevInBinding(PDOMName name) throws CoreException {
        this.setNameField(16, name);
    }

    public PDOMName getNextInBinding() throws CoreException {
        return this.getNameField(20);
    }

    public void setNextInBinding(PDOMName name) throws CoreException {
        this.setNameField(20, name);
    }

    public IIndexFile getFile() throws CoreException {
        int filerec = this.pdom.getDB().getInt(this.record + 0);
        return filerec != 0 ? new PDOMFile(this.pdom, filerec) : null;
    }

    public IIndexName getEnclosingDefinition() throws CoreException {
        int namerec = this.getEnclosingDefinitionRecord();
        return namerec != 0 ? new PDOMName(this.pdom, namerec) : null;
    }

    int getEnclosingDefinitionRecord() throws CoreException {
        return this.pdom.getDB().getInt(this.record + 8);
    }

    public PDOMName getNextInFile() throws CoreException {
        return this.getNameField(4);
    }

    public void setNextInFile(PDOMName name) throws CoreException {
        this.setNameField(4, name);
    }

    public char[] toCharArray() {
        try {
            Database db = this.pdom.getDB();
            int bindingRec = db.getInt(this.record + 12);
            PDOMBinding binding = this.pdom.getBinding(bindingRec);
            return binding != null ? binding.getNameCharArray() : null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public String toString() {
        try {
            Database db = this.pdom.getDB();
            int bindingRec = db.getInt(this.record + 12);
            PDOMBinding binding = this.pdom.getBinding(bindingRec);
            return binding != null ? binding.getName() : null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    private byte getFlags(int mask) throws CoreException {
        return (byte)(this.pdom.getDB().getByte(this.record + 30) & mask);
    }

    public void setIsBaseSpecifier(boolean val) throws CoreException {
        byte flags = this.getFlags(255);
        flags = val ? (byte)(flags | 4) : (byte)(flags & 0xFFFFFFFB);
        this.pdom.getDB().putByte(this.record + 30, flags);
    }

    public boolean isBaseSpecifier() throws CoreException {
        return this.getFlags(4) == 4;
    }

    public boolean isDeclaration() {
        try {
            byte flags = this.getFlags(3);
            return flags == 1 || flags == 2;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public boolean isReference() {
        try {
            byte flags = this.getFlags(3);
            return flags == 3;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public boolean isDefinition() {
        try {
            byte flags = this.getFlags(3);
            return flags == 2;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public IASTFileLocation getFileLocation() {
        return this;
    }

    public String getFileName() {
        try {
            URI uri;
            PDOMFile file = (PDOMFile)this.getFile();
            if (file != null && "file".equals((uri = file.getLocation().getURI()).getScheme())) {
                return uri.getSchemeSpecificPart();
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    public int getStartingLineNumber() {
        return 0;
    }

    public int getEndingLineNumber() {
        return 0;
    }

    public IASTFileLocation asFileLocation() {
        return this;
    }

    public int getNodeLength() {
        try {
            return this.pdom.getDB().getShort(this.record + 28);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    public int getNodeOffset() {
        try {
            return this.pdom.getDB().getInt(this.record + 24);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    public void delete() throws CoreException {
        PDOMName prevName = this.getPrevInBinding();
        PDOMName nextName = this.getNextInBinding();
        if (prevName != null) {
            prevName.setNextInBinding(nextName);
        } else {
            switch (this.getFlags(3)) {
                case 1: {
                    this.getPDOMBinding().setFirstDeclaration(nextName);
                    break;
                }
                case 2: {
                    this.getPDOMBinding().setFirstDefinition(nextName);
                    break;
                }
                case 3: {
                    this.getPDOMBinding().setFirstReference(nextName);
                }
            }
        }
        if (nextName != null) {
            nextName.setPrevInBinding(prevName);
        }
        this.pdom.getDB().free(this.record);
    }

    public IIndexFragment getIndexFragment() {
        return this.pdom;
    }

    public IIndexFragmentBinding getBinding() throws CoreException {
        return this.getPDOMBinding();
    }

    public IIndexName[] getEnclosedNames() throws CoreException {
        ArrayList<PDOMName> result = new ArrayList<PDOMName>();
        PDOMName name = this.getNextInFile();
        while (name != null) {
            if (name.getEnclosingDefinitionRecord() == this.record) {
                result.add(name);
            }
            name = name.getNextInFile();
        }
        return result.toArray(new IIndexName[result.size()]);
    }
}

