/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.model.ICProject;

public abstract class AbstractPDOMIndexer
implements IPDOMIndexer {
    protected ICProject project;
    protected Properties fProperties = new Properties();

    public AbstractPDOMIndexer() {
        this.fProperties.put("indexAllFiles", String.valueOf(false));
        this.fProperties.put("filesToParseUpFront", "");
        this.fProperties.put("skipReferences", String.valueOf(false));
        this.fProperties.put("skipTypeReferences", String.valueOf(false));
    }

    public ICProject getProject() {
        return this.project;
    }

    public void setProject(ICProject project) {
        this.project = project;
    }

    public String getProperty(String key) {
        return this.fProperties.getProperty(key);
    }

    public boolean needsToRebuildForProperties(Properties props) {
        Iterator<Map.Entry<Object, Object>> i = this.fProperties.entrySet().iterator();
        while (i.hasNext()) {
            String v2;
            Map.Entry<Object, Object> entry = i.next();
            String key = (String)entry.getKey();
            String myval = (String)entry.getValue();
            if (myval == null || (v2 = (String)props.get(key)) == null || myval.equals(v2)) continue;
            return true;
        }
        return false;
    }

    public void setProperties(Properties props) {
        Iterator<Map.Entry<Object, Object>> i = props.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (val == null || this.fProperties.get(key) == null) continue;
            this.fProperties.put(key, val);
        }
    }

    public String[] getFilesToParseUpFront() {
        String prefSetting = this.getProperty("filesToParseUpFront");
        if (prefSetting != null && (prefSetting = prefSetting.trim()).length() > 0) {
            return prefSetting.split(",");
        }
        return new String[0];
    }
}

