/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.cdt.internal.core.pdom.indexer.Messages;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMIndexerTask;
import org.eclipse.cdt.internal.core.pdom.indexer.TranslationUnitCollector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class PDOMUpdateTask
implements IPDOMIndexerTask {
    protected static final String TRUE = String.valueOf(true);
    protected static final ITranslationUnit[] NO_TUS = new ITranslationUnit[0];
    private final IPDOMIndexer fIndexer;
    private final IndexerProgress fProgress;
    private final int fUpdateOptions;
    private volatile IPDOMIndexerTask fDelegate;
    private ArrayList fFilesAndFolders = null;

    public PDOMUpdateTask(IPDOMIndexer indexer, int updateOptions) {
        this.fIndexer = indexer;
        this.fProgress = this.createProgress();
        this.fUpdateOptions = updateOptions;
    }

    private IndexerProgress createProgress() {
        IndexerProgress progress = new IndexerProgress();
        progress.fTimeEstimate = 1000;
        return progress;
    }

    public IPDOMIndexer getIndexer() {
        return this.fIndexer;
    }

    public void run(IProgressMonitor monitor) {
        monitor.subTask(NLS.bind((String)Messages.PDOMIndexerTask_collectingFilesTask, (Object)this.fIndexer.getProject().getElementName()));
        ICProject project = this.fIndexer.getProject();
        if (project.getProject().isOpen()) {
            try {
                if (!"org.eclipse.cdt.core.nullindexer".equals(this.fIndexer.getID())) {
                    this.createDelegate(project, monitor);
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        if (this.fDelegate != null) {
            this.fDelegate.run(monitor);
        }
    }

    private synchronized void createDelegate(ICProject project, IProgressMonitor monitor) throws CoreException {
        boolean allFiles = TRUE.equals(this.fIndexer.getProperty("indexAllFiles"));
        HashSet set = new HashSet();
        TranslationUnitCollector collector = new TranslationUnitCollector(set, set, allFiles, monitor);
        if (this.fFilesAndFolders == null) {
            project.accept(collector);
        } else {
            Iterator iterator = this.fFilesAndFolders.iterator();
            while (iterator.hasNext()) {
                ICElement elem = (ICElement)iterator.next();
                elem.accept(collector);
            }
        }
        ITranslationUnit[] tus = set.toArray(new ITranslationUnit[set.size()]);
        this.fDelegate = this.fIndexer.createTask(tus, NO_TUS, NO_TUS);
        if (this.fDelegate instanceof PDOMIndexerTask) {
            PDOMIndexerTask task = (PDOMIndexerTask)this.fDelegate;
            task.setUpateFlags(this.fUpdateOptions);
            task.setAllFilesProvided(allFiles);
        }
    }

    public synchronized IndexerProgress getProgressInformation() {
        return this.fDelegate != null ? this.fDelegate.getProgressInformation() : this.fProgress;
    }

    public void setTranslationUnitSelection(List filesAndFolders) {
        this.fFilesAndFolders = new ArrayList(filesAndFolders.size());
        this.fFilesAndFolders.addAll(filesAndFolders);
    }
}

