/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.util.Collection;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

final class TranslationUnitCollector
implements ICElementVisitor {
    private final Collection fSources;
    private final Collection fHeaders;
    private final boolean fAllFiles;
    private final IProgressMonitor fProgressMonitor;

    public TranslationUnitCollector(Collection sources, Collection headers, boolean allFiles, IProgressMonitor pm) {
        this.fSources = sources;
        this.fHeaders = headers;
        this.fAllFiles = allFiles;
        this.fProgressMonitor = pm;
    }

    public boolean visit(ICElement element) throws CoreException {
        if (this.fProgressMonitor.isCanceled()) {
            return false;
        }
        switch (element.getElementType()) {
            case 60: {
                ITranslationUnit tu = (ITranslationUnit)element;
                if (tu.isSourceUnit()) {
                    if (this.fAllFiles || !CoreModel.isScannerInformationEmpty(tu.getResource())) {
                        this.fSources.add(tu);
                    }
                } else if (this.fHeaders != null && tu.isHeaderUnit()) {
                    this.fHeaders.add(tu);
                }
                return false;
            }
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }
}

