/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.errorparsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class ErrorPattern {
    private final Pattern pattern;
    private final int groupFileName;
    private final int groupLineNum;
    private final int groupDesc;
    private final int groupVarName;
    private final int severity;

    public ErrorPattern(String pattern, int groupFileName, int groupLineNum, int groupDesc, int groupVarName, int severity) {
        this.pattern = Pattern.compile(pattern);
        this.groupFileName = groupFileName;
        this.groupLineNum = groupLineNum;
        this.groupDesc = groupDesc;
        this.groupVarName = groupVarName;
        this.severity = severity;
    }

    public ErrorPattern(String pattern, int groupDesc, int severity) {
        this(pattern, 0, 0, groupDesc, 0, severity);
    }

    public ErrorPattern(String pattern) {
        this(pattern, 0, 0, 0, 0, -1);
    }

    public Matcher getMatcher(CharSequence input) {
        return this.pattern.matcher(input);
    }

    public String getFileName(Matcher matcher) {
        return this.groupFileName != 0 ? matcher.group(this.groupFileName) : null;
    }

    public int getLineNum(Matcher matcher) {
        try {
            return this.groupLineNum != 0 ? Integer.valueOf(matcher.group(this.groupLineNum)) : 0;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getDesc(Matcher matcher) {
        return this.groupDesc != 0 ? matcher.group(this.groupDesc) : null;
    }

    public String getVarName(Matcher matcher) {
        return this.groupVarName != 0 ? matcher.group(this.groupVarName) : null;
    }

    public int getSeverity(Matcher matcher) {
        return this.severity;
    }

    public boolean processLine(String line, ErrorParserManager eoParser) {
        Matcher matcher = this.getMatcher(line);
        if (!matcher.find()) {
            return false;
        }
        return this.recordError(matcher, eoParser);
    }

    protected boolean recordError(Matcher matcher, ErrorParserManager eoParser) {
        int severity = this.getSeverity(matcher);
        if (severity == -1) {
            return true;
        }
        String fileName = this.getFileName(matcher);
        int lineNum = this.getLineNum(matcher);
        String desc = this.getDesc(matcher);
        String varName = this.getVarName(matcher);
        IPath externalPath = null;
        IFile file = null;
        if (fileName != null) {
            file = eoParser.findFileName(fileName);
            if (file == null || eoParser.isConflictingName(fileName)) {
                file = eoParser.findFilePath(fileName);
            }
            if (file == null) {
                desc = String.valueOf(fileName) + " " + desc;
                file = eoParser.getProject();
                externalPath = this.getLocation(fileName);
            }
        }
        eoParser.generateExternalMarker((IResource)file, lineNum, desc, severity, varName, externalPath);
        return true;
    }

    /*
     * Exception decompiling
     */
    protected IPath getLocation(String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 84->87)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

