/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.cdt.core.CCorePlugin;
import org.osgi.framework.Bundle;

public final class Platform {
    public static final String OS_LINUX = "linux";
    private static String cachedArch = null;

    public static Bundle getBundle(String symbolicName) {
        return org.eclipse.core.runtime.Platform.getBundle((String)symbolicName);
    }

    public static String getOS() {
        return org.eclipse.core.runtime.Platform.getOS();
    }

    public static String getOSArch() {
        if (cachedArch == null) {
            String arch = org.eclipse.core.runtime.Platform.getOSArch();
            if (arch.equals("ppc")) {
                String[] cmd = new String[]{"uname", "-p"};
                try {
                    Process unameProcess = Runtime.getRuntime().exec(cmd);
                    InputStreamReader inputStreamReader = new InputStreamReader(unameProcess.getInputStream());
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    String unameOutput = bufferedReader.readLine();
                    if (unameOutput != null) {
                        arch = unameOutput;
                    }
                    bufferedReader.close();
                    unameProcess.waitFor();
                }
                catch (IOException e) {
                    CCorePlugin.log(e);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            } else if (arch.equals("x86")) {
                String[] cmd = "win32".equals(Platform.getOS()) ? new String[]{"cmd", "/c", "set", "PROCESSOR_ARCHITECTURE"} : new String[]{"uname", "-p"};
                try {
                    Process unameProcess = Runtime.getRuntime().exec(cmd);
                    InputStreamReader inputStreamReader = new InputStreamReader(unameProcess.getInputStream());
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    String unameOutput = bufferedReader.readLine();
                    if (unameOutput != null && unameOutput.endsWith("64")) {
                        arch = "x86_64";
                    }
                    bufferedReader.close();
                    unameProcess.waitFor();
                }
                catch (IOException e) {
                    CCorePlugin.log(e);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            cachedArch = arch;
        }
        return cachedArch;
    }
}

