/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.IInternalCDebugUIConstants;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyDocumentProvider;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointRulerAction
extends Action {
    private IVerticalRulerInfo fRuler;
    private IWorkbenchPart fTargetPart;
    private IToggleBreakpointsTarget fTargetAdapter;
    private static final ISelection EMPTY_SELECTION = new EmptySelection();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ToggleBreakpointRulerAction(IWorkbenchPart part, IVerticalRulerInfo ruler) {
        super(ActionMessages.getString("ToggleBreakpointRulerAction.Toggle_Breakpoint_1"));
        this.fRuler = ruler;
        this.setTargetPart(part);
        part.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp((IAction)this, ICDebugHelpContextIds.TOGGLE_BREAKPOINT_ACTION);
        this.setId(IInternalCDebugUIConstants.ACTION_TOGGLE_BREAKPOINT);
    }

    public void dispose() {
        this.setTargetPart(null);
        this.fRuler = null;
    }

    public void run() {
        try {
            this.fTargetAdapter.toggleLineBreakpoints(this.getTargetPart(), this.getTargetSelection());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getTargetPart().getSite().getShell(), (String)ActionMessages.getString("ToggleBreakpointRulerAction.Error_1"), (String)ActionMessages.getString("ToggleBreakpointRulerAction.Operation_failed_1"), (IStatus)e.getStatus());
        }
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }

    private IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    private void setTargetPart(IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
        if (this.fTargetPart != null) {
            IResource resource;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)this.fTargetPart.getAdapter((Class)clazz)) == null && this.fTargetPart instanceof IEditorPart) {
                IEditorInput iEditorInput = ((IEditorPart)this.fTargetPart).getEditorInput();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = (IResource)iEditorInput.getAdapter((Class)clazz2);
            }
            if (resource != null) {
                this.fTargetAdapter = this.getAdapter((IAdaptable)resource);
            }
            if (this.fTargetAdapter == null) {
                this.fTargetAdapter = this.getAdapter((IAdaptable)this.fTargetPart);
            }
        }
        if (this.fTargetAdapter == null) {
            this.fTargetAdapter = new ToggleBreakpointAdapter();
        }
    }

    private IToggleBreakpointsTarget getAdapter(IAdaptable adaptable) {
        IToggleBreakpointsTarget adapter;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.debug.ui.actions.IToggleBreakpointsTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (IToggleBreakpointsTarget)adaptable.getAdapter((Class)clazz)) == null) {
            IAdapterManager adapterManager = Platform.getAdapterManager();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.debug.ui.actions.IToggleBreakpointsTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapterManager.hasAdapter((Object)adaptable, clazz2.getName())) {
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("org.eclipse.debug.ui.actions.IToggleBreakpointsTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                adapter = (IToggleBreakpointsTarget)adapterManager.loadAdapter((Object)adaptable, clazz3.getName());
            }
        }
        return adapter;
    }

    private ISelection getTargetSelection() {
        IDocument doc = this.getDocument();
        if (doc != null) {
            int line = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity();
            try {
                IRegion region = doc.getLineInformation(line);
                return new TextSelection(doc, region.getOffset(), region.getLength());
            }
            catch (BadLocationException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
        return EMPTY_SELECTION;
    }

    private IDocument getDocument() {
        DisassemblyView dv;
        DisassemblyDocumentProvider provider;
        IWorkbenchPart targetPart = this.getTargetPart();
        if (targetPart instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)targetPart;
            IDocumentProvider provider2 = textEditor.getDocumentProvider();
            if (provider2 != null) {
                return provider2.getDocument((Object)textEditor.getEditorInput());
            }
        } else if (targetPart instanceof DisassemblyView && (provider = (dv = (DisassemblyView)targetPart).getDocumentProvider()) != null) {
            return provider.getDocument(dv.getInput());
        }
        return null;
    }

    static class EmptySelection
    implements ISelection {
        EmptySelection() {
        }

        public boolean isEmpty() {
            return true;
        }
    }
}

