/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import java.util.ArrayList;
import org.eclipse.cdt.debug.internal.core.CMemoryBlockRetrievalExtension;
import org.eclipse.cdt.debug.internal.ui.views.memory.Messages;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AddMemoryBlockDialog
extends TrayDialog
implements ModifyListener,
SelectionListener {
    private Combo fAddressInput;
    private Button fAddressRadio;
    private Combo fMemorySpaceInput;
    private Combo fExpressionInput;
    private String fExpression;
    private Button fExpressionRadio;
    private String fAddress;
    private String fMemorySpace;
    private boolean fEnteredExpression;
    private CMemoryBlockRetrievalExtension fMemRetrieval;
    private static ArrayList sAddressHistory = new ArrayList();
    private static ArrayList sExpressionHistory = new ArrayList();

    public AddMemoryBlockDialog(Shell parentShell, IMemoryBlockRetrieval memRetrieval) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        if (memRetrieval instanceof CMemoryBlockRetrievalExtension) {
            this.fMemRetrieval = (CMemoryBlockRetrievalExtension)memRetrieval;
        }
    }

    protected Control createDialogArea(Composite parent) {
        int i;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.debug.ui.MonitorMemoryBlockDialog_context");
        GridLayout gridLayout = new GridLayout();
        parent.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        Composite composite = new Composite(parent, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        parent = composite;
        this.fAddressRadio = new Button(parent, 16);
        int radioButtonWidth = this.fAddressRadio.computeSize((int)-1, (int)-1).x;
        this.fAddressRadio.setText(Messages.AddMemBlockDlg_enterAddrAndMemSpace);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fAddressRadio.setLayoutData((Object)gridData);
        this.fAddressRadio.addSelectionListener((SelectionListener)this);
        this.fMemorySpaceInput = new Combo(parent, 2056);
        gridData = new GridData();
        gridData.horizontalIndent = radioButtonWidth;
        this.fMemorySpaceInput.setLayoutData((Object)gridData);
        this.fMemorySpaceInput.addSelectionListener((SelectionListener)this);
        this.fAddressInput = new Combo(parent, 2048);
        gridData = new GridData(768);
        GC gc = new GC((Drawable)this.fAddressInput);
        FontMetrics fm = gc.getFontMetrics();
        gridData.minimumWidth = gridData.minimumWidth = 18 * fm.getAverageCharWidth() + 25;
        gc.dispose();
        this.fAddressInput.setLayoutData((Object)gridData);
        this.fAddressInput.addModifyListener((ModifyListener)this);
        this.fAddressInput.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = false;
                char c = e.character;
                if (Character.isDigit(c) || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F' || c == 'x' || Character.isISOControl(e.character)) {
                    e.doit = true;
                }
            }
        });
        if (this.fMemRetrieval != null) {
            String[] memorySpaces = this.fMemRetrieval.getMemorySpaces();
            i = 0;
            while (i < memorySpaces.length) {
                this.fMemorySpaceInput.add(memorySpaces[i]);
                ++i;
            }
            if (memorySpaces.length > 0) {
                this.fMemorySpaceInput.select(0);
            }
        }
        this.fExpressionRadio = new Button(parent, 16);
        this.fExpressionRadio.setText(Messages.AddMemBlockDlg_enterExpression);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fExpressionRadio.setLayoutData((Object)gridData);
        this.fExpressionRadio.addSelectionListener((SelectionListener)this);
        this.fExpressionInput = new Combo(parent, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = radioButtonWidth;
        this.fExpressionInput.setLayoutData((Object)gridData);
        String[] history = AddMemoryBlockDialog.getHistory(sExpressionHistory);
        i = 0;
        while (i < history.length) {
            this.fExpressionInput.add(history[i]);
            ++i;
        }
        history = AddMemoryBlockDialog.getHistory(sAddressHistory);
        i = 0;
        while (i < history.length) {
            this.fAddressInput.add(history[i]);
            ++i;
        }
        this.fExpressionInput.addModifyListener((ModifyListener)this);
        return parent;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AddMemBlockDlg_MonitorMemory);
    }

    protected void okPressed() {
        this.fExpression = this.fExpressionInput.getText();
        this.fAddress = this.fAddressInput.getText();
        this.fMemorySpace = this.fMemorySpaceInput.getText();
        if (this.fExpression.length() > 0) {
            AddMemoryBlockDialog.addHistory(sExpressionHistory, this.fExpression);
        }
        if (this.fAddress.length() > 0) {
            AddMemoryBlockDialog.addHistory(sAddressHistory, this.fAddress);
        }
        this.fEnteredExpression = this.fExpressionRadio.getSelection();
        super.okPressed();
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.fAddressInput || e.widget == this.fExpressionInput) {
            this.fAddressRadio.setSelection(e.widget != this.fExpressionInput);
            this.fExpressionRadio.setSelection(e.widget == this.fExpressionInput);
        }
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    public String getExpression() {
        return this.fExpression;
    }

    public String getAddress() {
        return this.fAddress;
    }

    public String getMemorySpace() {
        return this.fMemorySpace;
    }

    public boolean enteredExpression() {
        return this.fEnteredExpression;
    }

    private static void addHistory(ArrayList list, String item) {
        if (!list.contains(item)) {
            list.add(0, item);
        }
        if (list.size() > 5) {
            list.remove(list.size() - 1);
        }
    }

    private static String[] getHistory(ArrayList list) {
        return list.toArray(new String[list.size()]);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.fMemorySpaceInput) {
            this.fAddressRadio.setSelection(true);
            this.fExpressionRadio.setSelection(false);
        }
    }
}

