/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.cdt.managedbuilder.testplugin.CTestPlugin;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class ManagedBuildDependencyCalculatorTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public ManagedBuildDependencyCalculatorTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.ManagedBuildDependencyCalculatorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        suite.addTest((Test)new ManagedBuildDependencyCalculatorTests("test1DepCalc2"));
        suite.addTest((Test)new ManagedBuildDependencyCalculatorTests("test1DepCalc3"));
        suite.addTest((Test)new ManagedBuildDependencyCalculatorTests("test1DepCalcPreBuild"));
        return suite;
    }

    private IProject[] createProject(String projName, IPath location, String projectTypeId, boolean containsZip) {
        ArrayList<IProject> projectList = null;
        if (containsZip) {
            File testDir = CTestPlugin.getFileInPlugin((IPath)new Path("resources/depCalcProjects/" + projName));
            if (testDir == null) {
                ManagedBuildDependencyCalculatorTests.fail((String)("Test project directory " + projName + " is missing."));
                return null;
            }
            File[] projectZips = testDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return !pathname.isDirectory();
                }
            });
            projectList = new ArrayList(projectZips.length);
            int i = 0;
            while (i < projectZips.length) {
                try {
                    IProject project;
                    String projectName = projectZips[i].getName();
                    if (projectName.endsWith(".zip") && (projectName = projectName.substring(0, projectName.length() - ".zip".length())).length() != 0 && (project = ManagedBuildTestHelper.createProject(projectName, projectZips[i], location, projectTypeId)) != null) {
                        projectList.add(project);
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
            if (projectList.size() == 0) {
                ManagedBuildDependencyCalculatorTests.fail((String)("No projects found in test project directory " + testDir.getName() + ".  The .zip file may be missing or corrupt."));
                return null;
            }
        } else {
            try {
                IProject project = ManagedBuildTestHelper.createProject(projName, null, location, projectTypeId);
                if (project != null) {
                    projectList = new ArrayList<IProject>(1);
                }
                projectList.add(project);
            }
            catch (Exception exception) {}
        }
        return projectList.toArray(new IProject[projectList.size()]);
    }

    private IProject[] createProjects(String projName, IPath location, String projectTypeId, boolean containsZip) {
        IOverwriteQuery queryALL = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "ALL";
            }
        };
        new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "NOALL";
            }
        };
        UpdateManagedProjectManager.setBackupFileOverwriteQuery((IOverwriteQuery)queryALL);
        UpdateManagedProjectManager.setUpdateProjectQuery((IOverwriteQuery)queryALL);
        IProject[] projects = this.createProject(projName, location, projectTypeId, containsZip);
        return projects;
    }

    private void buildProjectsWorker(IProject[] projects, IPath[] files, boolean compareBenchmark) {
        if (projects == null || projects.length == 0) {
            return;
        }
        boolean succeeded = true;
        int i = 0;
        while (i < projects.length) {
            IProject curProject = projects[i];
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)curProject);
            boolean isCompatible = UpdateManagedProjectManager.isCompatibleProject((IManagedBuildInfo)info);
            ManagedBuildDependencyCalculatorTests.assertTrue((boolean)isCompatible);
            if (isCompatible) {
                try {
                    curProject.build(10, null);
                }
                catch (CoreException e) {
                    ManagedBuildDependencyCalculatorTests.fail((String)e.getStatus().getMessage());
                }
                catch (OperationCanceledException e) {
                    ManagedBuildDependencyCalculatorTests.fail((String)("the project \"" + curProject.getName() + "\" build was cancelled, exception message: " + e.getMessage()));
                }
                if (files != null && files.length > 0 && i == 0) {
                    String configName = info.getDefaultConfiguration().getName();
                    IPath buildDir = Path.fromOSString((String)configName);
                    succeeded = compareBenchmark ? ManagedBuildTestHelper.compareBenchmarks(curProject, buildDir, files) : ManagedBuildTestHelper.verifyFilesDoNotExist(curProject, buildDir, files);
                }
            }
            ++i;
        }
        if (succeeded) {
            i = 0;
            while (i < projects.length) {
                ManagedBuildTestHelper.removeProject(projects[i].getName());
                ++i;
            }
        }
    }

    private void buildProjects(IProject[] projects, IPath[] files) {
        this.buildProjectsWorker(projects, files, true);
    }

    public void test1DepCalc2() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"Sources/subdir.mk"), Path.fromOSString((String)"Sources/func1.d"), Path.fromOSString((String)"Sources/func2.d"), Path.fromOSString((String)"Sources/func4.d"), Path.fromOSString((String)"Sources/sub sources/func 3.d"), Path.fromOSString((String)"Sources/sub sources/subdir.mk")};
        IProject[] projects = this.createProjects("test1DepCalc2", null, null, true);
        this.buildProjects(projects, makefiles);
    }

    public void test1DepCalc3() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"Sources/subdir.mk"), Path.fromOSString((String)"Sources/func1.d"), Path.fromOSString((String)"Sources/func2.d"), Path.fromOSString((String)"Sources/func4.d"), Path.fromOSString((String)"Sources/sub sources/func 3.d"), Path.fromOSString((String)"Sources/sub sources/subdir.mk")};
        IProject[] projects = this.createProjects("test1DepCalc3", null, null, true);
        this.buildProjects(projects, makefiles);
    }

    public void test1DepCalcPreBuild() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"Sources/subdir.mk"), Path.fromOSString((String)"Sources/func1.d"), Path.fromOSString((String)"Sources/func2.d"), Path.fromOSString((String)"Sources/func4.d"), Path.fromOSString((String)"Sources/sub sources/func 3.d"), Path.fromOSString((String)"Sources/sub sources/subdir.mk")};
        IProject[] projects = this.createProjects("test1DepCalcPreBuild", null, null, true);
        this.buildProjects(projects, makefiles);
    }
}

