/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroSupplier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ManagedBuildMacrosTests
extends TestCase {
    static IProject proj = null;
    static IManagedProject mproj = null;
    IConfiguration[] cfgs = null;
    IBuildMacroProvider mp = null;
    IWorkspace worksp = null;
    boolean windows = false;
    boolean print = false;
    boolean flag = false;
    IBuildMacroSupplier[] ms = null;
    public static int functionCalled = 0;
    public static final int GET_ONE_PROJECT = 1;
    public static final int GET_MANY_PROJECT = 2;
    public static final int GET_ONE_CONFIG = 4;
    public static final int GET_MANY_CONFIG = 8;
    public static final int RESERVED_NAME = 16;
    static final String UNKNOWN = "<HZ>";
    static final String LISTSEP = "|";
    static final String TEST = "TEST";
    static final String[] TST = new String[]{"DUMMY", "FILETEST", "OPTTEST", "CFGTEST", "PRJTEST", "WSPTEST", "INSTEST", "ENVTEST"};
    final String OPT_IDS = "macro.test.string";
    final String OPT_IDL = "macro.test.list";
    final String INC_DEF = "${IncludeDefaults}";
    static /* synthetic */ Class class$0;

    public ManagedBuildMacrosTests() {
    }

    public ManagedBuildMacrosTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.ManagedBuildMacrosTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite((Class)clazz);
        return suite;
    }

    public void testMacroOptL() {
        this.doInit();
        this.cfgs[0].getToolChain();
        ITool t = this.cfgs[0].getTools()[0];
        IOption opt = t.getOptionById("macro.test.list");
        OptionContextData ocd = new OptionContextData(opt, (IBuildObject)t);
        ManagedBuildMacrosTests.assertNotNull((Object)opt);
        this.ms = this.mp.getSuppliers(2, (Object)ocd);
        ManagedBuildMacrosTests.assertNotNull((Object)this.ms);
        ManagedBuildMacrosTests.assertEquals((int)this.ms.length, (int)1);
        try {
            String[] set0 = opt.getStringListValue();
            ManagedBuildMacrosTests.assertNotNull((Object)set0);
            String[] set1 = new String[]{"new a", "${IncludeDefaults}", "${PATH}", "PRJ=${NEW_FOR_PRJ}", "LIST=${IncludeDefaults}"};
            String[] res1 = new String[]{"new a", "x", "y", "z", ":", "PRJ=NewMacrosForProjectContext", "LIST=x|y|z"};
            try {
                res1[4] = this.mp.resolveValue("${PATH}", UNKNOWN, LISTSEP, 2, (Object)ocd);
            }
            catch (BuildMacroException e) {
                ManagedBuildMacrosTests.fail((String)e.getLocalizedMessage());
            }
            opt = this.cfgs[0].setOption((IHoldsOptions)t, opt, set1);
            ManagedBuildMacrosTests.assertNotNull((Object)opt);
            ArrayList<String> ar = new ArrayList<String>(1);
            int i = 0;
            while (i < set1.length) {
                try {
                    String[] aus = this.mp.resolveStringListValue(set1[i], UNKNOWN, LISTSEP, 2, (Object)new OptionContextData(opt, (IBuildObject)t));
                    if (aus != null) {
                        int j = 0;
                        while (j < aus.length) {
                            ar.add(aus[j]);
                            ++j;
                        }
                    }
                }
                catch (BuildMacroException e) {
                    ManagedBuildMacrosTests.fail((String)e.getLocalizedMessage());
                }
                ++i;
            }
            String[] res = ar.toArray(new String[0]);
            ManagedBuildMacrosTests.assertEquals((int)res.length, (int)res1.length);
            int i2 = 0;
            while (i2 < res.length) {
                ManagedBuildMacrosTests.assertEquals((String)res[i2], (String)res1[i2]);
                ++i2;
            }
        }
        catch (BuildException e) {
            ManagedBuildMacrosTests.fail((String)e.getLocalizedMessage());
        }
    }

    public void rm_testMacroContext() {
        this.doInit();
        IBuildMacro mcfg = this.mp.getMacro(TEST, 3, (Object)this.cfgs[0], true);
        IBuildMacro mprj = this.mp.getMacro(TEST, 4, (Object)mproj, true);
        IBuildMacro mwsp = this.mp.getMacro(TEST, 5, (Object)this.worksp, true);
        ManagedBuildMacrosTests.assertNotNull((Object)mcfg);
        ManagedBuildMacrosTests.assertNotNull((Object)mprj);
        ManagedBuildMacrosTests.assertNotNull((Object)mwsp);
        try {
            ManagedBuildMacrosTests.assertEquals((String)mcfg.getStringValue(), (String)TST[3]);
            ManagedBuildMacrosTests.assertEquals((String)mprj.getStringValue(), (String)TST[4]);
            ManagedBuildMacrosTests.assertEquals((String)mwsp.getStringValue(), (String)TST[5]);
        }
        catch (BuildMacroException e) {
            ManagedBuildMacrosTests.fail((String)e.getLocalizedMessage());
        }
    }

    public void testMacroResolveExceptions() {
        this.doInit();
        boolean exceptionRaised = false;
        try {
            this.mp.resolveValue("${ONE} - ${ZERO}", null, null, 3, (Object)this.cfgs[0]);
        }
        catch (BuildMacroException buildMacroException) {
            exceptionRaised = true;
        }
        ManagedBuildMacrosTests.assertTrue((String)"Exception not raised for undefined macro", (boolean)exceptionRaised);
        exceptionRaised = false;
        try {
            this.mp.resolveValue("${LST}", null, null, 3, (Object)this.cfgs[0]);
        }
        catch (BuildMacroException buildMacroException) {
            exceptionRaised = true;
        }
        ManagedBuildMacrosTests.assertTrue((String)"Exception not raised for undefined delimiter", (boolean)exceptionRaised);
    }

    private String[] printMacros(IBuildMacro[] vars, String head) {
        ArrayList<String> ar = new ArrayList<String>(0);
        if (vars != null) {
            if (vars.length > 0) {
                int i = 0;
                while (i < vars.length) {
                    try {
                        ar.add(vars[i].getName());
                        if (this.print) {
                            if (vars[i].getMacroValueType() % 2 == 1) {
                                if (vars[i].getName().endsWith("prompt")) {
                                    System.out.println(String.valueOf(head) + "[" + i + "] " + vars[i].getName() + " = <UNREACHABLE>");
                                } else {
                                    System.out.println(String.valueOf(head) + "[" + i + "] " + vars[i].getName() + " = " + vars[i].getStringValue());
                                }
                            } else {
                                System.out.println(String.valueOf(head) + "[" + i + "] " + vars[i].getName() + ":");
                                String[] m = vars[i].getStringListValue();
                                this.printStrings(m, "    ");
                            }
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
            } else if (this.print) {
                System.out.println(String.valueOf(head) + ": array is empty");
            }
        } else if (this.print) {
            System.out.println(String.valueOf(head) + ": array is null");
        }
        return ar.toArray(new String[0]);
    }

    private void printStrings(String[] vars, String head) {
        if (!this.print) {
            return;
        }
        if (vars != null) {
            if (vars.length > 0) {
                int j = 0;
                while (j < vars.length) {
                    System.out.println(String.valueOf(head) + vars[j]);
                    ++j;
                }
            } else {
                System.out.println(String.valueOf(head) + ": array is empty");
            }
        } else {
            System.out.println(String.valueOf(head) + ": array is null");
        }
    }

    static void createManagedProject(String name) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        proj = root.getProject(name);
        if (proj.exists()) {
            mproj = ManagedBuildManager.getBuildInfo((IResource)proj).getManagedProject();
        } else {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription workspaceDesc = workspace.getDescription();
            workspaceDesc.setAutoBuilding(false);
            try {
                workspace.setDescription(workspaceDesc);
                proj = CCorePlugin.getDefault().createCProject(workspace.newProjectDescription(proj.getName()), proj, (IProgressMonitor)new NullProgressMonitor(), ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID);
                ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)proj);
                info.setValid(true);
                ManagedCProjectNature.addManagedNature((IProject)proj, null);
                ManagedCProjectNature.addManagedBuilder((IProject)proj, null);
                ICDescriptor desc = CCorePlugin.getDefault().getCProjectDescription(proj, true);
                desc.remove("org.eclipse.cdt.core.ScannerInfoProvider");
                desc.create("org.eclipse.cdt.core.ScannerInfoProvider", ManagedBuildManager.INTERFACE_IDENTITY);
                desc.saveProjectData();
            }
            catch (CoreException e) {
                ManagedBuildMacrosTests.fail((String)("Cannot create project: " + e.getLocalizedMessage()));
            }
            ManagedBuildManager.getDefinedProjectTypes();
            IProjectType projType = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testenv.exe");
            ManagedBuildMacrosTests.assertNotNull((Object)projType);
            try {
                mproj = ManagedBuildManager.createManagedProject((IResource)proj, (IProjectType)projType);
            }
            catch (BuildException buildException) {}
            ManagedBuildManager.setNewProjectVersion((IProject)proj);
            IConfiguration[] cfgs = projType.getConfigurations();
            IConfiguration defcfg = cfgs.length > 0 ? mproj.createConfiguration(cfgs[0], String.valueOf(projType.getId()) + ".0") : null;
            int i = 1;
            while (i < cfgs.length) {
                mproj.createConfiguration(cfgs[i], String.valueOf(projType.getId()) + "." + i);
                ++i;
            }
            ManagedBuildManager.setDefaultConfiguration((IProject)proj, defcfg);
        }
        try {
            proj.open(null);
        }
        catch (CoreException coreException) {}
    }

    private void doInit() {
        ManagedBuildMacrosTests.createManagedProject("Test");
        ManagedBuildMacrosTests.assertNotNull((Object)proj);
        ManagedBuildMacrosTests.assertNotNull((Object)mproj);
        this.worksp = proj.getWorkspace();
        ManagedBuildMacrosTests.assertNotNull((Object)this.worksp);
        this.mp = ManagedBuildManager.getBuildMacroProvider();
        ManagedBuildMacrosTests.assertNotNull((Object)this.mp);
        this.cfgs = mproj.getConfigurations();
        ManagedBuildMacrosTests.assertNotNull((Object)this.cfgs);
        this.windows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    private boolean arrayContains(String[] a, String[] b) {
        ManagedBuildMacrosTests.assertNotNull((Object)a);
        ManagedBuildMacrosTests.assertNotNull((Object)b);
        int i = 0;
        while (i < a.length) {
            boolean found = false;
            int j = 0;
            while (j < b.length) {
                if (a[i].equals(b[j])) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private IFile getFile() {
        IFile f = proj.getProject().getFile("main.c");
        if (!f.exists()) {
            try {
                f.create((InputStream)new ByteArrayInputStream("int main(){\n return 0;\n}".getBytes()), false, null);
            }
            catch (CoreException e) {
                ManagedBuildMacrosTests.fail((String)e.getLocalizedMessage());
            }
        }
        return f;
    }
}

