/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.ICDIDebugger;
import org.eclipse.cdt.debug.core.ICDIDebugger2;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRuntimeOptions;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;

public class LocalCDILaunchDelegate
extends AbstractCLaunchDelegate {
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (mode.equals("run")) {
            this.runLocalApplication(config, launch, monitor);
        }
        if (mode.equals("debug")) {
            this.launchDebugger(config, launch, monitor);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runLocalApplication(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(LaunchMessages.getString("LocalCDILaunchDelegate.0"), 10);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        try {
            IPath exePath = this.verifyProgramPath(config);
            File wd = this.getWorkingDirectory(config);
            if (wd == null) {
                wd = new File(System.getProperty("user.home", "."));
            }
            String[] arguments = this.getProgramArgumentsArray(config);
            ArrayList<String> command = new ArrayList<String>(1 + arguments.length);
            command.add(exePath.toOSString());
            command.addAll(Arrays.asList(arguments));
            String[] commandArray = command.toArray(new String[command.size()]);
            boolean usePty = config.getAttribute("org.eclipse.cdt.launch.use_terminal", true);
            monitor.worked(2);
            Process process = this.exec(commandArray, this.getEnvironment(config), wd, usePty);
            monitor.worked(6);
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(commandArray[0]));
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void launchDebugger(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(LaunchMessages.getString("LocalCDILaunchDelegate.1"), 10);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            if (debugMode.equals("run")) {
                this.launchLocalDebugSession(config, launch, monitor);
            }
            if (debugMode.equals("attach")) {
                this.launchAttachDebugSession(config, launch, monitor);
            }
            if (debugMode.equals("core")) {
                this.launchCoreDebugSession(config, launch, monitor);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void launchLocalDebugSession(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(LaunchMessages.getString("LocalCDILaunchDelegate.2"));
        ICDISession dsession = null;
        try {
            try {
                IPath exePath = this.verifyProgramPath(config);
                ICProject project = this.verifyCProject(config);
                IBinaryParser.IBinaryObject exeFile = null;
                if (exePath != null) {
                    exeFile = this.verifyBinary(project, exePath);
                }
                ICDebugConfiguration debugConfig = this.getDebugConfig(config);
                this.setDefaultSourceLocator(launch, config);
                dsession = this.createCDISession(config, launch, debugConfig, monitor);
                monitor.worked(6);
                this.setRuntimeOptions(config, dsession);
                monitor.worked(1);
                boolean stopInMain = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
                String stopSymbol = null;
                if (stopInMain) {
                    stopSymbol = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
                }
                ICDITarget[] targets = dsession.getTargets();
                int i = 0;
                while (i < targets.length) {
                    Process process = targets[i].getProcess();
                    IProcess iprocess = null;
                    if (process != null) {
                        iprocess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()), (Map)this.getDefaultProcessMap());
                    }
                    CDIDebugModel.newDebugTarget((ILaunch)launch, (IProject)project.getProject(), (ICDITarget)targets[i], (String)this.renderTargetLabel(debugConfig), (IProcess)iprocess, (IBinaryParser.IBinaryObject)exeFile, (boolean)true, (boolean)false, (String)stopSymbol, (boolean)true);
                    ++i;
                }
            }
            catch (CoreException e) {
                try {
                    if (dsession == null) throw e;
                    dsession.terminate();
                    throw e;
                }
                catch (CDIException cDIException) {}
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var15_18 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void launchAttachDebugSession(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block13: {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.subTask(LaunchMessages.getString("LocalCDILaunchDelegate.3"));
            ILaunchConfigurationWorkingCopy wc = null;
            int pid = config.getAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", -1);
            if (pid == -1) {
                pid = this.promptForProcessID(config);
                if (pid == -1) {
                    this.cancel(LaunchMessages.getString("LocalCDILaunchDelegate.4"), 107);
                }
                wc = config.getWorkingCopy();
                wc.setAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", pid);
                wc.doSave().launch("debug", (IProgressMonitor)new SubProgressMonitor(monitor, 9));
                wc.setAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", null);
                wc.doSave();
                this.cancel("", -1);
            }
            IPath exePath = this.verifyProgramPath(config);
            ICProject project = this.verifyCProject(config);
            IBinaryParser.IBinaryObject exeFile = null;
            if (exePath != null) {
                exeFile = this.verifyBinary(project, exePath);
            }
            ICDebugConfiguration debugConfig = this.getDebugConfig(config);
            this.setDefaultSourceLocator(launch, config);
            ICDISession dsession = this.createCDISession(config, launch, debugConfig, monitor);
            monitor.worked(7);
            try {
                try {
                    ICDITarget[] targets = dsession.getTargets();
                    int i = 0;
                    while (i < targets.length) {
                        CDIDebugModel.newDebugTarget((ILaunch)launch, (IProject)project.getProject(), (ICDITarget)targets[i], (String)this.renderTargetLabel(debugConfig), null, (IBinaryParser.IBinaryObject)exeFile, (boolean)true, (boolean)true, (boolean)false);
                        ++i;
                    }
                }
                catch (CoreException e) {
                    try {
                        dsession.terminate();
                        throw e;
                    }
                    catch (CDIException cDIException) {}
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                if (wc != null) {
                    wc.setAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", null);
                }
                monitor.done();
                throw throwable;
            }
            {
                Object var13_16 = null;
                if (wc == null) break block13;
            }
            wc.setAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", null);
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void launchCoreDebugSession(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block15: {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask(LaunchMessages.getString("LocalCDILaunchDelegate.5"), 10);
            ICDISession dsession = null;
            ILaunchConfigurationWorkingCopy wc = null;
            ICDebugConfiguration debugConfig = this.getDebugConfig(config);
            String path = config.getAttribute("org.eclipse.cdt.launch.COREFILE_PATH", null);
            if (path == null) {
                File file;
                ICProject project = this.verifyCProject(config);
                IPath corefile = this.promptForCoreFilePath((IProject)project.getResource(), debugConfig);
                if (corefile == null) {
                    this.cancel(LaunchMessages.getString("LocalCDILaunchDelegate.6"), 108);
                }
                if (!(file = new File(corefile.toString())).exists() || !file.canRead()) {
                    this.cancel(LaunchMessages.getString("LocalCDILaunchDelegate.7"), 108);
                }
                wc = config.getWorkingCopy();
                wc.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", corefile.toString());
                wc.launch("debug", (IProgressMonitor)new SubProgressMonitor(monitor, 9));
                wc.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", null);
                this.cancel("", -1);
            }
            IPath exePath = this.verifyProgramPath(config);
            ICProject project = this.verifyCProject(config);
            IBinaryParser.IBinaryObject exeFile = null;
            if (exePath != null) {
                exeFile = this.verifyBinary(project, exePath);
            }
            this.setDefaultSourceLocator(launch, config);
            dsession = this.createCDISession(config, launch, debugConfig, monitor);
            monitor.worked(7);
            try {
                try {
                    ICDITarget[] targets = dsession.getTargets();
                    int i = 0;
                    while (i < targets.length) {
                        Process process = targets[i].getProcess();
                        IProcess iprocess = null;
                        if (process != null) {
                            iprocess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()), (Map)this.getDefaultProcessMap());
                        }
                        CDIDebugModel.newDebugTarget((ILaunch)launch, (IProject)project.getProject(), (ICDITarget)targets[i], (String)this.renderTargetLabel(debugConfig), (IProcess)iprocess, (IBinaryParser.IBinaryObject)exeFile, (boolean)true, (boolean)false, (boolean)false);
                        ++i;
                    }
                }
                catch (CoreException e) {
                    try {
                        if (dsession == null) throw e;
                        dsession.terminate();
                        throw e;
                    }
                    catch (CDIException cDIException) {}
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                if (wc != null) {
                    wc.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", null);
                }
                monitor.done();
                throw throwable;
            }
            {
                Object var15_18 = null;
                if (wc == null) break block15;
            }
            wc.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", null);
        }
        monitor.done();
    }

    private ICDISession launchOldDebugSession(ILaunchConfiguration config, ILaunch launch, ICDIDebugger debugger, IProgressMonitor monitor) throws CoreException {
        IBinaryParser.IBinaryObject exeFile = null;
        IPath exePath = this.verifyProgramPath(config);
        ICProject project = this.verifyCProject(config);
        if (exePath != null) {
            exeFile = this.verifyBinary(project, exePath);
        }
        return debugger.createDebuggerSession(launch, exeFile, monitor);
    }

    private ICDISession launchDebugSession(ILaunchConfiguration config, ILaunch launch, ICDIDebugger2 debugger, IProgressMonitor monitor) throws CoreException {
        IPath path = this.verifyProgramPath(config);
        return debugger.createSession(launch, path.toFile(), monitor);
    }

    protected String getPluginID() {
        return LaunchUIPlugin.getUniqueIdentifier();
    }

    protected Process exec(String[] cmdLine, String[] environ, File workingDirectory, boolean usePty) throws CoreException {
        Process p;
        block4: {
            p = null;
            try {
                p = workingDirectory == null ? ProcessFactory.getFactory().exec(cmdLine, environ) : (usePty && PTY.isSupported() ? ProcessFactory.getFactory().exec(cmdLine, environ, workingDirectory, new PTY()) : ProcessFactory.getFactory().exec(cmdLine, environ, workingDirectory));
            }
            catch (IOException e) {
                if (p != null) {
                    p.destroy();
                }
                this.abort(LaunchMessages.getString("LocalCDILaunchDelegate.8"), e, 150);
            }
            catch (NoSuchMethodError e) {
                Object result;
                Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 100, LaunchMessages.getString("LocalCDILaunchDelegate.9"), (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (handler == null || !((result = handler.handleStatus((IStatus)status, (Object)this)) instanceof Boolean) || !((Boolean)result).booleanValue()) break block4;
                p = this.exec(cmdLine, environ, null, usePty);
            }
        }
        return p;
    }

    protected int promptForProcessID(ILaunchConfiguration config) throws CoreException {
        Object result;
        Status fPromptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
        Status processPrompt = new Status(1, "org.eclipse.cdt.launch", 100, "", null);
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)fPromptStatus);
        if (prompter != null && (result = prompter.handleStatus((IStatus)processPrompt, (Object)config)) instanceof Integer) {
            return (Integer)result;
        }
        return -1;
    }

    protected IPath promptForCoreFilePath(IProject project, ICDebugConfiguration debugConfig) throws CoreException {
        Object result;
        Status fPromptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
        Status processPrompt = new Status(1, "org.eclipse.cdt.launch", 1001, "", null);
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)fPromptStatus);
        if (prompter != null && (result = prompter.handleStatus((IStatus)processPrompt, (Object)new Object[]{project, debugConfig})) instanceof IPath) {
            return (IPath)result;
        }
        return null;
    }

    public boolean preLaunchCheck(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        if (mode.equals("debug") && "core".equals(config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run"))) {
            return true;
        }
        return super.preLaunchCheck(config, mode, monitor);
    }

    private void setRuntimeOptions(ILaunchConfiguration config, ICDISession session) throws CoreException {
        String[] arguments = this.getProgramArgumentsArray(config);
        try {
            ICDITarget[] dtargets = session.getTargets();
            int i = 0;
            while (i < dtargets.length) {
                ICDIRuntimeOptions opt = dtargets[i].getRuntimeOptions();
                opt.setArguments(arguments);
                File wd = this.getWorkingDirectory(config);
                if (wd != null) {
                    opt.setWorkingDirectory(wd.getAbsolutePath());
                }
                opt.setEnvironment(this.getEnvironmentAsProperty(config));
                ++i;
            }
        }
        catch (CDIException e) {
            this.abort(LaunchMessages.getString("LocalCDILaunchDelegate.10"), e, 150);
        }
    }

    private ICDISession createCDISession(ILaunchConfiguration config, ILaunch launch, ICDebugConfiguration debugConfig, IProgressMonitor monitor) throws CoreException {
        ICDISession session = null;
        ICDIDebugger debugger = debugConfig.createDebugger();
        session = debugger instanceof ICDIDebugger2 ? this.launchDebugSession(config, launch, (ICDIDebugger2)debugger, monitor) : this.launchOldDebugSession(config, launch, debugger, monitor);
        return session;
    }
}

