/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.errorparsers.xlc;

import java.util.StringTokenizer;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class XlcErrorParser
implements IErrorParser {
    private String fileName = null;
    private int lineNumber = -1;
    private String severity = null;
    private String message = null;
    private int severityNum = -1;

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean parseLine(String line) {
        String lineNum = null;
        String secondPart = null;
        StringTokenizer tok = null;
        int firstComma = line.indexOf(44);
        if (firstComma == -1) return false;
        String firstPart = line.substring(0, firstComma);
        tok = new StringTokenizer(firstPart, "\"");
        if (!tok.hasMoreTokens()) {
            return false;
        }
        this.fileName = tok.nextToken();
        secondPart = line.substring(firstComma + 1);
        tok = new StringTokenizer(secondPart, ".");
        if (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            int index = token.indexOf("line ");
            if (index == -1) return false;
            lineNum = token.substring(index + 5);
            this.lineNumber = Integer.parseInt(lineNum);
        }
        int index = -1;
        index = secondPart.indexOf(")");
        if (-1 == index) {
            return false;
        }
        this.message = secondPart.substring(index + 1);
        this.severity = secondPart.substring(index - 1, index);
        if (this.severity.equals("I")) {
            this.severityNum = 0;
            return true;
        } else if (this.severity.equals("W")) {
            this.severityNum = 1;
            return true;
        } else if (this.severity.equals("E") || this.severity.equals("S")) {
            this.severityNum = 2;
            return true;
        } else {
            if (!this.severity.equals("U")) return false;
            this.severityNum = 3;
        }
        return true;
    }

    public boolean processLine(String line, ErrorParserManager eoParser) {
        if (this.parseLine(line)) {
            IFile file = null;
            if (this.fileName != null) {
                file = eoParser.findFileName(this.fileName);
                if (file != null) {
                    if (eoParser.isConflictingName(this.fileName)) {
                        file = null;
                    }
                } else {
                    file = eoParser.findFilePath(this.fileName);
                }
                if (file == null) {
                    this.message = String.valueOf(this.fileName) + " " + this.message;
                }
            }
            eoParser.generateMarker((IResource)file, this.lineNumber, this.message, this.severityNum, null);
            return true;
        }
        return false;
    }
}

