/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.make.core.scannerconfig.PathInfo;
import org.eclipse.cdt.make.internal.core.scannerconfig.CDataDiscoveredInfoCalculator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class CDataDiscoveredInfoProcessor {
    public void applyDiscoveredInfo(CConfigurationData cfgData, CDataDiscoveredInfoCalculator.DiscoveredSettingInfo dsIinfo) {
        CDataDiscoveredInfoCalculator.IRcSettingInfo info;
        Map map = CDataUtil.createPathRcDataMap((CConfigurationData)cfgData);
        PathSettingsContainer cr = PathSettingsContainer.createRootContainer();
        CDataDiscoveredInfoCalculator.IRcSettingInfo[] infos = dsIinfo.getRcSettingInfos();
        int i = 0;
        while (i < infos.length) {
            info = infos[i];
            this.applyInfo(cfgData, info, cr);
            map.remove(info.getResourceData().getPath());
            ++i;
        }
        if (map.size() != 0) {
            CResourceData rcData = (CResourceData)map.get(Path.EMPTY);
            if (rcData != null) {
                info = CDataDiscoveredInfoCalculator.createEmptyRcSettingInfo((CFolderData)rcData);
                this.applyInfo(cfgData, info, cr);
                map.remove(Path.EMPTY);
            }
            if (map.size() != 0) {
                Iterator iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    IPath path = (IPath)entry.getKey();
                    PathSettingsContainer curCr = cr.getChildContainer(path, false, false);
                    rcData = (CResourceData)entry.getValue();
                    info = (CDataDiscoveredInfoCalculator.IRcSettingInfo)curCr.getValue();
                    this.applyInfo(cfgData, rcData, info);
                }
            }
        }
    }

    protected void applyInfo(CConfigurationData cfgData, CResourceData rcData, CDataDiscoveredInfoCalculator.IRcSettingInfo info) {
        CLanguageData[] lDatas = this.getLangDatas(rcData);
        CDataDiscoveredInfoCalculator.ILangSettingInfo[] lInfos = info.getLangInfos();
        int k = 0;
        while (k < lDatas.length) {
            CLanguageData lData = lDatas[k];
            CDataDiscoveredInfoCalculator.ILangSettingInfo lInfo = this.getMatch(lData, lInfos);
            if (lInfo != null) {
                this.setInfoForData(cfgData, rcData, lData, lInfo.getFilePathInfo(), info.getResourceData(), lInfo.getLanguageData());
            } else {
                this.setInfoForData(cfgData, rcData, lData, null, null, null);
            }
            ++k;
        }
    }

    protected CLanguageData[] getLangDatas(CResourceData rcData) {
        if (rcData.getType() == 8) {
            CLanguageData lData = ((CFileData)rcData).getLanguageData();
            if (lData != null) {
                return new CLanguageData[]{lData};
            }
            return new CLanguageData[0];
        }
        return ((CFolderData)rcData).getLanguageDatas();
    }

    protected CDataDiscoveredInfoCalculator.ILangSettingInfo getMatch(CLanguageData lData, CDataDiscoveredInfoCalculator.ILangSettingInfo[] lInfos) {
        int i = 0;
        while (i < lInfos.length) {
            CDataDiscoveredInfoCalculator.ILangSettingInfo lInfo = lInfos[i];
            if (this.langDatasMatch(lData, lInfo.getLanguageData())) {
                return lInfo;
            }
            ++i;
        }
        return null;
    }

    protected CLanguageData getMatch(CLanguageData lData, CLanguageData[] datas) {
        int i = 0;
        while (i < datas.length) {
            if (this.langDatasMatch(lData, datas[i])) {
                return datas[i];
            }
            ++i;
        }
        return null;
    }

    protected boolean langDatasMatch(CLanguageData lData1, CLanguageData lData2) {
        if (!CDataUtil.objectsEqual((Object)lData1.getLanguageId(), (Object)lData2.getLanguageId())) {
            return false;
        }
        Object[] tmp = lData1.getSourceContentTypeIds();
        return !(tmp != null && tmp.length != 0 ? !Arrays.equals(tmp, lData2.getSourceContentTypeIds()) : !Arrays.equals(lData1.getSourceExtensions(), lData2.getSourceExtensions()));
    }

    protected void applyInfo(CConfigurationData cfgData, CDataDiscoveredInfoCalculator.IRcSettingInfo info, PathSettingsContainer cr) {
        CResourceData rcData = info.getResourceData();
        IPath path = rcData.getPath();
        PathSettingsContainer curCr = cr.getChildContainer(path, true, true);
        curCr.setValue((Object)info);
        CDataDiscoveredInfoCalculator.ILangSettingInfo[] lInfos = info.getLangInfos();
        int k = 0;
        while (k < lInfos.length) {
            CDataDiscoveredInfoCalculator.ILangSettingInfo lInfo = lInfos[k];
            CLanguageData lData = lInfo.getLanguageData();
            this.setInfoForData(cfgData, rcData, lData, lInfo.getFilePathInfo(), null, null);
            ++k;
        }
    }

    protected abstract void setInfoForData(CConfigurationData var1, CResourceData var2, CLanguageData var3, PathInfo var4, CResourceData var5, CLanguageData var6);
}

