/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.IPreprocessorLog;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.Macro;
import org.eclipse.cdt.internal.core.parser.scanner2.FunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.IScannerPreprocessorLog;
import org.eclipse.cdt.internal.core.parser.scanner2.LocationMap;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectStyleMacro;

public class LocationResolver
extends LocationMap
implements IPreprocessorLog {
    private Map macroDefinitions = new HashMap();
    private boolean ignoreMacroExpansions;

    public void setIgnoreMacroExpansions(boolean ignore) {
        this.ignoreMacroExpansions = ignore;
    }

    public void defineMacro(Macro macro) {
        IScannerPreprocessorLog.IMacroDefinition macroDef;
        int startOffset = macro.getDirectiveStartOffset();
        int endOffset = macro.getDirectiveEndOffset();
        int nameOffset = macro.getNameStartOffset();
        int nameEndOffset = macro.getNameEndOffset() + 1;
        char[] macroName = macro.getName().toCharArray();
        char[] expansion = macro.getExpansion().toCharArray();
        if (macro.isObjectLike()) {
            ObjectStyleMacro osm = new ObjectStyleMacro(macroName, expansion);
            macroDef = super.defineObjectStyleMacro(osm, startOffset, nameOffset, nameEndOffset, endOffset);
        } else {
            char[][] argList = LocationResolver.getParamsAsChars(macro);
            FunctionStyleMacro fsm = new FunctionStyleMacro(macroName, expansion, argList);
            macroDef = super.defineFunctionStyleMacro(fsm, startOffset, nameOffset, nameEndOffset, endOffset);
        }
        this.macroDefinitions.put(macro.getName(), macroDef);
    }

    public void registerBuiltinMacro(Macro macro) {
        IScannerPreprocessorLog.IMacroDefinition macroDef;
        if (macro == null) {
            return;
        }
        char[] macroName = macro.getName().toCharArray();
        char[] expansion = macro.getExpansion().toCharArray();
        if (macro.isObjectLike()) {
            ObjectStyleMacro osm = new ObjectStyleMacro(macroName, expansion);
            macroDef = super.registerBuiltinObjectStyleMacro(osm);
        } else {
            char[][] argList = LocationResolver.getParamsAsChars(macro);
            FunctionStyleMacro fsm = new FunctionStyleMacro(macroName, expansion, argList);
            macroDef = super.registerBuiltinFunctionStyleMacro(fsm);
        }
        this.macroDefinitions.put(macro.getName(), macroDef);
    }

    public void registerIndexMacro(IMacro macro) {
        IScannerPreprocessorLog.IMacroDefinition macroDef;
        if (macro == null) {
            return;
        }
        if (macro instanceof FunctionStyleMacro) {
            macroDef = super.registerBuiltinFunctionStyleMacro((FunctionStyleMacro)macro);
        } else if (macro instanceof ObjectStyleMacro) {
            macroDef = super.registerBuiltinObjectStyleMacro((ObjectStyleMacro)macro);
        } else {
            return;
        }
        this.macroDefinitions.put(new String(macro.getName()), macroDef);
    }

    private static char[][] getParamsAsChars(Macro macro) {
        List paramNames = macro.getParamNames();
        if (paramNames == null || paramNames.isEmpty()) {
            return new char[1][];
        }
        char[][] argList = new char[paramNames.size()][];
        int i = 0;
        while (i < argList.length) {
            argList[i] = ((String)paramNames.get(i)).toCharArray();
            ++i;
        }
        return argList;
    }

    public void undefineMacro(int directiveStartOffset, int directiveEndOffset, String macroName, int nameOffset) {
        super.encounterPoundUndef(directiveStartOffset, directiveEndOffset, macroName.toCharArray(), nameOffset, this.getMacroDefinition(macroName));
    }

    public void startMacroExpansion(Macro macro, int nameStartOffset, int endOffset, char[][] actualArgs) {
        if (this.ignoreMacroExpansions) {
            return;
        }
        IScannerPreprocessorLog.IMacroDefinition macroDef = this.getMacroDefinition(macro);
        if (macro.isObjectLike()) {
            super.startObjectStyleMacroExpansion(macroDef, nameStartOffset, endOffset);
        } else {
            super.startFunctionStyleExpansion(macroDef, LocationResolver.getParamsAsChars(macro), nameStartOffset, endOffset, actualArgs);
        }
    }

    public void endMacroExpansion(Macro macro, int offset) {
        if (this.ignoreMacroExpansions) {
            return;
        }
        IScannerPreprocessorLog.IMacroDefinition macroDef = this.getMacroDefinition(macro);
        if (macro.isObjectLike()) {
            super.endObjectStyleMacroExpansion(macroDef, offset);
        } else {
            super.endFunctionStyleExpansion(macroDef, offset);
        }
    }

    private IScannerPreprocessorLog.IMacroDefinition getMacroDefinition(Macro macro) {
        return this.getMacroDefinition(macro.getName());
    }

    private IScannerPreprocessorLog.IMacroDefinition getMacroDefinition(String macroName) {
        return (IScannerPreprocessorLog.IMacroDefinition)this.macroDefinitions.get(macroName);
    }
}

