/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.dom.c99.IPPTokenComparator;
import org.eclipse.cdt.core.dom.parser.c99.IToken;
import org.eclipse.cdt.core.dom.parser.c99.PPToken;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.MacroArgument;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.Messages;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.Token;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.TokenList;

public class Macro {
    public static final String __VA_ARGS__ = "__VA_ARGS__";
    private final IToken name;
    private final String nameAsString;
    private final LinkedHashSet paramNames;
    private final TokenList replacementSequence;
    private final String varArgParamName;
    private final int startOffset;
    private final int endOffset;
    private final IPPTokenComparator comparator;

    public Macro(IToken name, TokenList replacementSequence, int startOffset, int endOffset, LinkedHashSet paramNames, String varArgParamName, IPPTokenComparator comparator) {
        if (replacementSequence == null) {
            throw new IllegalArgumentException(Messages.getString("Macro.0"));
        }
        if (name == null) {
            throw new IllegalArgumentException(Messages.getString("Macro.1"));
        }
        if (!comparator.compare(PPToken.IDENT, name)) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Macro.2")) + name.getKind() + ", " + name);
        }
        if (varArgParamName != null && paramNames.contains(varArgParamName)) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Macro.3")) + "'" + varArgParamName + "'");
        }
        this.replacementSequence = replacementSequence;
        Macro.normalizeReplacementSequenceOffsets(this.replacementSequence);
        this.name = name;
        this.nameAsString = name.toString();
        this.paramNames = paramNames;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.varArgParamName = varArgParamName;
        this.comparator = comparator;
    }

    public Macro(IToken name, TokenList replacementSequence, int startOffset, int endOffset, IPPTokenComparator comparator) {
        this(name, replacementSequence, startOffset, endOffset, null, null, comparator);
    }

    private boolean check(PPToken pptoken, IToken token) {
        return this.comparator.compare(pptoken, token);
    }

    private static void normalizeReplacementSequenceOffsets(TokenList replacementSequence) {
        if (replacementSequence == null || replacementSequence.isEmpty()) {
            return;
        }
        int offset = replacementSequence.first().getStartOffset();
        Iterator iter = replacementSequence.iterator();
        while (iter.hasNext()) {
            IToken token = (IToken)iter.next();
            token.setStartOffset(token.getStartOffset() - offset);
            token.setEndOffset(token.getEndOffset() - offset);
        }
    }

    public boolean isCorrectNumberOfArguments(int numArgs) {
        if (numArgs < 0) {
            throw new IllegalArgumentException(Messages.getString("Macro.4"));
        }
        if (this.isObjectLike()) {
            return false;
        }
        int numParams = this.getNumParams();
        return numArgs == numParams || this.isVarArgs() && numArgs == numParams + 1;
    }

    private MacroArgument createPlaceMarker() {
        Token placeMarker = new Token(0, 0, -1, "");
        placeMarker.setPreprocessorAttribute(1);
        return new MacroArgument(new TokenList(placeMarker), null);
    }

    private Map createReplacementMap(List arguments) {
        HashMap<String, MacroArgument> replacementMap = new HashMap<String, MacroArgument>();
        if (arguments == null) {
            return replacementMap;
        }
        int i = 0;
        Iterator iter = this.paramNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            MacroArgument arg = (MacroArgument)arguments.get(i);
            arg = arg.isEmpty() ? this.createPlaceMarker() : arg;
            replacementMap.put(name, arg);
            ++i;
        }
        if (this.isVarArgs()) {
            if (arguments.size() < this.getNumParams() + 1) {
                replacementMap.put(this.varArgParamName, this.createPlaceMarker());
            } else {
                replacementMap.put(this.varArgParamName, (MacroArgument)arguments.get(i));
            }
        }
        return replacementMap;
    }

    public TokenList invoke(List arguments) {
        if (arguments != null && !this.isCorrectNumberOfArguments(arguments.size())) {
            throw new IllegalArgumentException(Messages.getString("Macro.5"));
        }
        if (this.replacementSequence.isEmpty()) {
            return new TokenList();
        }
        InvokationResultCollector result = new InvokationResultCollector();
        Map replacementMap = this.createReplacementMap(arguments);
        Iterator iter = this.replacementSequence.iterator();
        IToken[] window = new IToken[3];
        int i = 0;
        while (i < 3) {
            window[i] = Macro.slide(iter);
            ++i;
        }
        while (window[0] != null) {
            if (this.check(PPToken.HASHHASH, window[0])) {
                return null;
            }
            if (window[1] != null && this.check(PPToken.HASHHASH, window[1])) {
                if (window[2] == null) {
                    return null;
                }
                TokenList op1 = Macro.getHashHashOperand(window[0], replacementMap);
                TokenList op2 = Macro.getHashHashOperand(window[2], replacementMap);
                IToken newToken = this.pasteTokens(op1.removeLast(), op2.removeFirst(), window[0].getStartOffset(), window[2].getEndOffset());
                result.addArgument(window[0], op1);
                if (op2.isEmpty()) {
                    window[0] = newToken;
                } else {
                    result.addArgumentToken(window[0], newToken);
                    window[0] = op2.removeLast();
                    result.addArgument(window[2], op1);
                }
                window[1] = Macro.slide(iter);
                window[2] = Macro.slide(iter);
                continue;
            }
            if (this.check(PPToken.HASH, window[0])) {
                if (window[1] == null) {
                    return null;
                }
                if (window[1].getPreprocessorAttribute() == 3) {
                    MacroArgument arg = (MacroArgument)replacementMap.get(window[1].toString());
                    if (arg == null) {
                        return null;
                    }
                    TokenList rawTokens = arg.getRawTokens();
                    if (rawTokens.isEmpty()) {
                        window[0] = window[2];
                        window[1] = Macro.slide(iter);
                        window[2] = Macro.slide(iter);
                        continue;
                    }
                    String newString = this.handleHashOperator(rawTokens);
                    int startOffset = window[0].getStartOffset();
                    int endOffset = window[1].getStartOffset() + newString.length() - 2;
                    Token strToken = new Token(startOffset, endOffset, this.comparator.getKind(5), newString);
                    window[0] = strToken;
                    window[1] = window[2];
                    window[2] = Macro.slide(iter);
                    continue;
                }
                return null;
            }
            if (window[0].getPreprocessorAttribute() == 3) {
                MacroArgument arg = (MacroArgument)replacementMap.get(window[0].toString());
                result.addArgument(window[0], arg.getProcessedTokens());
                window[0] = window[1];
                window[1] = window[2];
                window[2] = Macro.slide(iter);
                continue;
            }
            result.addToken(window[0]);
            window[0] = window[1];
            window[1] = window[2];
            window[2] = Macro.slide(iter);
        }
        return result.getResult();
    }

    private static TokenList getHashHashOperand(IToken replacementToken, Map replacementMap) {
        if (replacementToken.getPreprocessorAttribute() == 3) {
            MacroArgument op1 = (MacroArgument)replacementMap.get(replacementToken.toString());
            return op1.getRawTokens();
        }
        return new TokenList(replacementToken);
    }

    private static IToken slide(Iterator iter) {
        return iter.hasNext() ? (IToken)iter.next() : null;
    }

    private IToken pasteTokens(IToken x, IToken y, int startOffset, int endOffset) {
        String s = String.valueOf(x.toString()) + y.toString();
        int invalidKind = this.comparator.getKind(6);
        if (Macro.isPlaceMarker(x) && Macro.isPlaceMarker(y)) {
            Token token = new Token(startOffset, endOffset, invalidKind, s);
            token.setPreprocessorAttribute(1);
            return token;
        }
        if (Macro.isPlaceMarker(x)) {
            return new Token(startOffset, endOffset, y.getKind(), s);
        }
        if (Macro.isPlaceMarker(y)) {
            return new Token(startOffset, endOffset, x.getKind(), s);
        }
        int kind = invalidKind;
        if (this.check(PPToken.INTEGER, x) && this.check(PPToken.INTEGER, y)) {
            kind = this.comparator.getKind(4);
        } else if (this.check(PPToken.IDENT, x) && this.check(PPToken.INTEGER, y)) {
            kind = this.comparator.getKind(0);
        } else if (this.check(PPToken.IDENT, x) && this.check(PPToken.IDENT, y)) {
            kind = this.comparator.getKind(0);
        }
        return new Token(startOffset, endOffset, kind, s);
    }

    private static boolean isPlaceMarker(IToken token) {
        return token.getPreprocessorAttribute() == 1;
    }

    private String handleHashOperator(TokenList replacement) {
        StringBuffer sb = new StringBuffer().append('\"');
        Iterator iter = replacement.iterator();
        while (iter.hasNext()) {
            IToken token = (IToken)iter.next();
            sb.append(token.toString().replaceAll("\"", "\\\""));
            if (!iter.hasNext()) continue;
            sb.append(' ');
        }
        sb.append('\"');
        return sb.toString();
    }

    public String getExpansion() {
        return this.replacementSequence.toString();
    }

    public boolean isFunctionLike() {
        return !this.isObjectLike();
    }

    public boolean isObjectLike() {
        return this.paramNames == null;
    }

    public boolean equals() {
        return false;
    }

    public String getName() {
        return this.nameAsString;
    }

    public List getParamNames() {
        return new Vector(this.paramNames);
    }

    public boolean isVarArgs() {
        return this.varArgParamName != null;
    }

    public int getNumParams() {
        return this.paramNames == null ? 0 : this.paramNames.size();
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getDirectiveStartOffset() {
        return this.startOffset;
    }

    public int getDirectiveEndOffset() {
        return this.endOffset;
    }

    public int getDirectiveLength() {
        return this.getDirectiveEndOffset() - this.getDirectiveStartOffset();
    }

    public int getNameStartOffset() {
        return this.name.getStartOffset();
    }

    public int getNameEndOffset() {
        return this.name.getEndOffset();
    }

    public int getNameLength() {
        return this.getNameEndOffset() - this.getNameStartOffset();
    }

    public String toString() {
        if (this.isObjectLike()) {
            return String.valueOf(this.nameAsString) + " " + this.replacementSequence;
        }
        return String.valueOf(this.nameAsString) + "(" + this.paramNames.toString() + (this.isVarArgs() ? ",..." : "") + ") " + this.replacementSequence;
    }

    private class InvokationResultCollector {
        private TokenList result = new TokenList();
        private int offset = 0;

        private InvokationResultCollector() {
        }

        public void addToken(IToken token) {
            Token t = new Token(token);
            t.setStartOffset(t.getStartOffset() + this.offset);
            t.setEndOffset(t.getEndOffset() + this.offset);
            this.add(t);
        }

        public void addArgument(IToken parameter, TokenList argument) {
            if (argument == null || argument.isEmpty()) {
                return;
            }
            int argSourceOffset = argument.first().getStartOffset();
            int argSize = argument.last().getEndOffset() - argSourceOffset;
            int paramSize = parameter.getEndOffset() - parameter.getStartOffset() + 1;
            int parameterOffset = parameter.getStartOffset() + this.offset;
            Iterator iter = argument.iterator();
            while (iter.hasNext()) {
                Token t = new Token((IToken)iter.next());
                t.setStartOffset(t.getStartOffset() - argSourceOffset + parameterOffset);
                t.setEndOffset(t.getEndOffset() - argSourceOffset + parameterOffset);
                this.add(t);
            }
            this.offset += argSize - paramSize + 1;
        }

        public void addArgumentToken(IToken parameter, IToken token) {
            TokenList temp = new TokenList();
            temp.add(token);
            this.addArgument(parameter, temp);
        }

        private void add(IToken t) {
            if (Macro.this.check(PPToken.IDENT, t) && t.toString().equals(Macro.this.nameAsString)) {
                t.setPreprocessorAttribute(2);
            }
            this.result.add(t);
        }

        public TokenList getResult() {
            return this.result;
        }
    }
}

