/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.gdbjtag.ui;

import java.io.File;
import org.eclipse.cdt.debug.gdbjtag.ui.Activator;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GDBJtagStartupTab
extends AbstractLaunchConfigurationTab {
    Text initCommands;
    Button loadImage;
    Text imageFileName;
    Button imageFileBrowse;
    Button imageFileVariables;
    Text runCommands;
    Button runCommandVariables;

    public String getName() {
        return "Startup";
    }

    public Image getImage() {
        return GDBJtagImages.getStartupTabImage();
    }

    public void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.setControl((Control)sc);
        Composite comp = new Composite((Composite)sc, 0);
        sc.setContent((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        this.createInitGroup(comp);
        this.createLoadGroup(comp);
        this.createRunGroup(comp);
        sc.setMinSize(comp.computeSize(-1, -1));
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        text.append(dialog.getVariableExpression());
    }

    public void createInitGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText("Initialization Commands");
        this.initCommands = new Text((Composite)group, 2626);
        gd = new GridData(1808);
        gd.heightHint = 100;
        this.initCommands.setLayoutData((Object)gd);
        this.initCommands.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                GDBJtagStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button varsButton = new Button((Composite)group, 0);
        gd = new GridData(128);
        varsButton.setLayoutData((Object)gd);
        varsButton.setText("Variables...");
        varsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagStartupTab.this.variablesButtonSelected(GDBJtagStartupTab.this.initCommands);
            }
        });
    }

    private void createLoadGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        layout.numColumns = 3;
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        group.setLayoutData((Object)gd);
        group.setText("Load Image");
        this.loadImage = new Button((Composite)group, 32);
        this.loadImage.setText("Automatically load image");
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.loadImage.setLayoutData((Object)gd);
        this.loadImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagStartupTab.this.loadImageChanged();
                GDBJtagStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label label = new Label((Composite)group, 0);
        gd = new GridData();
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        label.setText("Image file name:");
        this.imageFileName = new Text((Composite)group, 2048);
        gd = new GridData(768);
        this.imageFileName.setLayoutData((Object)gd);
        this.imageFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.imageFileBrowse = new Button((Composite)group, 0);
        this.imageFileBrowse.setText("Browse...");
        this.imageFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagStartupTab.this.browseButtonSelected("Select image file", GDBJtagStartupTab.this.imageFileName);
            }
        });
        this.imageFileVariables = new Button((Composite)group, 0);
        this.imageFileVariables.setText("Variables...");
        this.imageFileVariables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagStartupTab.this.variablesButtonSelected(GDBJtagStartupTab.this.imageFileName);
            }
        });
    }

    private void loadImageChanged() {
        boolean enabled = this.loadImage.getSelection();
        this.imageFileName.setEnabled(enabled);
        this.imageFileBrowse.setEnabled(enabled);
        this.imageFileVariables.setEnabled(enabled);
    }

    public void createRunGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText("Run Commands");
        this.runCommands = new Text((Composite)group, 2626);
        gd = new GridData(1808);
        gd.heightHint = 100;
        this.runCommands.setLayoutData((Object)gd);
        this.runCommands.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                GDBJtagStartupTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.runCommandVariables = new Button((Composite)group, 0);
        gd = new GridData(128);
        this.runCommandVariables.setLayoutData((Object)gd);
        this.runCommandVariables.setText("Variables...");
        this.runCommandVariables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagStartupTab.this.variablesButtonSelected(GDBJtagStartupTab.this.runCommands);
            }
        });
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.initCommands.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbremote.core.initCommands", ""));
            this.loadImage.setSelection(configuration.getAttribute("org.eclipse.cdt.debug.gdbremote.core.loadImage", false));
            this.loadImageChanged();
            this.imageFileName.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbremote.core.imageFileName", ""));
            this.runCommands.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbremote.core.runCommands", ""));
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.debug.gdbremote.core.initCommands", this.initCommands.getText());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbremote.core.loadImage", this.loadImage.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbremote.core.imageFileName", this.imageFileName.getText().trim());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbremote.core.runCommands", this.runCommands.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.debug.gdbremote.core.initCommands", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbremote.core.loadImage", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbremote.core.imageFileName", "");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbremote.core.runCommands", "");
    }
}

