/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.util.ResourceChangeHandlerBase;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.ConfigurationDataProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

class ResourceChangeHandler2
extends ResourceChangeHandlerBase {
    ResourceChangeHandler2() {
    }

    protected ResourceChangeHandlerBase.IResourceMoveHandler createResourceMoveHandler(IResourceChangeEvent event) {
        return new RcMoveHandler();
    }

    public void sendClose(IProject project) {
        this.sendClose(ManagedBuildManager.getBuildInfo((IResource)project, false));
    }

    private void sendClose(IManagedBuildInfo info) {
        IManagedProject managedProj;
        if (info != null && (managedProj = info.getManagedProject()) != null) {
            IConfiguration[] cfgs = managedProj.getConfigurations();
            int i = 0;
            while (i < cfgs.length) {
                ManagedBuildManager.performValueHandlerEvent(cfgs[i], 2, true);
                ++i;
            }
        }
    }

    private static boolean checkNaturesNeedUpdate(String[] oldIds, String[] newIds) {
        if (oldIds == null) {
            return true;
        }
        HashSet<String> oldSet = new HashSet<String>(Arrays.asList(oldIds));
        HashSet<String> oldSetCopy = new HashSet<String>(oldSet);
        HashSet<String> newSet = new HashSet<String>(Arrays.asList(newIds));
        oldSet.removeAll(newSet);
        newSet.removeAll(oldSetCopy);
        return oldSet.contains("org.eclipse.cdt.core.cnature") || oldSet.contains("org.eclipse.cdt.core.ccnature") || newSet.contains("org.eclipse.cdt.core.cnature") || newSet.contains("org.eclipse.cdt.core.ccnature");
    }

    public void resourceChanged(IResourceChangeEvent event) {
        super.resourceChanged(event);
        switch (event.getType()) {
            case 1: {
                IResourceDelta delta = event.getDelta();
                if (delta == null) break;
                Visitor visitor = new Visitor(null);
                try {
                    delta.accept((IResourceDeltaVisitor)visitor);
                }
                catch (CoreException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
                this.postProcess(visitor.getProjSet());
            }
        }
    }

    private void postProcess(final Set projSet) {
        if (projSet == null || projSet.size() == 0) {
            return;
        }
        IWorkspace wsp = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = wsp.getRoot();
        Job job = new Job(ManagedMakeMessages.getString("ResourceChangeHandler2.0")){

            protected IStatus run(IProgressMonitor monitor) {
                Iterator iter = projSet.iterator();
                while (iter.hasNext()) {
                    IProject project = (IProject)iter.next();
                    try {
                        ManagedBuildManager.updateCoreSettings(project);
                    }
                    catch (CoreException e) {
                        ManagedBuilderCorePlugin.log(e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)root);
        job.setSystem(true);
        job.schedule();
    }

    private class RcMoveHandler
    implements ResourceChangeHandlerBase.IResourceMoveHandler {
        private RcMoveHandler() {
        }

        public void done() {
        }

        public void handleProjectClose(IProject project) {
            ResourceChangeHandler2.this.sendClose(project);
            try {
                ManagedBuildManager.setLoaddedBuildInfo(project, null);
            }
            catch (CoreException coreException) {}
        }

        public boolean handleResourceMove(IResource fromRc, IResource toRc) {
            switch (fromRc.getType()) {
                case 4: {
                    IProject fromProject = fromRc.getProject();
                    IProject toProject = toRc.getProject();
                    ManagedBuildInfo info = (ManagedBuildInfo)ManagedBuildManager.getBuildInfo((IResource)fromProject, false);
                    if (info == null) break;
                    info.updateOwner(toRc);
                    ManagedBuildManager.updateLoaddedInfo(fromProject, toProject, info);
                }
            }
            return false;
        }

        public boolean handleResourceRemove(IResource rc) {
            switch (rc.getType()) {
                case 4: {
                    IProject project = rc.getProject();
                    ResourceChangeHandler2.this.sendClose(project);
                    try {
                        ManagedBuildManager.setLoaddedBuildInfo(project, null);
                        break;
                    }
                    catch (CoreException coreException) {}
                }
            }
            return false;
        }
    }

    private static class Visitor
    implements IResourceDeltaVisitor {
        private Set fProjSet;

        Visitor(Set projSet) {
            this.fProjSet = projSet;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource rc = delta.getResource();
            switch (rc.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    IProject project;
                    IManagedBuildInfo info;
                    int flags = delta.getFlags();
                    if ((flags & 0x80000) == 524288 && (info = ManagedBuildManager.getBuildInfo((IResource)(project = rc.getProject()))) != null && info.isValid() && info.getManagedProject() != null) {
                        IProjectDescription eDes = project.getDescription();
                        IConfiguration[] cfgs = info.getManagedProject().getConfigurations();
                        String[] natureIds = eDes.getNatureIds();
                        int i = 0;
                        while (i < cfgs.length) {
                            String[] cachedIds = ConfigurationDataProvider.getNaturesIdsUsedOnCache(cfgs[i]);
                            if (ResourceChangeHandler2.checkNaturesNeedUpdate(cachedIds, natureIds)) {
                                if (this.fProjSet == null) {
                                    this.fProjSet = new HashSet();
                                }
                                this.fProjSet.add(project);
                                break;
                            }
                            ++i;
                        }
                    }
                    return false;
                }
            }
            return false;
        }

        Set getProjSet() {
            return this.fProjSet;
        }
    }
}

