/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ConverterInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ToolListModificationInfo;
import org.eclipse.core.runtime.IConfigurationElement;

class ToolChainModificationHelper {
    ToolChainModificationHelper() {
    }

    private static ListMap createRealToToolMap(ITool[] tools, boolean ext) {
        ListMap lMap = new ListMap();
        int i = 0;
        while (i < tools.length) {
            ITool t;
            ITool tool = tools[i];
            ITool rt = ManagedBuildManager.getRealTool(tool);
            if (rt == null) {
                rt = tool;
            }
            ITool iTool = t = ext ? ManagedBuildManager.getExtensionTool(tool) : tool;
            if (t == null) {
                t = tool;
            }
            lMap.add(rt, t);
            ++i;
        }
        return lMap;
    }

    private static ListMap calculateDifference(ListMap m1, ListMap m2) {
        m1 = (ListMap)m1.clone();
        Set ceSet2 = m2.collectionEntrySet();
        Iterator iter = ceSet2.iterator();
        while (iter.hasNext()) {
            ListMap.CollectionEntry entry = (ListMap.CollectionEntry)iter.next();
            List c1 = m2.get(entry.getKey(), false);
            if (c1 == null) continue;
            List c2 = entry.getValue();
            int i = c2.size();
            Iterator c1Iter = c1.iterator();
            while (i >= 0 && c1Iter.hasNext()) {
                c1Iter.next();
                c1Iter.remove();
                --i;
            }
        }
        return m1;
    }

    public static ToolListModificationInfo getModificationInfo(IResourceInfo rcInfo, ITool[] fromTools, ITool[] addedTools, ITool[] removedTools) {
        List cur;
        ListMap.CollectionEntry entry;
        ListMap addedMap = ToolChainModificationHelper.createRealToToolMap(addedTools, false);
        int i = 0;
        while (i < removedTools.length) {
            ITool removedTool = removedTools[i];
            ITool realTool = ManagedBuildManager.getRealTool(removedTool);
            if (realTool == null) {
                realTool = removedTool;
            }
            addedMap.remove((Object)realTool, 0);
            ++i;
        }
        ListMap removedMap = ToolChainModificationHelper.createRealToToolMap(removedTools, false);
        int i2 = 0;
        while (i2 < addedTools.length) {
            ITool addedTool = addedTools[i2];
            ITool realTool = ManagedBuildManager.getRealTool(addedTool);
            if (realTool == null) {
                realTool = addedTool;
            }
            removedMap.remove((Object)realTool, 0);
            ++i2;
        }
        addedMap.clearEmptyLists();
        removedMap.clearEmptyLists();
        ListMap curMap = ToolChainModificationHelper.createRealToToolMap(fromTools, false);
        Iterator iter = removedMap.collectionEntrySet().iterator();
        while (iter.hasNext()) {
            entry = (ListMap.CollectionEntry)iter.next();
            cur = curMap.get(entry.getKey(), false);
            List removed = entry.getValue();
            if (cur == null) continue;
            int numToRemove = removed.size();
            int curSize = cur.size();
            if (curSize <= numToRemove) {
                curMap.removeAll(entry.getKey());
                continue;
            }
            int i3 = 0;
            while (i3 < numToRemove) {
                cur.remove(0);
                ++i3;
            }
        }
        curMap.clearEmptyLists();
        iter = addedMap.collectionEntrySet().iterator();
        while (iter.hasNext()) {
            entry = (ListMap.CollectionEntry)iter.next();
            cur = curMap.get(entry.getKey(), true);
            List added = entry.getValue();
            int numToAdd = added.size();
            numToAdd -= cur.size();
            int i4 = 0;
            while (i4 < numToAdd) {
                cur.add(added.get(i4));
                ++i4;
            }
            if (cur.size() != 0) continue;
            curMap.removeAll(entry.getKey());
        }
        curMap.clearEmptyLists();
        ArrayList resultingList = new ArrayList();
        curMap.putValuesToCollection(resultingList);
        return ToolChainModificationHelper.getModificationInfo(rcInfo, fromTools, resultingList.toArray(new ITool[resultingList.size()]));
    }

    public static ToolListModificationInfo getModificationInfo(IResourceInfo rcInfo, ITool[] fromTools, ITool[] toTools) {
        ListMap curMap = ToolChainModificationHelper.createRealToToolMap(fromTools, false);
        ArrayList<ToolInfo> resultingList = new ArrayList<ToolInfo>();
        ArrayList<ToolInfo> addedList = new ArrayList<ToolInfo>(7);
        ArrayList<ToolInfo> remainedList = new ArrayList<ToolInfo>(7);
        ArrayList removedList = new ArrayList(7);
        int i = 0;
        while (i < toTools.length) {
            ToolInfo tInfo;
            ITool remaining;
            ITool tool = toTools[i];
            ITool realTool = ManagedBuildManager.getRealTool(tool);
            if (realTool == null) {
                realTool = tool;
            }
            if ((remaining = (ITool)curMap.remove((Object)realTool, 0)) != null) {
                tInfo = new ToolInfo(rcInfo, remaining, 4);
                remainedList.add(tInfo);
            } else {
                tInfo = new ToolInfo(rcInfo, tool, 1);
                addedList.add(tInfo);
            }
            resultingList.add(tInfo);
            ++i;
        }
        curMap.valuesToCollection(removedList);
        ListIterator<ToolInfo> iter = removedList.listIterator();
        while (iter.hasNext()) {
            ITool t = (ITool)iter.next();
            iter.set(new ToolInfo(rcInfo, t, 2));
        }
        ToolInfo[] added = ToolChainModificationHelper.listToArray(addedList);
        ToolInfo[] removed = ToolChainModificationHelper.listToArray(removedList);
        ToolChainModificationHelper.adjustAddedList(added, removed);
        ToolChainModificationHelper.calculateConverterTools(rcInfo, removed, added, null, null);
        return new ToolListModificationInfo(rcInfo, ToolChainModificationHelper.listToArray(resultingList), added, removed, ToolChainModificationHelper.listToArray(remainedList));
    }

    private static ITool getCommonSuperClass(ITool tool1, ITool tool2) {
        int i = 0;
        while (tool2 != null) {
            if (ToolChainModificationHelper.getSuperClassLevel(tool1, tool2) != -1) {
                return tool2;
            }
            tool2 = tool2.getSuperClass();
            ++i;
        }
        return null;
    }

    private static int getSuperClassLevel(ITool tool, ITool superClass) {
        int i = 0;
        while (tool != null) {
            if (superClass == tool) {
                return i;
            }
            tool = tool.getSuperClass();
            ++i;
        }
        return -1;
    }

    private static int getLevel(ITool tool) {
        int i = 0;
        while (tool != null) {
            tool = tool.getSuperClass();
            ++i;
        }
        return i;
    }

    private static ITool getBestMatchTool(ITool realTool, ToolInfo[] tools) {
        int num = -1;
        ITool bestMatch = null;
        ITool[] identicTools = ManagedBuildManager.findIdenticalTools(realTool);
        int i = 0;
        while (i < tools.length) {
            ITool extTool = ManagedBuildManager.getExtensionTool(tools[i].getInitialTool());
            int k = 0;
            while (k < identicTools.length) {
                int level;
                ITool identic = identicTools[k];
                ITool commonSuper = ToolChainModificationHelper.getCommonSuperClass(extTool, identic);
                if (commonSuper != null && (level = ToolChainModificationHelper.getLevel(commonSuper)) > num) {
                    bestMatch = identic;
                    num = level;
                }
                ++k;
            }
            ++i;
        }
        return bestMatch;
    }

    private static void adjustAddedList(ToolInfo[] adds, ToolInfo[] removes) {
        int i = 0;
        while (i < adds.length) {
            ToolInfo add = adds[i];
            ITool bestMatch = ToolChainModificationHelper.getBestMatchTool(add.getRealTool(), removes);
            if (bestMatch != null) {
                add.updateInitialTool(bestMatch);
            }
            ++i;
        }
    }

    private static ToolInfo[] listToArray(List list) {
        return list.toArray(new ToolInfo[list.size()]);
    }

    private static Map calculateConverterTools(IResourceInfo rcInfo, ToolInfo[] removed, ToolInfo[] added, List remainingRemoved, List remainingAdded) {
        if (remainingAdded == null) {
            remainingAdded = new ArrayList<ToolInfo>(added.length);
        }
        if (remainingRemoved == null) {
            remainingRemoved = new ArrayList<ToolInfo>(removed.length);
        }
        remainingAdded.clear();
        remainingRemoved.clear();
        remainingAdded.addAll(Arrays.asList(added));
        remainingRemoved.addAll(Arrays.asList(removed));
        HashMap<ITool, ConverterInfo> resultMap = new HashMap<ITool, ConverterInfo>();
        Iterator rIter = remainingRemoved.iterator();
        block0: while (rIter.hasNext()) {
            Map map;
            ToolInfo rti = (ToolInfo)rIter.next();
            ITool r = rti.getInitialTool();
            if (r == null || r.getParentResourceInfo() != rcInfo || (map = ManagedBuildManager.getConversionElements(r)).size() == 0) continue;
            Iterator aIter = remainingAdded.iterator();
            while (aIter.hasNext()) {
                IConfigurationElement el;
                ToolInfo ati = (ToolInfo)aIter.next();
                ITool a = ati.getBaseTool();
                if (a == null || a.getParentResourceInfo() == rcInfo || (a = ati.getBaseExtensionTool()) == null || (el = ToolChainModificationHelper.getToolConverterElement(r, a)) == null) continue;
                ConverterInfo ci = new ConverterInfo(rcInfo, r, a, el);
                resultMap.put(r, ci);
                rIter.remove();
                aIter.remove();
                ati.setConversionInfo(rti, ci);
                rti.setConversionInfo(ati, ci);
                continue block0;
            }
        }
        return resultMap;
    }

    private static IConfigurationElement getToolConverterElement(ITool fromTool, ITool toTool) {
        return ((Tool)fromTool).getConverterModificationElement(toTool);
    }

    static class ListMap
    implements Cloneable {
        private HashMap fMap = new HashMap();
        private CollectionEntrySet fCollectionEntrySet;

        public void add(Object key, Object value) {
            List l = this.get(key, true);
            l.add(value);
        }

        public List removeAll(Object key) {
            return (List)this.fMap.remove(key);
        }

        public List get(Object key, boolean create) {
            List l = (List)this.fMap.get(key);
            if (l == null && create) {
                l = this.newList(1);
                this.fMap.put(key, l);
            }
            return l;
        }

        public Collection valuesToCollection(Collection c) {
            if (c == null) {
                c = this.newList(20);
            }
            Iterator iter = this.fMap.values().iterator();
            while (iter.hasNext()) {
                List l = (List)iter.next();
                c.addAll(l);
            }
            return c;
        }

        protected List newList(int size) {
            return new ArrayList(size);
        }

        protected List cloneList(List l) {
            return (List)((ArrayList)l).clone();
        }

        public Collection putValuesToCollection(Collection c) {
            Iterator iter = this.collectionEntrySet().iterator();
            while (iter.hasNext()) {
                List l = ((CollectionEntry)iter.next()).getValue();
                c.addAll(l);
            }
            return c;
        }

        public void remove(Object key, Object value) {
            List c = this.get(key, false);
            if (c != null && c.remove(value) && c.size() == 0) {
                this.fMap.remove(key);
            }
        }

        public Object get(Object key, int num) {
            List l = this.get(key, false);
            if (l != null) {
                return l.get(num);
            }
            return null;
        }

        public Object remove(Object key, int num) {
            List l = this.get(key, false);
            if (l != null) {
                Object result = null;
                if (l.size() > num) {
                    result = l.remove(num);
                }
                return result;
            }
            return null;
        }

        public Object removeLast(Object key) {
            List l = this.get(key, false);
            if (l != null) {
                Object result = null;
                if (l.size() > 0) {
                    result = l.remove(l.size() - 1);
                }
                return result;
            }
            return null;
        }

        public void removeAll(Object key, Collection values) {
            List c = this.get(key, false);
            if (c != null && c.removeAll(values) && c.size() == 0) {
                this.fMap.remove(key);
            }
        }

        public void clearEmptyLists() {
            Iterator iter = this.fMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (((List)entry.getValue()).size() != 0) continue;
                iter.remove();
            }
        }

        public Set collectionEntrySet() {
            if (this.fCollectionEntrySet == null) {
                this.fCollectionEntrySet = new CollectionEntrySet();
            }
            return this.fCollectionEntrySet;
        }

        public void difference(ListMap map) {
            Iterator iter = map.fMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Collection thisC = (Collection)this.fMap.get(entry.getKey());
                if (thisC == null || !thisC.removeAll((Collection)entry.getValue()) || thisC != null) continue;
                this.fMap.remove(entry.getKey());
            }
        }

        public ValueIter valueIter() {
            return new ValueIter();
        }

        protected Object clone() {
            try {
                ListMap clone = (ListMap)super.clone();
                clone.fMap = (HashMap)this.fMap.clone();
                Iterator iter = clone.fMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    entry.setValue(this.cloneList((List)entry.getValue()));
                }
            }
            catch (CloneNotSupportedException e) {
                ManagedBuilderCorePlugin.log(e);
            }
            return null;
        }

        public class CollectionEntry {
            private Map.Entry fEntry;

            CollectionEntry(Map.Entry entry) {
                this.fEntry = entry;
            }

            public Object getKey() {
                return this.fEntry.getKey();
            }

            public List getValue() {
                return (List)this.fEntry.getValue();
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof CollectionEntry)) {
                    return false;
                }
                return this.fEntry.equals(((CollectionEntry)obj).fEntry);
            }

            public int hashCode() {
                return this.fEntry.hashCode();
            }
        }

        private class CollectionEntrySet
        extends AbstractSet {
            private Set fMapEntrySet;

            private CollectionEntrySet() {
                this.fMapEntrySet = ListMap.this.fMap.entrySet();
            }

            public Iterator iterator() {
                return new Iter();
            }

            public int size() {
                return this.fMapEntrySet.size();
            }

            private class Iter
            implements Iterator {
                private Iterator fIter;

                private Iter() {
                    this.fIter = CollectionEntrySet.this.fMapEntrySet.iterator();
                }

                public boolean hasNext() {
                    return this.fIter.hasNext();
                }

                public Object next() {
                    return new CollectionEntry((Map.Entry)this.fIter.next());
                }

                public void remove() {
                    this.fIter.remove();
                }
            }
        }

        public class ValueIter {
            private Map fIterMap;

            public ValueIter() {
                this.fIterMap = new HashMap(ListMap.this.fMap);
                Iterator iter = this.fIterMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Collection c = (Collection)entry.getValue();
                    entry.setValue(c.iterator());
                }
            }

            public Iterator get(Object key) {
                Iterator iter = (Iterator)this.fIterMap.get(key);
                if (iter != null && !iter.hasNext()) {
                    this.fIterMap.remove(key);
                    return null;
                }
                return iter;
            }
        }
    }
}

