/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.projectconverter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.ProjectConverter;
import org.eclipse.cdt.managedbuilder.projectconverter.ConverterMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class UpdateManagedProjectManager {
    private static ThreadLocal fThreadInfo = new ThreadLocal();
    private static IOverwriteQuery fBackupFileOverwriteQuery = null;
    private static IOverwriteQuery fOpenQuestionQuery = null;
    private static IOverwriteQuery fUpdateProjectQuery = null;
    private ManagedBuildInfo fConvertedInfo = null;
    private boolean fIsInfoReadOnly = false;
    private final IProject fProject;

    private UpdateManagedProjectManager(IProject project) {
        this.fProject = project;
    }

    public static void setBackupFileOverwriteQuery(IOverwriteQuery backupFileOverwriteQuery) {
        fBackupFileOverwriteQuery = backupFileOverwriteQuery;
    }

    public static void setUpdateProjectQuery(IOverwriteQuery updateProjectQuery) {
        fUpdateProjectQuery = updateProjectQuery;
    }

    private static synchronized UpdateManagedProjectManager getUpdateManager(IProject project) {
        UpdateManagedProjectManager mngr = UpdateManagedProjectManager.getExistingUpdateManager(project);
        if (mngr == null) {
            mngr = UpdateManagedProjectManager.createUpdateManager(project);
        }
        return mngr;
    }

    private static UpdateManagedProjectManager getExistingUpdateManager(IProject project) {
        Map map = UpdateManagedProjectManager.getManagerMap(false);
        return map != null ? (UpdateManagedProjectManager)map.get(project.getName()) : null;
    }

    private static UpdateManagedProjectManager createUpdateManager(IProject project) {
        UpdateManagedProjectManager mngr = new UpdateManagedProjectManager(project);
        UpdateManagedProjectManager.getManagerMap(true).put(project.getName(), mngr);
        return mngr;
    }

    private static void removeUpdateManager(IProject project) {
        UpdateManagedProjectManager mngr = UpdateManagedProjectManager.getExistingUpdateManager(project);
        if (mngr == null) {
            return;
        }
        UpdateManagedProjectManager.getManagerMap(false).remove(project.getName());
    }

    private static Map getManagerMap(boolean create) {
        HashMap map = (HashMap)fThreadInfo.get();
        if (map == null && create) {
            map = new HashMap();
            fThreadInfo.set(map);
        }
        return map;
    }

    protected static PluginVersionIdentifier getManagedBuildInfoVersion(String version) {
        if (version == null) {
            version = "1.2";
        }
        return new PluginVersionIdentifier(version);
    }

    public static boolean isCompatibleProject(IManagedBuildInfo info) {
        if (info == null) {
            return false;
        }
        PluginVersionIdentifier projVersion = UpdateManagedProjectManager.getManagedBuildInfoVersion(info.getVersion());
        PluginVersionIdentifier compVersion = ManagedBuildManager.getBuildInfoVersion();
        return compVersion.isEquivalentTo(projVersion);
    }

    static void backupFile(IFile settingsFile, String suffix, IProgressMonitor monitor, IProject project) {
        UpdateManagedProjectManager mngr = UpdateManagedProjectManager.getExistingUpdateManager(project);
        if (mngr == null || mngr.fIsInfoReadOnly) {
            return;
        }
        IProject destFolder = project;
        IFile dstFile = destFolder.getFile((IPath)new Path(String.valueOf(settingsFile.getName()) + suffix));
        mngr.backupFile(settingsFile, dstFile, monitor, project, fBackupFileOverwriteQuery);
    }

    public static void backupSettingsFile(IFile settingsFile, String suffix, IProgressMonitor monitor, IProject project) {
        UpdateManagedProjectManager mngr = UpdateManagedProjectManager.getUpdateManager(project);
        if (mngr == null || mngr.fIsInfoReadOnly) {
            return;
        }
        IProject destFolder = project;
        IFile dstFile = destFolder.getFile((IPath)new Path(String.valueOf(settingsFile.getName()) + suffix));
        mngr.backupFile(settingsFile, dstFile, monitor, project, fBackupFileOverwriteQuery);
    }

    private void backupFile(IFile srcFile, IFile dstFile, IProgressMonitor monitor, IProject project, IOverwriteQuery query) {
        File src = srcFile.getLocation().toFile();
        File dst = dstFile.getLocation().toFile();
        this.backupFile(src, dst, monitor, project, query);
    }

    private void backupFile(File srcFile, File dstFile, IProgressMonitor monitor, IProject project, IOverwriteQuery query) {
        try {
            if (dstFile.exists()) {
                boolean shouldUpdate = query != null ? ProjectConverter.getBooleanFromQueryAnswer(query.queryOverwrite(dstFile.getName())) : ProjectConverter.openQuestion((IResource)this.fProject, "UpdateManagedProjectManager.0", ConverterMessages.getResourceString("UpdateManagedProjectManager.0"), ConverterMessages.getFormattedString("UpdateManagedProjectManager.1", new String[]{dstFile.getName(), project.getName()}), fOpenQuestionQuery, false);
                if (shouldUpdate) {
                    dstFile.delete();
                } else {
                    throw new OperationCanceledException(ConverterMessages.getFormattedString("UpdateManagedProjectManager.2", project.getName()));
                }
            }
            this.copyFile(srcFile, dstFile);
        }
        catch (Exception exception) {
            this.fIsInfoReadOnly = true;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void copyFile(File src, File dst) throws IOException {
        FileOutputStream fos;
        block5: {
            FileInputStream fis = null;
            fos = null;
            try {
                fis = new FileInputStream(src);
                fos = new FileOutputStream(dst);
                byte[] buf = new byte[1024];
                int len = 0;
                while ((len = fis.read(buf)) > 0) {
                    fos.write(buf, 0, len);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (fis != null) {
                    fis.close();
                }
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            {
                Object var7_9 = null;
                if (fis == null) break block5;
            }
            fis.close();
        }
        if (fos == null) return;
        fos.close();
    }

    private void restoreFile(String backupFileName, String restoreFileName, IProgressMonitor monitor, IProject project) {
        IProject destFolder = project;
        File restoreFile = destFolder.getFile((IPath)new Path(restoreFileName)).getLocation().toFile();
        File backupFile = destFolder.getFile((IPath)new Path(backupFileName)).getLocation().toFile();
        try {
            if (restoreFile.exists()) {
                restoreFile.delete();
            }
            this.copyFile(backupFile, restoreFile);
        }
        catch (Exception exception) {
            this.fIsInfoReadOnly = true;
        }
    }

    public static ManagedBuildInfo getConvertedManagedBuildInfo(IProject project) {
        UpdateManagedProjectManager mngr = UpdateManagedProjectManager.getExistingUpdateManager(project);
        if (mngr == null) {
            return null;
        }
        return mngr.getConvertedManagedBuildInfo();
    }

    private ManagedBuildInfo getConvertedManagedBuildInfo() {
        return this.fConvertedInfo;
    }

    /*
     * Exception decompiling
     */
    private void doProjectUpdate(ManagedBuildInfo info) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 589->593)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateProject(IProject project, ManagedBuildInfo info) throws CoreException {
        try {
            UpdateManagedProjectManager.getUpdateManager(project).doProjectUpdate(info);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            UpdateManagedProjectManager.removeUpdateManager(project);
            IWorkspace workspace = project.getWorkspace();
            ISchedulingRule rule = workspace.getRuleFactory().refreshRule((IResource)project);
            WorkspaceJob job = new WorkspaceJob("Refresh Project", project){
                private final /* synthetic */ IProject val$project;
                {
                    this.val$project = iProject;
                    super($anonymous0);
                }

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    this.val$project.refreshLocal(1, null);
                    return Status.OK_STATUS;
                }
            };
            job.setRule(rule);
            job.schedule();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        UpdateManagedProjectManager.removeUpdateManager(project);
        IWorkspace workspace = project.getWorkspace();
        ISchedulingRule rule = workspace.getRuleFactory().refreshRule((IResource)project);
        WorkspaceJob job = new /* invalid duplicate definition of identical inner class */;
        job.setRule(rule);
        job.schedule();
    }
}

