/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class OpenActionUtil {
    private OpenActionUtil() {
    }

    public static void open(Object element) throws CModelException, PartInitException {
        OpenActionUtil.open(element, true);
    }

    public static void open(Object element, boolean activate) throws CModelException, PartInitException {
        IEditorPart part = EditorUtility.openInEditor(element, activate);
        if (element instanceof ICElement) {
            EditorUtility.revealInEditor(part, (ICElement)element);
        }
    }

    public static List filterResolveResults(ICElement[] codeResolveResults) {
        int nResults = codeResolveResults.length;
        ArrayList<ICElement> refs = new ArrayList<ICElement>(nResults);
        int i = 0;
        while (i < nResults) {
            if (codeResolveResults[i] instanceof ISourceReference) {
                refs.add(codeResolveResults[i]);
            }
            ++i;
        }
        return refs;
    }

    public static ICElement selectCElement(ICElement[] elements, Shell shell, String title, String message) {
        return OpenActionUtil.selectCElement(elements, shell, title, message, 0, 0);
    }

    public static ICElement selectCElement(ICElement[] elements, Shell shell, String title, String message, int textFlags, int imageFlags) {
        Object[] selection;
        int nResults = elements.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return elements[0];
        }
        LabelProvider labelProvider = textFlags == 0 && imageFlags == 0 ? new CElementLabelProvider(CElementLabelProvider.SHOW_DEFAULT | 0x400) : new CUILabelProvider(textFlags, imageFlags);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)labelProvider);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements((Object[])elements);
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            nResults = selection.length;
            int i = 0;
            while (i < nResults) {
                Object current = selection[i];
                if (current instanceof ICElement) {
                    return (ICElement)current;
                }
                ++i;
            }
        }
        return null;
    }
}

