/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.callhierarchy;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.ui.callhierarchy.CHContentProvider;
import org.eclipse.cdt.internal.ui.callhierarchy.CHNode;
import org.eclipse.cdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.cdt.internal.ui.callhierarchy.CalledByResult;
import org.eclipse.cdt.internal.ui.callhierarchy.CallsToResult;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class CHQueries {
    private static final CHNode[] EMPTY_NODES = new CHNode[0];

    private CHQueries() {
    }

    public static CHNode[] findCalledBy(CHContentProvider cp, CHNode node, IIndex index, IProgressMonitor pm) throws CoreException {
        CalledByResult result = new CalledByResult();
        ICElement callee = node.getRepresentedDeclaration();
        if (!(callee instanceof ISourceReference)) {
            return EMPTY_NODES;
        }
        IIndexBinding calleeBinding = IndexUI.elementToBinding(index, callee);
        CHQueries.findCalledBy(index, (IBinding)calleeBinding, callee.getCProject(), result);
        return cp.createNodes(node, result);
    }

    private static void findCalledBy(IIndex index, IBinding callee, ICProject project, CalledByResult result) throws CoreException {
        if (callee != null) {
            IIndexName[] names = index.findReferences(callee);
            int i = 0;
            while (i < names.length) {
                ICElementHandle elem;
                IIndexName rname = names[i];
                IIndexName caller = rname.getEnclosingDefinition();
                if (caller != null && (elem = IndexUI.getCElementForName(project, index, caller)) != null) {
                    result.add((ICElement)elem, rname);
                }
                ++i;
            }
        }
    }

    public static CHNode[] findCalls(CHContentProvider cp, CHNode node, IIndex index, IProgressMonitor pm) throws CoreException {
        ICElement caller = node.getRepresentedDeclaration();
        CallsToResult result = new CallsToResult();
        IIndexName callerName = IndexUI.elementToName(index, caller);
        if (callerName != null) {
            IIndexName[] refs = callerName.getEnclosedNames();
            int i = 0;
            while (i < refs.length) {
                ICElementHandle[] defs;
                IIndexName name = refs[i];
                IIndexBinding binding = index.findBinding((IName)name);
                if (CallHierarchyUI.isRelevantForCallHierarchy((IBinding)binding) && (defs = IndexUI.findRepresentative(index, (IBinding)binding)) != null && defs.length > 0) {
                    result.add((ICElement[])defs, name);
                }
                ++i;
            }
        }
        return cp.createNodes(node, result);
    }
}

