/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BuildConsolePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREF_CLEAR_CONSOLE = "clearConsole";
    private static final String PREF_CONSOLE_ON_TOP = "consoleOnTop";
    private static final String PREF_AUTO_OPEN_CONSOLE = "autoOpenConsole";
    public static final String PREF_BUILDCONSOLE_FONT = "org.eclipse.cdt.ui.buildconsole.ConsoleFont";
    public static final String PREF_BUILDCONSOLE_TAB_WIDTH = "buildConsoleTabWith";
    public static final String PREF_BUILDCONSOLE_LINES = "buildConsoleLines";
    public static final String PREF_BUILDCONSOLE_INFO_COLOR = "buildConsoleInfoStreamColor";
    public static final String PREF_BUILDCONSOLE_OUTPUT_COLOR = "buildConsoleOutputStreamColor";
    public static final String PREF_BUILDCONSOLE_ERROR_COLOR = "buildConsoleErrorStreamColor";

    public BuildConsolePreferencePage() {
        super(1);
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        BooleanFieldEditor clearConsole = new BooleanFieldEditor(PREF_CLEAR_CONSOLE, CUIPlugin.getResourceString("ConsolePreferencePage.clearConsole.label"), parent);
        this.addField((FieldEditor)clearConsole);
        BooleanFieldEditor autoOpenConsole = new BooleanFieldEditor(PREF_AUTO_OPEN_CONSOLE, CUIPlugin.getResourceString("ConsolePreferencePage.autoOpenConsole.label"), parent);
        this.addField((FieldEditor)autoOpenConsole);
        BooleanFieldEditor consoleOnTop = new BooleanFieldEditor(PREF_CONSOLE_ON_TOP, CUIPlugin.getResourceString("ConsolePreferencePage.consoleOnTop.label"), parent);
        this.addField((FieldEditor)consoleOnTop);
        IntegerFieldEditor buildCount = new IntegerFieldEditor(PREF_BUILDCONSOLE_LINES, CUIPlugin.getResourceString("ConsolePreferencePage.consoleLines.label"), parent);
        buildCount.setErrorMessage(CUIPlugin.getResourceString("ConsolePreferencePage.consoleLines.errorMessage"));
        buildCount.setValidRange(10, Integer.MAX_VALUE);
        this.addField((FieldEditor)buildCount);
        IntegerFieldEditor tabSize = new IntegerFieldEditor(PREF_BUILDCONSOLE_TAB_WIDTH, CUIPlugin.getResourceString("ConsolePreferencePage.tabWidth.label"), parent);
        this.addField((FieldEditor)tabSize);
        tabSize.setValidRange(1, 100);
        tabSize.setErrorMessage(CUIPlugin.getResourceString("ConsolePreferencePage.tabWidth.errorMessage"));
        this.createLabel(parent, CUIPlugin.getResourceString("ConsolePreferencePage.colorSettings.label"));
        this.addField((FieldEditor)this.createColorFieldEditor(PREF_BUILDCONSOLE_OUTPUT_COLOR, CUIPlugin.getResourceString("ConsolePreferencePage.outputColor.label"), parent));
        this.addField((FieldEditor)this.createColorFieldEditor(PREF_BUILDCONSOLE_INFO_COLOR, CUIPlugin.getResourceString("ConsolePreferencePage.infoColor.label"), parent));
        this.addField((FieldEditor)this.createColorFieldEditor(PREF_BUILDCONSOLE_ERROR_COLOR, CUIPlugin.getResourceString("ConsolePreferencePage.errorColor.label"), parent));
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private ColorFieldEditor createColorFieldEditor(String preferenceName, String label, Composite parent) {
        ColorFieldEditor editor = new ColorFieldEditor(preferenceName, label, parent);
        editor.setPage((DialogPage)this);
        editor.setPreferenceStore(this.getPreferenceStore());
        return editor;
    }

    public static boolean isClearBuildConsole() {
        return CUIPlugin.getDefault().getPreferenceStore().getBoolean(PREF_CLEAR_CONSOLE);
    }

    public static boolean isAutoOpenConsole() {
        return CUIPlugin.getDefault().getPreferenceStore().getBoolean(PREF_AUTO_OPEN_CONSOLE);
    }

    public static boolean isConsoleOnTop() {
        return CUIPlugin.getDefault().getPreferenceStore().getBoolean(PREF_CONSOLE_ON_TOP);
    }

    public static int buildConsoleLines() {
        return CUIPlugin.getDefault().getPreferenceStore().getInt(PREF_BUILDCONSOLE_LINES);
    }

    public void init(IWorkbench workbench) {
    }

    public static void initDefaults(IPreferenceStore prefs) {
        prefs.setDefault(PREF_CLEAR_CONSOLE, true);
        prefs.setDefault(PREF_AUTO_OPEN_CONSOLE, true);
        prefs.setDefault(PREF_CONSOLE_ON_TOP, false);
        prefs.setDefault(PREF_BUILDCONSOLE_LINES, 500);
        prefs.setDefault(PREF_BUILDCONSOLE_TAB_WIDTH, 4);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)PREF_BUILDCONSOLE_OUTPUT_COLOR, (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)PREF_BUILDCONSOLE_INFO_COLOR, (RGB)new RGB(0, 0, 255));
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)PREF_BUILDCONSOLE_ERROR_COLOR, (RGB)new RGB(255, 0, 0));
    }
}

