/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterProfileManager;
import org.eclipse.cdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.cdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.cdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.cdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.BackingStoreException;

public class FormatterProfileStore
extends ProfileStore {
    private static final String PREF_FORMATTER_PROFILES = "org.eclipse.jdt.ui.formatterprofiles";

    public FormatterProfileStore(IProfileVersioner profileVersioner) {
        super(PREF_FORMATTER_PROFILES, profileVersioner);
    }

    public List readProfiles(IScopeContext scope) throws CoreException {
        List profiles = super.readProfiles(scope);
        return profiles;
    }

    public static void checkCurrentOptionsVersion() {
        PreferencesAccess access = PreferencesAccess.getOriginalPreferences();
        ProfileVersioner profileVersioner = new ProfileVersioner();
        IScopeContext instanceScope = access.getInstanceScope();
        IEclipsePreferences uiPreferences = instanceScope.getNode("org.eclipse.cdt.ui");
        int version = uiPreferences.getInt("org.eclipse.jdt.ui.formatterprofiles.version", 0);
        if (version >= profileVersioner.getCurrentVersion()) {
            return;
        }
        try {
            FormatterProfileManager manager;
            ArrayList profiles = new FormatterProfileStore(profileVersioner).readProfiles(instanceScope);
            if (profiles == null) {
                profiles = new ArrayList();
            }
            if ((manager = new FormatterProfileManager(profiles, instanceScope, access, profileVersioner)).getSelected() instanceof ProfileManager.CustomProfile) {
                manager.commitChanges(instanceScope);
            }
            uiPreferences.putInt("org.eclipse.jdt.ui.formatterprofiles.version", profileVersioner.getCurrentVersion());
            FormatterProfileStore.savePreferences(instanceScope);
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IScopeContext scope = access.getProjectScope(projects[i]);
                if (manager.hasProjectSpecificSettings(scope)) {
                    manager = new FormatterProfileManager(profiles, scope, access, profileVersioner);
                    manager.commitChanges(scope);
                    FormatterProfileStore.savePreferences(scope);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
        }
        catch (BackingStoreException e) {
            CUIPlugin.getDefault().log(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void savePreferences(IScopeContext context) throws BackingStoreException {
        try {
            context.getNode("org.eclipse.cdt.ui").flush();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            context.getNode("org.eclipse.cdt.core").flush();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        context.getNode("org.eclipse.cdt.core").flush();
    }
}

