/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.internal.ui.text.AbstractCScanner;
import org.eclipse.cdt.internal.ui.text.CHeaderRule;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.PreprocessorRule;
import org.eclipse.cdt.internal.ui.text.util.CWhitespaceDetector;
import org.eclipse.cdt.internal.ui.text.util.CWordDetector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class CPreprocessorScanner
extends AbstractCScanner {
    private static String[] fgTokenProperties = new String[]{"c_single_line_comment", "c_multi_line_comment", "c_keyword", "pp_directive", "pp_default", "c_type", "c_string", "pp_header"};
    private ICLanguageKeywords fKeywords;

    public CPreprocessorScanner(IColorManager manager, IPreferenceStore store, ICLanguageKeywords keywords) {
        super(manager, store);
        this.fKeywords = keywords;
        this.initialize();
    }

    protected List createRules() {
        Token defaultToken = this.getToken("pp_default");
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new CWhitespaceDetector()));
        Token token = this.getToken("pp_directive");
        PreprocessorRule preprocessorRule = new PreprocessorRule(new CWordDetector(), (IToken)defaultToken);
        String[] ppKeywords = this.fKeywords.getPreprocessorKeywords();
        int i = 0;
        while (i < ppKeywords.length) {
            preprocessorRule.addWord(ppKeywords[i], (IToken)token);
            ++i;
        }
        preprocessorRule.addWord("##", (IToken)token);
        rules.add((Object)preprocessorRule);
        WordRule wordRule = new WordRule((IWordDetector)new CWordDetector(), (IToken)defaultToken);
        token = this.getToken("c_keyword");
        String[] keywords = this.fKeywords.getKeywords();
        int i2 = 0;
        while (i2 < keywords.length) {
            wordRule.addWord(keywords[i2], (IToken)token);
            ++i2;
        }
        token = this.getToken("c_type");
        String[] types = this.fKeywords.getBuiltinTypes();
        int i3 = 0;
        while (i3 < types.length) {
            wordRule.addWord(types[i3], (IToken)token);
            ++i3;
        }
        rules.add(wordRule);
        token = this.getToken("pp_header");
        CHeaderRule headerRule = new CHeaderRule((IToken)token);
        rules.add(headerRule);
        token = this.getToken("c_single_line_comment");
        EndOfLineRule lineCommentRule = new EndOfLineRule("//", (IToken)token, '\\', true);
        rules.add(lineCommentRule);
        token = this.getToken("c_multi_line_comment");
        MultiLineRule blockCommentRule = new MultiLineRule("/*", "*/", (IToken)token, '\\');
        rules.add(blockCommentRule);
        token = this.getToken("c_string");
        PatternRule stringRule = new PatternRule("\"", "\"", (IToken)token, '\\', true, true, true);
        rules.add(stringRule);
        token = this.getToken("c_string");
        PatternRule charRule = new PatternRule("'", "'", (IToken)token, '\\', true, true, true);
        rules.add(charRule);
        this.setDefaultReturnToken((IToken)defaultToken);
        return rules;
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }
}

