/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.classwizard;

import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.ui.wizards.classwizard.AbstractMethodStub;
import org.eclipse.cdt.internal.ui.wizards.classwizard.IBaseClassInfo;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardMessages;

public final class DestructorMethodStub
extends AbstractMethodStub {
    private static String NAME = NewClassWizardMessages.getString("NewClassCodeGeneration.stub.destructor.name");

    public DestructorMethodStub() {
        this(ASTAccessVisibility.PUBLIC, true, false);
    }

    public DestructorMethodStub(ASTAccessVisibility access, boolean isVirtual, boolean isInline) {
        super(NAME, access, isVirtual, isInline);
    }

    public String createMethodDeclaration(String className, IBaseClassInfo[] baseClasses, String lineDelimiter) {
        StringBuffer buf = new StringBuffer();
        if (this.fIsVirtual) {
            buf.append("virtual ");
        }
        buf.append("~");
        buf.append(className);
        buf.append("()");
        if (this.fIsInline) {
            buf.append(" {}");
        } else {
            buf.append(";");
        }
        return buf.toString();
    }

    public String createMethodImplementation(String className, IBaseClassInfo[] baseClasses, String lineDelimiter) {
        if (this.fIsInline) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(className);
        buf.append("::~");
        buf.append(className);
        buf.append("()");
        buf.append(lineDelimiter);
        buf.append('{');
        buf.append(lineDelimiter);
        buf.append('}');
        return buf.toString();
    }

    public boolean isDestructor() {
        return true;
    }
}

