/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.indexwizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.pdom.TeamPDOMExportOperation;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.cdt.internal.ui.viewsupport.ListContentProvider;
import org.eclipse.cdt.internal.ui.wizards.indexwizards.Messages;
import org.eclipse.cdt.internal.ui.wizards.indexwizards.StringVariableSelectionDialog;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardDataTransferPage;

public class TeamProjectIndexExportWizardPage
extends WizardDataTransferPage
implements Listener {
    private IStructuredSelection fInitialSelection;
    private CheckboxTableViewer fProjectViewer;
    private Text fDestinationField;

    protected TeamProjectIndexExportWizardPage(String name, IStructuredSelection selection) {
        super(name);
        this.fInitialSelection = selection;
    }

    public TeamProjectIndexExportWizardPage(IStructuredSelection selection) {
        this("indexExportPage", selection);
        this.setTitle(Messages.TeamProjectIndexExportWizardPage_title);
        this.setDescription(Messages.TeamProjectIndexExportWizardPage_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.createResourcesGroup(composite);
        this.createDestinationGroup(composite);
        this.restoreWidgetValues();
        if (this.fInitialSelection != null) {
            this.setupBasedOnInitialSelections();
        }
        this.setupDestination();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setErrorMessage(null);
        this.setControl((Control)composite);
        this.giveFocusToDestination();
    }

    private final void createResourcesGroup(Composite parent) {
        Composite resourcesGroup = new Composite(parent, 0);
        resourcesGroup.setLayout((Layout)new GridLayout());
        resourcesGroup.setLayoutData((Object)new GridData(1808));
        resourcesGroup.setFont(parent.getFont());
        new Label(resourcesGroup, 0).setText(Messages.TeamProjectIndexExportWizardPage_labelProjectTable);
        Table table = new Table(resourcesGroup, 2080);
        table.setLayoutData((Object)new GridData(1808));
        this.fProjectViewer = new CheckboxTableViewer(table);
        this.fProjectViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.fProjectViewer.setLabelProvider((IBaseLabelProvider)new CElementLabelProvider());
        ICheckStateListener checkListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                TeamProjectIndexExportWizardPage.this.updateWidgetEnablements();
            }
        };
        this.fProjectViewer.addCheckStateListener(checkListener);
        Composite buttonComposite = new Composite(resourcesGroup, 0);
        buttonComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(272));
        Button selectButton = this.createButton(buttonComposite, 18, Messages.TeamProjectIndexExportWizardPage_selectAll, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamProjectIndexExportWizardPage.this.fProjectViewer.setAllChecked(true);
                TeamProjectIndexExportWizardPage.this.updateWidgetEnablements();
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, Messages.TeamProjectIndexExportWizardPage_deselectAll, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamProjectIndexExportWizardPage.this.fProjectViewer.setAllChecked(false);
                TeamProjectIndexExportWizardPage.this.updateWidgetEnablements();
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
        this.initProjects();
    }

    private Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = new Button(parent, 8);
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)new Integer(id));
        button.setText(label);
        button.setFont(parent.getFont());
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        button.setFont(parent.getFont());
        this.setButtonLayoutData(button);
        return button;
    }

    private void initProjects() {
        ArrayList<ICProject> input = new ArrayList<ICProject>();
        try {
            ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
            int i = 0;
            while (i < projects.length) {
                if (projects[i].getProject().isOpen()) {
                    input.add(projects[i]);
                }
                ++i;
            }
        }
        catch (CModelException e) {
            CUIPlugin.getDefault().log(e);
        }
        this.fProjectViewer.setInput(input);
    }

    private void setupBasedOnInitialSelections() {
        HashSet<String> names = new HashSet<String>();
        Iterator it = this.fInitialSelection.iterator();
        while (it.hasNext()) {
            IProject project = (IProject)it.next();
            names.add(project.getName());
        }
        Collection prjs = (Collection)this.fProjectViewer.getInput();
        Iterator iterator = prjs.iterator();
        while (iterator.hasNext()) {
            ICProject prj = (ICProject)iterator.next();
            if (!names.contains(prj.getElementName())) continue;
            this.fProjectViewer.setChecked((Object)prj, true);
        }
    }

    private void setupDestination() {
        ICProject[] prjs = this.getCheckedElements();
        String dest = prjs.length > 0 ? IndexerPreferences.getIndexImportLocation((IProject)prjs[0].getProject()) : IndexerPreferences.getIndexImportLocation(null);
        this.fDestinationField.setText(dest);
    }

    private void createDestinationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite destinationSelectionGroup = new Composite(parent, 0);
        destinationSelectionGroup.setLayout((Layout)new GridLayout(2, false));
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        destinationSelectionGroup.setFont(font);
        Label destinationLabel = new Label(destinationSelectionGroup, 0);
        destinationLabel.setText(Messages.TeamProjectIndexExportWizardPage_destinationLabel);
        destinationLabel.setFont(font);
        GridData gd = new GridData();
        destinationLabel.setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        this.fDestinationField = new Text(destinationSelectionGroup, 2048);
        this.fDestinationField.addListener(24, (Listener)this);
        this.fDestinationField.addListener(13, (Listener)this);
        this.fDestinationField.setFont(font);
        gd = new GridData();
        this.fDestinationField.setLayoutData((Object)gd);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.widthHint = 250;
        Button button = this.createButton(destinationSelectionGroup, 1024, Messages.TeamProjectIndexExportWizardPage_variableButton, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamProjectIndexExportWizardPage.this.onInsertVariable();
            }
        };
        button.addSelectionListener((SelectionListener)listener);
    }

    protected void onInsertVariable() {
        StringVariableSelectionDialog dlg = new StringVariableSelectionDialog(this.getShell());
        if (dlg.open() == 0) {
            String var = dlg.getVariableExpression();
            this.fDestinationField.insert(var);
        }
    }

    public boolean finish() {
        ICProject[] projectsToExport = this.getCheckedElements();
        this.saveWidgetValues();
        return this.executeExportOperation(projectsToExport);
    }

    private ICProject[] getCheckedElements() {
        Object[] obj = this.fProjectViewer.getCheckedElements();
        ICProject[] prjs = new ICProject[obj.length];
        System.arraycopy(obj, 0, prjs, 0, obj.length);
        return prjs;
    }

    private boolean executeExportOperation(final ICProject[] projects) {
        final String dest = this.getDestinationValue();
        final MultiStatus status = new MultiStatus("org.eclipse.cdt.ui", 0, Messages.TeamProjectIndexExportWizardPage_errorExporting, null);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("", projects.length);
                int i = 0;
                while (i < projects.length) {
                    ICProject project = projects[i];
                    TeamPDOMExportOperation op = new TeamPDOMExportOperation(project);
                    op.setTargetLocation(dest);
                    try {
                        op.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        status.merge(e.getStatus());
                    }
                    ++i;
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)this.getErrorDialogTitle(), null, (IStatus)status);
            return false;
        }
        return true;
    }

    private String getDestinationValue() {
        return this.fDestinationField.getText().trim();
    }

    private void giveFocusToDestination() {
        this.fDestinationField.setFocus();
    }

    protected boolean validateDestinationGroup() {
        String destinationValue = this.getDestinationValue();
        if (destinationValue.length() == 0) {
            this.setMessage(Messages.TeamProjectIndexExportWizardPage_destinationMessage);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean validateSourceGroup() {
        boolean isValid = true;
        ICProject[] projectsToExport = this.getCheckedElements();
        if (projectsToExport.length == 0) {
            this.setErrorMessage(Messages.TeamProjectIndexExportWizardPage_noProjectError);
            isValid = false;
        } else {
            this.setErrorMessage(null);
        }
        return super.validateSourceGroup() && isValid;
    }

    protected void updateWidgetEnablements() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
        super.updateWidgetEnablements();
    }

    public void handleEvent(Event event) {
        this.updateWidgetEnablements();
    }

    protected String getErrorDialogTitle() {
        return Messages.TeamProjectIndexExportWizardPage_errorDlgTitle;
    }

    protected boolean allowNewContainerName() {
        return false;
    }
}

