/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.Properties;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.DialogsMessages;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractIndexerPage
extends AbstractCOptionPage {
    protected static final String INDEX_ALL_FILES = DialogsMessages.AbstractIndexerPage_indexAllFiles;
    protected static final String TRUE = String.valueOf(true);
    private Button fAllFiles;
    private Text fFilesToParseUpFront;
    private Button fSkipReferences;
    private Button fSkipTypeReferences;

    protected AbstractIndexerPage() {
    }

    public final IProject getCurrentProject() {
        ICOptionContainer container = this.getContainer();
        if (container != null) {
            return container.getProject();
        }
        return null;
    }

    public void createControl(Composite parent) {
        Composite page = ControlFactory.createComposite(parent, 1);
        this.fAllFiles = this.createAllFilesButton(page);
        this.fSkipReferences = this.createSkipReferencesButton(page);
        this.fSkipTypeReferences = this.createSkipTypeReferencesButton(page);
        this.fFilesToParseUpFront = this.createParseUpFrontTextField(page);
        this.fSkipReferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractIndexerPage.this.updateEnablement();
            }
        });
        this.setControl((Control)page);
    }

    public void setProperties(Properties properties) {
        if (this.fAllFiles != null) {
            boolean indexAllFiles = TRUE.equals(properties.get("indexAllFiles"));
            this.fAllFiles.setSelection(indexAllFiles);
        }
        if (this.fSkipReferences != null) {
            boolean skipReferences = TRUE.equals(properties.get("skipReferences"));
            this.fSkipReferences.setSelection(skipReferences);
        }
        if (this.fSkipTypeReferences != null) {
            boolean skipTypeReferences = TRUE.equals(properties.get("skipTypeReferences"));
            this.fSkipTypeReferences.setSelection(skipTypeReferences);
        }
        if (this.fFilesToParseUpFront != null) {
            String files = this.getNotNull(properties, "filesToParseUpFront");
            this.fFilesToParseUpFront.setText(files);
        }
        this.updateEnablement();
    }

    public Properties getProperties() {
        Properties props = new Properties();
        if (this.fAllFiles != null) {
            props.put("indexAllFiles", String.valueOf(this.fAllFiles.getSelection()));
        }
        if (this.fFilesToParseUpFront != null) {
            props.put("filesToParseUpFront", this.fFilesToParseUpFront.getText());
        }
        if (this.fSkipReferences != null) {
            props.put("skipReferences", String.valueOf(this.fSkipReferences.getSelection()));
        }
        if (this.fSkipTypeReferences != null) {
            props.put("skipTypeReferences", String.valueOf(this.fSkipTypeReferences.getSelection()));
        }
        return props;
    }

    public final void performApply(IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public final void performDefaults() {
        throw new UnsupportedOperationException();
    }

    public void updateEnablement() {
        if (this.fSkipReferences != null && this.fSkipTypeReferences != null) {
            this.fSkipTypeReferences.setEnabled(!this.fSkipReferences.getSelection());
        }
    }

    private String getNotNull(Properties properties, String key) {
        String files = (String)properties.get(key);
        if (files == null) {
            files = "";
        }
        return files;
    }

    private Text createParseUpFrontTextField(Composite page) {
        Label l = ControlFactory.createLabel(page, DialogsMessages.AbstractIndexerPage_indexUpFront);
        ((GridData)l.getLayoutData()).verticalIndent = 5;
        return ControlFactory.createTextField(page);
    }

    private Button createAllFilesButton(Composite page) {
        return ControlFactory.createCheckBox(page, INDEX_ALL_FILES);
    }

    private Button createSkipReferencesButton(Composite page) {
        return ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_skipAllReferences);
    }

    private Button createSkipTypeReferencesButton(Composite page) {
        return ControlFactory.createCheckBox(page, DialogsMessages.AbstractIndexerPage_skipTypeReferences);
    }
}

