/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.cdt.ui.templateengine.TemplateListSelectionPage;
import org.eclipse.cdt.ui.templateengine.pages.UIWizardPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

class WizardNode
implements IWizardNode {
    private IWizard wizard;
    private Template template;
    private TemplateListSelectionPage parentPage;

    public WizardNode(TemplateListSelectionPage parentPage, Template template) {
        this.parentPage = parentPage;
        this.template = template;
    }

    public void dispose() {
        if (this.wizard != null) {
            this.wizard.dispose();
            this.wizard = null;
        }
    }

    public Template getTemplate() {
        return this.template;
    }

    public Point getExtent() {
        return new Point(-1, -1);
    }

    public IWizard getWizard() {
        if (this.wizard != null) {
            return this.wizard;
        }
        this.wizard = new Wizard(){
            private boolean finishPressed;
            {
                this.setWindowTitle(WizardNode.this.template.getLabel());
            }

            public void addPages() {
                IWizardPage[] wpages = null;
                try {
                    wpages = WizardNode.this.parentPage.getPagesAfterTemplateSelection();
                }
                catch (Exception exception) {}
                int i = 0;
                while (i < wpages.length) {
                    this.addPage(wpages[i]);
                    ++i;
                }
                Map pages = WizardNode.this.template.getUIPages();
                Iterator i2 = WizardNode.this.template.getPagesOrderVector().iterator();
                while (i2.hasNext()) {
                    String id = (String)i2.next();
                    this.addPage((UIWizardPage)pages.get(id));
                }
                wpages = WizardNode.this.parentPage.getPagesAfterTemplatePages();
                int i22 = 0;
                while (i22 < wpages.length) {
                    this.addPage(wpages[i22]);
                    ++i22;
                }
            }

            public boolean performFinish() {
                Map valueStore = WizardNode.this.template.getValueStore();
                this.finishPressed = true;
                this.getContainer().updateButtons();
                IWizardPage[] wpages = this.getPages();
                int i = 0;
                while (i < wpages.length) {
                    IWizardPage page = wpages[i];
                    if (page instanceof UIWizardPage) {
                        valueStore.putAll(((UIWizardPage)page).getPageData());
                    }
                    ++i;
                }
                WizardNode.this.template.getValueStore().putAll(WizardNode.this.parentPage.getDataInPreviousPages());
                return true;
            }

            public boolean canFinish() {
                return !this.finishPressed && super.canFinish();
            }

            public void createPageControls(Composite pageContainer) {
                super.createPageControls(pageContainer);
                WizardNode.this.parentPage.adjustTemplateValues(WizardNode.this.template);
                IWizardPage[] wpages = this.getPages();
                int i = 0;
                while (i < wpages.length) {
                    IWizardPage page = wpages[i];
                    if (page instanceof UIWizardPage) {
                        ((UIWizardPage)page).getComposite().getUIElement().setValues(WizardNode.this.template.getValueStore());
                    }
                    ++i;
                }
            }

            public Image getDefaultPageImage() {
                return WizardNode.this.parentPage.getImage();
            }
        };
        return this.wizard;
    }

    public boolean isContentCreated() {
        return this.wizard != null;
    }
}

