/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.ui.controls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.ui.CDTUIImages;
import org.eclipse.cdt.ui.newui.CDTStatusInfo;
import org.eclipse.cdt.ui.newui.TypedCDTViewerFilter;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.ui.controls.FileListControl;
import org.eclipse.cdt.utils.ui.controls.IFileListChangeListener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class FileListControl {
    private static final int BROWSE_NONE = 0;
    private static final int BROWSE_FILE = 1;
    private static final int BROWSE_DIR = 2;
    private static final String WORKSPACELOC_VAR = "workspace_loc";
    private static final String WORKSPACEBUTTON_NAME = UIMessages.getString("FileListControl.button.workspace");
    private static final String FILESYSTEMBUTTON_NAME = UIMessages.getString("FileListControl.button.fs");
    private static final String ADD_STR = UIMessages.getString("FileListControl.add");
    private static final String DEL_STR = UIMessages.getString("FileListControl.delete");
    private static final String EDIT_STR = UIMessages.getString("FileListControl.edit");
    private static final String MOVEUP_STR = UIMessages.getString("FileListControl.moveup");
    private static final String MOVEDOWN_STR = UIMessages.getString("FileListControl.movedown");
    private static final String FILE_TITLE_ADD = UIMessages.getString("BrowseEntryDialog.file.title.add");
    private static final String DIR_TITLE_ADD = UIMessages.getString("BrowseEntryDialog.dir.title.add");
    private static final String FILE_TITLE_EDIT = UIMessages.getString("BrowseEntryDialog.file.title.edit");
    private static final String DIR_TITLE_EDIT = UIMessages.getString("BrowseEntryDialog.dir.title.edit");
    private static final String WORKSPACE_DIR_DIALOG_TITLE = UIMessages.getString("BrowseEntryDialog.wsp.dir.dlg.title");
    private static final String WORKSPACE_FILE_DIALOG_TITLE = UIMessages.getString("BrowseEntryDialog.wsp.file.dlg.title");
    private static final String WORKSPACE_DIR_DIALOG_MSG = UIMessages.getString("BrowseEntryDialog.wsp.dir.dlg.msg");
    private static final String WORKSPACE_FILE_DIALOG_MSG = UIMessages.getString("BrowseEntryDialog.wsp.file.dlg.msg");
    private static final String WORKSPACE_FILE_DIALOG_ERR = UIMessages.getString("BrowseEntryDialog.wsp.file.dlg.err");
    private static final String FILESYSTEM_DIR_DIALOG_MSG = UIMessages.getString("BrowseEntryDialog.fs.dir.dlg.msg");
    private static final String FILE_MSG = UIMessages.getString("BrowseEntryDialog.message.file");
    private static final String DIR_MSG = UIMessages.getString("BrowseEntryDialog.message.directory");
    private static final String TITLE = UIMessages.getString("BuildPropertyCommon.label.title");
    private ToolBar toolBar;
    private ToolItem addItem;
    private ToolItem deleteItem;
    private ToolItem editItem;
    private ToolItem moveUpItem;
    private ToolItem moveDownItem;
    private Label title;
    private org.eclipse.swt.widgets.List list;
    private String compTitle;
    private SelectionListener selectionListener;
    private GridData tgdata;
    private GridData grid3;
    private GridData grid4;
    private GridData grid2;
    private int browseType;
    private IPath path;
    private boolean fWorkspaceSupport = false;
    private IVariableContextInfo contextInfo;
    private IResource rc;
    private List listeners = new ArrayList();
    private String[] oldValue;
    private final Image IMG_ADD = CDTUIImages.get("org.eclipse.cdt.ui.list-add.gif");
    private final Image IMG_DEL = CDTUIImages.get("org.eclipse.cdt.ui.list-delete.gif");
    private final Image IMG_EDIT = CDTUIImages.get("org.eclipse.cdt.ui.list-edit.gif");
    private final Image IMG_MOVEUP = CDTUIImages.get("org.eclipse.cdt.ui.list-moveup.gif");
    private final Image IMG_MOVEDOWN = CDTUIImages.get("org.eclipse.cdt.ui.list-movedown.gif");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public FileListControl(Composite parent, String compTitle, int type) {
        this.browseType = type;
        Composite filePanel = new Composite(parent, 0);
        GridLayout form1 = new GridLayout();
        form1.numColumns = 1;
        form1.horizontalSpacing = 0;
        form1.verticalSpacing = 0;
        form1.marginHeight = 0;
        form1.marginWidth = 0;
        filePanel.setLayout((Layout)form1);
        filePanel.setLayoutData((Object)new GridData(1808));
        Composite titlePanel = new Composite(filePanel, 2048);
        GridLayout titleform = new GridLayout(2, false);
        titleform.horizontalSpacing = 0;
        titleform.verticalSpacing = 0;
        titleform.marginHeight = 0;
        titleform.marginWidth = 0;
        titlePanel.setLayout((Layout)titleform);
        this.tgdata = new GridData(768);
        this.tgdata.heightHint = 25;
        titlePanel.setLayoutData((Object)this.tgdata);
        this.title = new Label(titlePanel, 1);
        this.compTitle = "  " + compTitle;
        this.title.setText(this.compTitle);
        this.grid2 = new GridData(768);
        this.title.setLayoutData((Object)this.grid2);
        Composite buttonPanel = new Composite(titlePanel, 0);
        GridLayout form2 = new GridLayout();
        form2.numColumns = 5;
        form2.horizontalSpacing = 0;
        form2.verticalSpacing = 0;
        form2.marginWidth = 0;
        form2.marginHeight = 0;
        buttonPanel.setLayout((Layout)form2);
        this.toolBar = new ToolBar(buttonPanel, 8519936);
        this.addItem = new ToolItem(this.toolBar, 8);
        this.addItem.setImage(this.IMG_ADD);
        this.addItem.setToolTipText(ADD_STR);
        this.addItem.addSelectionListener(this.getSelectionListener());
        this.deleteItem = new ToolItem(this.toolBar, 8);
        this.deleteItem.setImage(this.IMG_DEL);
        this.deleteItem.setToolTipText(DEL_STR);
        this.deleteItem.addSelectionListener(this.getSelectionListener());
        this.editItem = new ToolItem(this.toolBar, 8);
        this.editItem.setImage(this.IMG_EDIT);
        this.editItem.setToolTipText(EDIT_STR);
        this.editItem.addSelectionListener(this.getSelectionListener());
        this.moveUpItem = new ToolItem(this.toolBar, 8);
        this.moveUpItem.setImage(this.IMG_MOVEUP);
        this.moveUpItem.setToolTipText(MOVEUP_STR);
        this.moveUpItem.addSelectionListener(this.getSelectionListener());
        this.moveDownItem = new ToolItem(this.toolBar, 8);
        this.moveDownItem.setImage(this.IMG_MOVEDOWN);
        this.moveDownItem.setToolTipText(MOVEDOWN_STR);
        this.moveDownItem.addSelectionListener(this.getSelectionListener());
        this.grid3 = new GridData(896);
        buttonPanel.setLayoutData((Object)this.grid3);
        this.list = new org.eclipse.swt.widgets.List(filePanel, 2816);
        this.grid4 = new GridData(1808);
        Point preferredSize = titlePanel.computeSize(-1, -1);
        this.grid4.widthHint = preferredSize.x;
        this.grid4.heightHint = preferredSize.y * 3;
        this.grid4.horizontalSpan = 2;
        this.list.setLayoutData((Object)this.grid4);
        this.list.addSelectionListener(this.getSelectionListener());
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                FileListControl.this.editSelection();
            }
        });
        this.list.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    FileListControl.this.removePressed();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        this.selectionChanged();
    }

    public void setList(String[] listVal) {
        if (this.list != null) {
            this.list.removeAll();
        }
        int i = 0;
        while (i < listVal.length) {
            this.list.add(listVal[i]);
            ++i;
        }
        this.checkNotificationNeeded();
    }

    public void addChangeListener(IFileListChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(IFileListChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void checkNotificationNeeded() {
        String[] items = this.getItems();
        if (this.oldValue != null) {
            if (this.oldValue.length == items.length) {
                int i = 0;
                while (i < this.oldValue.length) {
                    if (!this.oldValue[i].equals(items[i])) break;
                    ++i;
                }
                if (i == this.oldValue.length) {
                    return;
                }
            }
            String[] old = this.oldValue;
            this.oldValue = new String[items.length];
            System.arraycopy(items, 0, this.oldValue, 0, items.length);
            this.notifyListeners(old, this.oldValue);
        } else {
            this.oldValue = new String[items.length];
            System.arraycopy(items, 0, this.oldValue, 0, items.length);
        }
    }

    public void notifyListeners(String[] oldVal, String[] newVal) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((IFileListChangeListener)iter.next()).fileListChanged(this, oldVal, newVal);
        }
    }

    public void setSelection(int sel) {
        if (this.list.getItemCount() > 0) {
            this.list.setSelection(sel);
        }
        this.selectionChanged();
    }

    public void setSelection() {
        if (this.list.getItemCount() > 0) {
            this.list.setSelection(0);
        }
    }

    public void removeAll() {
        if (this.list != null) {
            this.list.removeAll();
            this.checkNotificationNeeded();
        }
    }

    public String[] getItems() {
        return this.list.getItems();
    }

    private void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == FileListControl.this.addItem) {
                    FileListControl.this.addPressed();
                } else if (widget == FileListControl.this.deleteItem) {
                    FileListControl.this.removePressed();
                } else if (widget == FileListControl.this.moveUpItem) {
                    FileListControl.this.upPressed();
                } else if (widget == FileListControl.this.moveDownItem) {
                    FileListControl.this.downPressed();
                } else if (widget == FileListControl.this.list) {
                    FileListControl.this.selectionChanged();
                } else if (widget == FileListControl.this.editItem) {
                    FileListControl.this.editSelection();
                }
            }
        };
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    private void addPressed() {
        String input = this.getNewInputObject();
        if (input != null && input.length() > 0) {
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.add(input, index + 1);
                this.list.setSelection(index + 1);
            } else {
                this.list.add(input, 0);
                this.list.setSelection(0);
            }
            this.checkNotificationNeeded();
        }
        this.selectionChanged();
    }

    private void removePressed() {
        int index = this.list.getSelectionIndex();
        if (this.browseType == 2 || this.browseType == 1) {
            String quest = UIMessages.getString("FileListControl.deletedialog.message");
            String title = UIMessages.getString("FileListControl.deletedialog.title");
            boolean delDir = MessageDialog.openQuestion((Shell)this.list.getShell(), (String)title, (String)quest);
            if (delDir && index != -1) {
                this.list.remove(index);
                this.checkNotificationNeeded();
            }
        } else if (index != -1) {
            this.list.remove(index);
            this.checkNotificationNeeded();
        }
        this.selectionChanged();
    }

    private void upPressed() {
        int index = this.list.getSelectionIndex();
        String curSelList = this.list.getItem(index);
        String preList = this.list.getItem(index - 1);
        this.list.setItem(index - 1, curSelList);
        this.list.setItem(index, preList);
        this.list.setSelection(index - 1);
        this.checkNotificationNeeded();
        this.selectionChanged();
    }

    private void downPressed() {
        int index = this.list.getSelectionIndex();
        String curSelList = this.list.getItem(index);
        String nextList = this.list.getItem(index + 1);
        this.list.setItem(index + 1, curSelList);
        this.list.setItem(index, nextList);
        this.list.setSelection(index + 1);
        this.checkNotificationNeeded();
        this.selectionChanged();
    }

    private void editSelection() {
        String selItem;
        int index = this.list.getSelectionIndex();
        if (index != -1 && (selItem = this.list.getItem(index)) != null) {
            InputDialog dialog;
            String title;
            if (this.browseType == 2 || this.browseType == 1) {
                String message;
                if (this.browseType == 2) {
                    title = DIR_TITLE_EDIT;
                    message = DIR_MSG;
                } else {
                    title = FILE_TITLE_EDIT;
                    message = FILE_MSG;
                }
                dialog = new SelectPathInputDialog(this.getListControl().getShell(), title, message, selItem, null, this.browseType);
            } else {
                title = UIMessages.getString("FileListControl.editdialog.title");
                dialog = new InputDialog(null, title, this.compTitle, selItem, null);
            }
            String newItem = null;
            if (dialog.open() == 0) {
                newItem = dialog.getValue();
                if (dialog instanceof SelectPathInputDialog && ((SelectPathInputDialog)dialog).isValueSetByBrowse()) {
                    newItem = this.doubleQuotePath(newItem);
                }
                if (newItem != null && !newItem.equals(selItem)) {
                    this.list.setItem(index, newItem);
                    this.checkNotificationNeeded();
                    this.selectionChanged();
                }
            }
        }
    }

    public void selectionChanged() {
        int index = this.list.getSelectionIndex();
        int size = this.list.getItemCount();
        this.deleteItem.setEnabled(size > 0);
        this.moveUpItem.setEnabled(size > 1 && index > 0);
        this.moveDownItem.setEnabled(size > 1 && index >= 0 && index < size - 1);
        this.editItem.setEnabled(size > 0);
    }

    public org.eclipse.swt.widgets.List getListControl() {
        return this.list;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public void setType(int type) {
        this.browseType = type;
    }

    public void setWorkspaceSupport(boolean enable) {
        this.fWorkspaceSupport = enable;
    }

    public void setContext(IVariableContextInfo info) {
        this.contextInfo = info;
        while (info != null) {
            info = info.getNext();
        }
    }

    private String getNewInputObject() {
        String input = null;
        String title = new String();
        String message = new String();
        String initVal = new String();
        if (this.browseType == 2) {
            title = DIR_TITLE_ADD;
            message = DIR_MSG;
            initVal = this.path == null ? initVal : this.path.toString();
        } else if (this.browseType == 1) {
            title = FILE_TITLE_ADD;
            message = FILE_MSG;
            initVal = this.path == null ? initVal : this.path.toString();
        } else {
            title = TITLE;
            message = this.compTitle;
        }
        SelectPathInputDialog dialog = new SelectPathInputDialog(this.getListControl().getShell(), title, message, initVal, null, this.browseType);
        if (dialog.open() == 0) {
            input = dialog.getValue();
        }
        if (input != null && input.length() > 0 && (this.browseType == 2 || this.browseType == 1)) {
            input = this.doubleQuotePath(input);
        }
        return input;
    }

    public Label getLabelControl() {
        return this.title;
    }

    public void setEnabled(boolean enabled) {
        this.title.setEnabled(enabled);
        this.toolBar.setEnabled(enabled);
        this.list.setEnabled(enabled);
    }

    private String doubleQuotePath(String pathName) {
        pathName = pathName.trim();
        boolean bStartsWithQuote = pathName.startsWith("\"");
        boolean bEndsWithQuote = pathName.endsWith("\"");
        int i = pathName.indexOf(" ") + pathName.indexOf("\\") + pathName.indexOf("${");
        if (i != -3) {
            if (!bStartsWithQuote) {
                pathName = "\"" + pathName;
            }
            if (!bEndsWithQuote) {
                pathName = String.valueOf(pathName) + "\"";
            }
        }
        return pathName;
    }

    static /* synthetic */ IVariableContextInfo access$2(FileListControl fileListControl) {
        return fileListControl.contextInfo;
    }

    static /* synthetic */ IResource access$3(FileListControl fileListControl) {
        return fileListControl.rc;
    }

    static /* synthetic */ String access$4() {
        return WORKSPACE_DIR_DIALOG_TITLE;
    }

    static /* synthetic */ String access$5() {
        return WORKSPACE_DIR_DIALOG_MSG;
    }

    static /* synthetic */ String access$6() {
        return WORKSPACE_FILE_DIALOG_ERR;
    }

    static /* synthetic */ String access$7() {
        return WORKSPACE_FILE_DIALOG_TITLE;
    }

    static /* synthetic */ String access$8() {
        return WORKSPACE_FILE_DIALOG_MSG;
    }

    static /* synthetic */ String access$10() {
        return FILESYSTEM_DIR_DIALOG_MSG;
    }

    class SelectPathInputDialog
    extends InputDialog {
        private int type;
        private boolean fSetByBrowseDialog;

        public SelectPathInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator, int browseType) {
            super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
            this.fSetByBrowseDialog = false;
            this.type = browseType;
        }

        public boolean isValueSetByBrowse() {
            return this.fSetByBrowseDialog;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            if ((this.type == 2 || this.type == 1) && FileListControl.this.fWorkspaceSupport) {
                Button workspaceButton = this.createButton(parent, 3, WORKSPACEBUTTON_NAME, false);
                workspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ SelectPathInputDialog this$1;
                    {
                        this.this$1 = selectPathInputDialog;
                    }

                    public void widgetSelected(SelectionEvent ev) {
                        IResource resource;
                        String currentPathText = SelectPathInputDialog.access$0(this.this$1).getText();
                        currentPathText = currentPathText.replaceAll("\"", "");
                        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
                        Path path = new Path(currentPathText);
                        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.this$1.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                        if (SelectPathInputDialog.access$1(this.this$1) == 2) {
                            IContainer[] cs;
                            IResource container = null;
                            if (path.isAbsolute() && (cs = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation((IPath)path)) != null && cs.length > 0) {
                                container = cs[0];
                            }
                            if (container == null && FileListControl.access$3(SelectPathInputDialog.access$4(this.this$1)) instanceof IContainer) {
                                container = FileListControl.access$3(SelectPathInputDialog.access$4(this.this$1));
                            }
                            dialog.setInitialSelection(container);
                            Class[] classArray = new Class[2];
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IContainer");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            classArray[0] = clazz;
                            Class<?> clazz2 = class$1;
                            if (clazz2 == null) {
                                try {
                                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IProject");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            classArray[1] = clazz2;
                            Class[] filteredResources = classArray;
                            dialog.addFilter((ViewerFilter)new TypedCDTViewerFilter(filteredResources));
                            dialog.setTitle(FileListControl.access$4());
                            dialog.setMessage(FileListControl.access$5());
                        } else {
                            IFile[] fs;
                            resource = null;
                            if (path.isAbsolute() && (fs = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path)) != null && fs.length > 0) {
                                resource = fs[0];
                            }
                            if (resource == null) {
                                resource = FileListControl.access$3(SelectPathInputDialog.access$4(this.this$1));
                            }
                            dialog.setInitialSelection(resource);
                            dialog.setValidator(new ISelectionStatusValidator(this){
                                final /* synthetic */ 1 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                public IStatus validate(Object[] selection) {
                                    if (selection != null && selection.length > 0 && !(selection[0] instanceof IFile)) {
                                        return new CDTStatusInfo(4, FileListControl.access$6());
                                    }
                                    return new CDTStatusInfo();
                                }
                            });
                            dialog.setTitle(FileListControl.access$7());
                            dialog.setMessage(FileListControl.access$8());
                        }
                        if (dialog.open() == 0) {
                            SelectPathInputDialog.access$2(this.this$1, true);
                            resource = (IResource)dialog.getFirstResult();
                            if (resource != null) {
                                SelectPathInputDialog.access$0(this.this$1).setText(variableManager.generateVariableExpression("workspace_loc", resource.getFullPath().toString()));
                            }
                        }
                    }
                });
            }
            if (this.type != 0) {
                Button externalButton = this.createButton(parent, 4, FILESYSTEMBUTTON_NAME, false);
                externalButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ SelectPathInputDialog this$1;
                    {
                        this.this$1 = selectPathInputDialog;
                    }

                    public void widgetSelected(SelectionEvent ev) {
                        switch (SelectPathInputDialog.access$1(this.this$1)) {
                            case 2: {
                                DirectoryDialog dialog = new DirectoryDialog(SelectPathInputDialog.access$3(this.this$1), 69632);
                                String currentName = SelectPathInputDialog.access$0(this.this$1).getText();
                                if (currentName != null && currentName.trim().length() != 0) {
                                    dialog.setFilterPath(currentName);
                                }
                                dialog.setMessage(FileListControl.access$10());
                                String result = dialog.open();
                                if (result == null) break;
                                SelectPathInputDialog.access$2(this.this$1, true);
                                SelectPathInputDialog.access$0(this.this$1).setText(result);
                                break;
                            }
                            case 1: {
                                String result;
                                FileDialog browseDialog = new FileDialog(SelectPathInputDialog.access$3(this.this$1));
                                String currentName = SelectPathInputDialog.access$0(this.this$1).getText();
                                if (currentName != null && currentName.trim().length() != 0) {
                                    browseDialog.setFilterPath(currentName);
                                }
                                if ((result = browseDialog.open()) == null) break;
                                SelectPathInputDialog.access$2(this.this$1, true);
                                SelectPathInputDialog.access$0(this.this$1).setText(result);
                            }
                        }
                    }
                });
            }
        }

        static /* synthetic */ Text access$0(SelectPathInputDialog selectPathInputDialog) {
            return selectPathInputDialog.getText();
        }

        static /* synthetic */ int access$1(SelectPathInputDialog selectPathInputDialog) {
            return selectPathInputDialog.type;
        }

        static /* synthetic */ void access$2(SelectPathInputDialog selectPathInputDialog, boolean bl) {
            selectPathInputDialog.fSetByBrowseDialog = bl;
        }

        static /* synthetic */ Shell access$3(SelectPathInputDialog selectPathInputDialog) {
            return selectPathInputDialog.getParentShell();
        }

        static /* synthetic */ FileListControl access$4(SelectPathInputDialog selectPathInputDialog) {
            return selectPathInputDialog.FileListControl.this;
        }
    }
}

