/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedOptionValueHandler;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.core.ManagedOptionValueHandler;
import org.eclipse.cdt.managedbuilder.core.tests.TestValueHandler;
import org.eclipse.cdt.managedbuilder.testplugin.CTestPlugin;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class ManagedBuildCoreTests_SharedToolOptions
extends TestCase {
    private final String projectName = "test30_sto";
    private final String projectID = "test30_sto.dummy";
    private final String configID = "test30_sto.dummy.config";
    private final String configName = "Configuration for test30_sto";
    private boolean testExtensionElements = true;
    private boolean testIsSetup = false;
    private IProjectType testProject;
    private IConfiguration testConfig;
    private IToolChain testToolChain;
    private ITool[] testTools;
    private IOptionCategory[] testCategoryTop;
    private IOption[] testOptionTop;
    private Object[][] testCategory;
    private Object[][] testOption;
    private IconComparator iconComparator = new IconComparator();
    private ValueHandlerComparator valueHandlerComparator = new ValueHandlerComparator();
    static /* synthetic */ Class class$0;

    public ManagedBuildCoreTests_SharedToolOptions(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.ManagedBuildCoreTests_SharedToolOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        suite.addTest((Test)new ManagedBuildCoreTests_SharedToolOptions("testIcons"));
        suite.addTest((Test)new ManagedBuildCoreTests_SharedToolOptions("testValueHandlers"));
        suite.addTest((Test)new ManagedBuildCoreTests_SharedToolOptions("testOptions"));
        suite.addTest((Test)new ManagedBuildCoreTests_SharedToolOptions("testConfiguration"));
        return suite;
    }

    private void assertCorrectId(String s1, String s2) {
        if (this.testExtensionElements) {
            ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)s1.equals(s2));
        } else {
            ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)s1.startsWith(String.valueOf(s2) + "."));
        }
    }

    private IProject createProject(String name) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        final IProject newProjectHandle = root.getProject(name);
        IProject project = null;
        if (!newProjectHandle.exists()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription workspaceDesc = workspace.getDescription();
            workspaceDesc.setAutoBuilding(false);
            workspace.setDescription(workspaceDesc);
            IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
            project = CCorePlugin.getDefault().createCProject(description, newProjectHandle, (IProgressMonitor)new NullProgressMonitor(), ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID);
        } else {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    newProjectHandle.refreshLocal(2, monitor);
                }
            };
            NullProgressMonitor monitor = new NullProgressMonitor();
            workspace.run(runnable, (ISchedulingRule)root, 1, (IProgressMonitor)monitor);
            project = newProjectHandle;
        }
        if (!project.isOpen()) {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        return project;
    }

    private void setupDefaultProject() throws Exception {
        this.testExtensionElements = true;
        this.testProject = ManagedBuildManager.getProjectType((String)"test30_sto.dummy");
        ManagedBuildCoreTests_SharedToolOptions.assertNotNull((Object)this.testProject);
        ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)this.testProject.isTestProjectType());
        ManagedBuildCoreTests_SharedToolOptions.assertFalse((boolean)this.testProject.isAbstract());
        this.setupConfiguration();
        ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)this.testConfig.isExtensionElement());
    }

    private void setupConfiguration() throws Exception {
        IConfiguration[] configs = this.testProject.getConfigurations();
        ManagedBuildCoreTests_SharedToolOptions.assertNotNull((Object)configs);
        ManagedBuildCoreTests_SharedToolOptions.assertEquals((int)configs.length, (int)1);
        this.testConfig = configs[0];
        ManagedBuildCoreTests_SharedToolOptions.assertEquals((String)this.testConfig.getId(), (String)"test30_sto.dummy.config");
        ManagedBuildCoreTests_SharedToolOptions.assertEquals((String)this.testConfig.getName(), (String)"Configuration for test30_sto");
    }

    private void setupProject() throws Exception {
        this.testExtensionElements = false;
        IProject project = null;
        try {
            project = this.createProject("test30_sto");
            ManagedBuildTestHelper.addManagedBuildNature(project);
            IProjectDescription description = project.getDescription();
            if (description != null) {
                ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)description.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException e) {
            ManagedBuildCoreTests_SharedToolOptions.fail((String)("Test failed on project creation: " + e.getLocalizedMessage()));
        }
        ManagedBuildManager.getDefinedProjectTypes();
        IProjectType projType = ManagedBuildManager.getProjectType((String)"test30_sto.dummy");
        ManagedBuildCoreTests_SharedToolOptions.assertNotNull((Object)projType);
        IManagedProject newProject = ManagedBuildManager.createManagedProject((IResource)project, (IProjectType)projType);
        ManagedBuildCoreTests_SharedToolOptions.assertEquals((String)newProject.getName(), (String)projType.getName());
        ManagedBuildCoreTests_SharedToolOptions.assertFalse((boolean)newProject.equals(projType));
        ManagedBuildManager.setNewProjectVersion((IProject)project);
        this.testProject = newProject.getProjectType();
        IConfiguration config = this.testProject.getConfiguration("test30_sto.dummy.config");
        this.testConfig = newProject.createConfiguration(config, "test30_sto.dummy.config.12345678");
    }

    private void setupTestEnvironment() throws Exception {
        String toolChainID = "test30_sto.dummy.toolchain";
        String toolChainName = "Toolchain for test30_sto";
        int numTools = 4;
        String toolIDs = "test30_sto.dummy.tool.";
        int firstToolID = 1;
        String topCategoryIDs = "test30_sto.dummy.category.";
        int firstTopCategoryID = 5;
        int sizeCategoryTop = 0;
        int sizeOptionTop = 0;
        int sizeTools = 0;
        this.testToolChain = this.testConfig.getToolChain();
        ManagedBuildCoreTests_SharedToolOptions.assertNotNull((Object)this.testToolChain);
        ManagedBuildCoreTests_SharedToolOptions.assertEquals((String)this.testToolChain.getName(), (String)toolChainName);
        this.assertCorrectId(this.testToolChain.getId(), toolChainID);
        this.testTools = this.testToolChain.getTools();
        ManagedBuildCoreTests_SharedToolOptions.assertNotNull((Object)this.testTools);
        ManagedBuildCoreTests_SharedToolOptions.assertEquals((int)this.testTools.length, (int)numTools);
        int toolNo = firstToolID;
        sizeTools = numTools;
        int i = 0;
        while (i < sizeTools) {
            this.assertCorrectId(this.testTools[i].getId(), String.valueOf(toolIDs) + toolNo);
            ++toolNo;
            ++i;
        }
        this.testCategoryTop = this.testToolChain.getChildCategories();
        this.testOptionTop = this.testToolChain.getOptions();
        if (this.testCategoryTop != null) {
            int categoryNo = firstTopCategoryID;
            sizeCategoryTop = this.testCategoryTop.length;
            i = 0;
            while (i < sizeCategoryTop) {
                String ID = this.testCategoryTop[i].getId();
                ManagedBuildCoreTests_SharedToolOptions.assertEquals((String)ID, (String)(String.valueOf(topCategoryIDs) + categoryNo));
                ++i;
                ++categoryNo;
            }
        }
        if (this.testOptionTop != null) {
            sizeOptionTop = this.testOptionTop.length;
        }
        this.testCategory = new Object[this.testTools.length + sizeCategoryTop][];
        this.testOption = new Object[this.testTools.length + sizeOptionTop][];
        i = 0;
        while (i < sizeTools) {
            this.testCategory[i] = this.testTools[i].getChildCategories();
            this.testOption[i] = this.testTools[i].getOptions();
            if (this.testCategory[i] == null) {
                this.testCategory[i] = new Object[0];
            }
            if (this.testOption[i] == null) {
                this.testOption[i] = new Object[0];
            }
            ++i;
        }
        i = 0;
        while (i < sizeCategoryTop) {
            this.testCategory[sizeTools + i] = new Object[1];
            this.testCategory[sizeTools + i][0] = this.testCategoryTop[i];
            ++i;
        }
        i = 0;
        while (i < sizeOptionTop) {
            this.testOption[sizeTools + i] = new Object[1];
            this.testOption[sizeTools + i][0] = this.testOptionTop[i];
            ++i;
        }
    }

    public void testIcons() throws Exception {
        if (!this.testIsSetup) {
            this.setupDefaultProject();
            this.setupTestEnvironment();
        }
        CTestPlugin me = CTestPlugin.getDefault();
        URL icon1 = Platform.asLocalURL((URL)me.find((IPath)new Path("icons/one.gif"), null));
        URL icon2 = Platform.asLocalURL((URL)me.find((IPath)new Path("icons/two.gif"), null));
        this.assertToolIcon(this.testTools[0], icon1);
        this.assertToolIcon(this.testTools[1], null);
        this.assertToolIcon(this.testTools[2], icon2);
        int i = 0;
        while (i < this.testCategory.length) {
            int j = 0;
            while (j < this.testCategory[i].length) {
                URL url = ((IOptionCategory)this.testCategory[i][j]).getIconPath();
                switch (this.iconComparator.Compare(i + 1, j + 1)) {
                    case 0: {
                        ManagedBuildCoreTests_SharedToolOptions.assertEquals((Object)url, null);
                        break;
                    }
                    case 1: {
                        ManagedBuildCoreTests_SharedToolOptions.assertEquals((Object)url, (Object)icon1);
                        break;
                    }
                    case 2: {
                        ManagedBuildCoreTests_SharedToolOptions.assertEquals((Object)url, (Object)icon2);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void assertToolIcon(ITool tool, URL url) {
        ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)(tool instanceof IOptionCategory));
        IOptionCategory toolCategory = (IOptionCategory)tool;
        ManagedBuildCoreTests_SharedToolOptions.assertEquals((Object)toolCategory.getIconPath(), (Object)url);
    }

    public void testValueHandlers() throws Exception {
        if (!this.testIsSetup) {
            this.setupDefaultProject();
            this.setupTestEnvironment();
        }
        int i = 0;
        while (i < this.testOption.length) {
            int j = 0;
            while (j < this.testOption[i].length) {
                IOption option = (IOption)this.testOption[i][j];
                IManagedOptionValueHandler handler = option.getValueHandler();
                String handlerExtraArg = option.getValueHandlerExtraArgument();
                switch (this.valueHandlerComparator.Compare(i + 1, j + 1)) {
                    case 0: {
                        ManagedBuildCoreTests_SharedToolOptions.assertEquals((Object)ManagedOptionValueHandler.getManagedOptionValueHandler(), (Object)handler);
                        break;
                    }
                    case 1: {
                        ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)(handler instanceof TestValueHandler));
                        ManagedBuildCoreTests_SharedToolOptions.assertEquals((String)this.valueHandlerComparator.getArg(), (String)handlerExtraArg);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void testOptions() throws Exception {
        if (!this.testIsSetup) {
            this.setupDefaultProject();
            this.setupTestEnvironment();
        }
        int i = 0;
        while (i < this.testCategory.length) {
            int j = 0;
            while (j < this.testCategory[i].length) {
                Object[][] results = ((IOptionCategory)this.testCategory[i][j]).getOptions(this.testConfig);
                int k = 0;
                while (k < results[0].length) {
                    if (results[k][0] == null) {
                        ManagedBuildCoreTests_SharedToolOptions.assertNull((Object)results[k][1]);
                        break;
                    }
                    switch (i) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)(results[k][0] instanceof ITool));
                            ManagedBuildCoreTests_SharedToolOptions.assertEquals((Object)results[k][0], (Object)this.testTools[i]);
                            break;
                        }
                        default: {
                            ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)(results[k][0] instanceof IToolChain));
                            ManagedBuildCoreTests_SharedToolOptions.assertEquals((Object)results[k][0], (Object)this.testToolChain);
                        }
                    }
                    boolean found = false;
                    int l = 0;
                    while (l < this.testOption[i].length) {
                        if (this.testOption[i][l] == results[k][1]) {
                            found = true;
                            break;
                        }
                        ++l;
                    }
                    ManagedBuildCoreTests_SharedToolOptions.assertTrue((boolean)found);
                    ManagedBuildCoreTests_SharedToolOptions.assertEquals((Object)((IOption)results[k][1]).getCategory(), (Object)this.testCategory[i][j]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void testConfiguration() throws Exception {
        this.setupProject();
        this.setupTestEnvironment();
        this.testIsSetup = true;
        this.testIcons();
        this.testValueHandlers();
        this.testOptions();
    }

    class IconComparator {
        static final int None = 0;
        static final int One = 1;
        static final int Two = 2;
        int[] One_i = new int[]{3, 2, 4, 7};
        int[] One_j = new int[]{1, 2, 1, 1};
        int[] Two_i = new int[]{2, 6};
        int[] Two_j = new int[]{1, 1};

        IconComparator() {
            ManagedBuildCoreTests_SharedToolOptions.assertEquals((int)this.One_i.length, (int)this.One_j.length);
            ManagedBuildCoreTests_SharedToolOptions.assertEquals((int)this.Two_i.length, (int)this.Two_j.length);
        }

        int Compare(int i, int j) {
            int k = 0;
            while (k < this.One_i.length) {
                if (i == this.One_i[k] && j == this.One_j[k]) {
                    return 1;
                }
                ++k;
            }
            k = 0;
            while (k < this.Two_i.length) {
                if (i == this.Two_i[k] && j == this.Two_j[k]) {
                    return 2;
                }
                ++k;
            }
            return 0;
        }
    }

    class ValueHandlerComparator {
        static final int MBS = 0;
        static final int TEST = 1;
        int[] Test_i = new int[]{2, 2, 3, 5, 7};
        int[] Test_j = new int[]{1, 4, 2, 1, 1};
        String[] Test_arg = new String[]{"Option2.1.1", "Option2.2.2", "Option3.1.2", "Option5.1", "Option7.1"};
        String last_arg;

        ValueHandlerComparator() {
            ManagedBuildCoreTests_SharedToolOptions.assertEquals((int)this.Test_i.length, (int)this.Test_j.length);
            ManagedBuildCoreTests_SharedToolOptions.assertEquals((int)this.Test_i.length, (int)this.Test_arg.length);
            this.last_arg = "";
        }

        int Compare(int i, int j) {
            int k = 0;
            while (k < this.Test_i.length) {
                if (i == this.Test_i[k] && j == this.Test_j[k]) {
                    this.last_arg = this.Test_arg[k];
                    return 1;
                }
                ++k;
            }
            this.last_arg = "";
            return 0;
        }

        String getArg() {
            return this.last_arg;
        }
    }
}

