/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.templateengine.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.templateengine.tests.TemplateEngineTestsHelper;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;

public class TestProcesses
extends TestCase {
    private static final String workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toOSString();
    private static final String PROJECT_NAME = "TemplateEngineTestsProject";
    private static final String SOURCE_FOLDER = "Source";
    private static final String INCLUDE_FOLDER = "Include";
    private static final String FILE_NAME = "File";
    private static final String LINK = "Link";
    private static final String APPEND = "Append";
    private static final String CPP_EXT = ".cpp";
    private static final String H_EXT = ".h";
    private static final String MBS_GNU_CPP_LINK_OPTION_ID = ".*gnu.cpp.link.option.*";
    private static final String MBS_STRING_OPTION_VALUE = "MBSStringOption";
    private static final String[] MBS_STRING_LIST_OPTION_VALUES = new String[]{"MBS", "String", "List", "Option"};
    private static final String RELEASE_CONFIG_ID = ".*release.*";
    private static final String PROJECT_TYPE = "org.eclipse.cdt.managedbuilder.core.tests.projectType";
    private List configList;

    protected void setUp() throws Exception {
        TemplateEngineTestsHelper.turnOffAutoBuild();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        if (project.exists()) {
            project.delete(true, true, null);
        }
        this.configList = new ArrayList();
        this.configList.add(new IConfiguration[0]);
    }

    public void testCreateIncludeFolder() {
        TemplateCore template = TemplateEngine.getDefault().getFirstTemplate(PROJECT_TYPE, null, ".*CreateIncludeFolder");
        Map valueStore = template.getValueStore();
        valueStore.put("projectName", PROJECT_NAME);
        valueStore.put("projectType", PROJECT_TYPE);
        valueStore.put("location", "");
        valueStore.put("isCProject", "false");
        valueStore.put("includeDir1", "Include1");
        valueStore.put("includeDir2", "Include2");
        valueStore.put("Configurations", this.configList);
        if (TemplateEngineTestsHelper.failIfErrorStatus(template.executeTemplateProcesses(null, false))) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        TestProcesses.assertTrue((boolean)project.exists());
        IFolder folder = project.getFolder("Include1");
        TestProcesses.assertTrue((boolean)folder.exists());
        folder = project.getFolder("Include2");
        TestProcesses.assertTrue((boolean)folder.exists());
    }

    public void testNewManagedProject() {
        TemplateCore template = TemplateEngine.getDefault().getFirstTemplate(PROJECT_TYPE, null, ".*NewManagedProject");
        Map valueStore = template.getValueStore();
        valueStore.put("projectName", PROJECT_NAME);
        valueStore.put("projectType", PROJECT_TYPE);
        valueStore.put("location", "");
        valueStore.put("Configurations", this.configList);
        if (TemplateEngineTestsHelper.failIfErrorStatus(template.executeTemplateProcesses(null, false))) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        TestProcesses.assertTrue((boolean)project.exists());
    }

    public void testSetMBSBooleanOptionValue() {
        TemplateCore template = TemplateEngine.getDefault().getFirstTemplate(PROJECT_TYPE, null, ".*SetMBSBooleanOptionValue");
        Map valueStore = template.getValueStore();
        valueStore.put("projectName", PROJECT_NAME);
        valueStore.put("projectType", PROJECT_TYPE);
        valueStore.put("location", "");
        valueStore.put("isCProject", "false");
        valueStore.put("id", MBS_GNU_CPP_LINK_OPTION_ID);
        if (TemplateEngineTestsHelper.failIfErrorStatus(template.executeTemplateProcesses(null, false))) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        TestProcesses.assertTrue((boolean)project.exists());
        try {
            this.assertSetMBSOptionValues(project, MBS_GNU_CPP_LINK_OPTION_ID, 0, false);
        }
        catch (BuildException e) {
            TestProcesses.fail((String)e.getMessage());
        }
    }

    public void testSetMBSStringOptionValue() {
        TemplateCore template = TemplateEngine.getDefault().getFirstTemplate(PROJECT_TYPE, null, ".*SetMBSStringOptionValue");
        Map valueStore = template.getValueStore();
        valueStore.put("projectName", PROJECT_NAME);
        valueStore.put("projectType", PROJECT_TYPE);
        valueStore.put("location", "");
        valueStore.put("isCProject", "false");
        valueStore.put("id", MBS_GNU_CPP_LINK_OPTION_ID);
        valueStore.put("StringValue", MBS_STRING_OPTION_VALUE);
        if (TemplateEngineTestsHelper.failIfErrorStatus(template.executeTemplateProcesses(null, false))) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        TestProcesses.assertTrue((boolean)project.exists());
        try {
            this.assertSetMBSOptionValues(project, MBS_GNU_CPP_LINK_OPTION_ID, 2, false);
        }
        catch (BuildException e) {
            TestProcesses.fail((String)e.getMessage());
        }
    }

    public void testSetMBSStringListOptionValues() {
        TemplateCore template = TemplateEngine.getDefault().getFirstTemplate(PROJECT_TYPE, null, ".*SetMBSStringListOptionValues");
        Map valueStore = template.getValueStore();
        valueStore.put("projectName", PROJECT_NAME);
        valueStore.put("projectType", PROJECT_TYPE);
        valueStore.put("location", "");
        valueStore.put("isCProject", "false");
        valueStore.put("id", MBS_GNU_CPP_LINK_OPTION_ID);
        int i = 0;
        while (i < MBS_STRING_LIST_OPTION_VALUES.length) {
            valueStore.put("StringListValue" + i, MBS_STRING_LIST_OPTION_VALUES[i]);
            ++i;
        }
        if (TemplateEngineTestsHelper.failIfErrorStatus(template.executeTemplateProcesses(null, false))) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        TestProcesses.assertTrue((boolean)project.exists());
        try {
            this.assertSetMBSOptionValues(project, MBS_GNU_CPP_LINK_OPTION_ID, 3, false);
        }
        catch (BuildException e) {
            TestProcesses.fail((String)e.getMessage());
        }
    }

    public void testAppendToMBSStringOptionValue() {
        TemplateCore template = TemplateEngine.getDefault().getFirstTemplate(PROJECT_TYPE, null, ".*AppendToMBSStringOptionValue");
        Map valueStore = template.getValueStore();
        valueStore.put("projectName", PROJECT_NAME);
        valueStore.put("projectType", PROJECT_TYPE);
        valueStore.put("location", "");
        valueStore.put("isCProject", "false");
        valueStore.put("id", MBS_GNU_CPP_LINK_OPTION_ID);
        valueStore.put("StringValue", MBS_STRING_OPTION_VALUE);
        valueStore.put("AppendStringValue", "AppendMBSStringOption");
        if (TemplateEngineTestsHelper.failIfErrorStatus(template.executeTemplateProcesses(null, false))) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        TestProcesses.assertTrue((boolean)project.exists());
        try {
            this.assertSetMBSOptionValues(project, MBS_GNU_CPP_LINK_OPTION_ID, 2, true);
        }
        catch (BuildException e) {
            TestProcesses.fail((String)e.getMessage());
        }
    }

    public void testAppendToMBSStringListOptionValues() {
        TemplateCore template = TemplateEngine.getDefault().getFirstTemplate(PROJECT_TYPE, null, ".*AppendToMBSStringListOptionValues");
        Map valueStore = template.getValueStore();
        valueStore.put("projectName", PROJECT_NAME);
        valueStore.put("projectType", PROJECT_TYPE);
        valueStore.put("location", "");
        valueStore.put("isCProject", "false");
        valueStore.put("id", MBS_GNU_CPP_LINK_OPTION_ID);
        int i = 0;
        while (i < MBS_STRING_LIST_OPTION_VALUES.length) {
            valueStore.put("StringListValue" + i, MBS_STRING_LIST_OPTION_VALUES[i]);
            ++i;
        }
        i = 0;
        while (i < MBS_STRING_LIST_OPTION_VALUES.length) {
            valueStore.put("AppendStringListValue" + i, APPEND + MBS_STRING_LIST_OPTION_VALUES[i]);
            ++i;
        }
        if (TemplateEngineTestsHelper.failIfErrorStatus(template.executeTemplateProcesses(null, false))) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        TestProcesses.assertTrue((boolean)project.exists());
        try {
            this.assertSetMBSOptionValues(project, MBS_GNU_CPP_LINK_OPTION_ID, 3, true);
        }
        catch (BuildException e) {
            TestProcesses.fail((String)e.getMessage());
        }
    }

    public void testExcludeResources() {
        TemplateCore template = TemplateEngine.getDefault().getFirstTemplate(PROJECT_TYPE, null, ".*ExcludeResources");
        Map valueStore = template.getValueStore();
        valueStore.put("projectName", PROJECT_NAME);
        valueStore.put("projectType", PROJECT_TYPE);
        valueStore.put("location", "");
        valueStore.put("isCProject", "false");
        int i = 0;
        while (i < 3) {
            valueStore.put("baseName" + i, "BaseName" + i);
            ++i;
        }
        valueStore.put("configIdPattern", RELEASE_CONFIG_ID);
        valueStore.put("filePatterns0", ".*BaseName0.*");
        valueStore.put("filePatterns1", ".*BaseName1.*");
        if (TemplateEngineTestsHelper.failIfErrorStatus(template.executeTemplateProcesses(null, false))) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        TestProcesses.assertTrue((boolean)project.exists());
        IConfiguration[] projectConfigs = ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject().getConfigurations();
        int i2 = 0;
        while (i2 < projectConfigs.length) {
            IConfiguration config = projectConfigs[i2];
            IResourceConfiguration[] resourceConfigs = config.getResourceConfigurations();
            int j = 0;
            while (j < resourceConfigs.length) {
                if (resourceConfigs[j].isExcluded()) {
                    String resourcePath = resourceConfigs[i2].getResourcePath();
                    if (resourcePath.matches(".*BaseName0.*")) {
                        TestProcesses.assertTrue((boolean)config.getId().matches(RELEASE_CONFIG_ID));
                    } else if (resourcePath.matches(".*BaseName1.*")) {
                        TestProcesses.assertFalse((boolean)config.getId().matches(RELEASE_CONFIG_ID));
                    } else {
                        TestProcesses.fail((String)(String.valueOf(resourcePath) + " shouldn't be excluded from project"));
                    }
                }
                ++j;
            }
            ++i2;
        }
    }

    private void assertSetMBSOptionValues(IProject project, String id, int optionType, boolean append) throws BuildException {
        IConfiguration[] projectConfigs = ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject().getConfigurations();
        int i = 0;
        while (i < projectConfigs.length) {
            IConfiguration config = projectConfigs[i];
            IOption[] globalOptions = config.getToolChain().getOptions();
            this.assertMBSOptionValues(id.toLowerCase(), globalOptions, optionType, append);
            ITool[] tools = config.getTools();
            int j = 0;
            while (j < tools.length) {
                this.assertMBSOptionValues(id.toLowerCase(), tools[j].getOptions(), optionType, append);
                ++j;
            }
            ++i;
        }
    }

    public void assertMBSOptionValues(String id, IOption[] options, int optionType, boolean append) throws BuildException {
        int i = 0;
        while (i < options.length) {
            IOption option = options[i];
            if (option.getId().toLowerCase().matches(id) && option.getValueType() == optionType) {
                switch (optionType) {
                    case 0: {
                        TestProcesses.assertTrue((boolean)option.getBooleanValue());
                        break;
                    }
                    case 2: {
                        if (append) {
                            TestProcesses.assertTrue((boolean)option.getStringValue().equals("MBSStringOptionAppendMBSStringOption"));
                            break;
                        }
                        TestProcesses.assertTrue((boolean)option.getStringValue().equals(MBS_STRING_OPTION_VALUE));
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        int j;
                        String[] optionValues = option.getStringListValue();
                        if (append) {
                            TestProcesses.assertTrue((optionValues.length == 2 * MBS_STRING_LIST_OPTION_VALUES.length ? 1 : 0) != 0);
                            j = 0;
                            while (j < MBS_STRING_LIST_OPTION_VALUES.length) {
                                TestProcesses.assertTrue((boolean)optionValues[j].equals(MBS_STRING_LIST_OPTION_VALUES[j]));
                                ++j;
                            }
                            while (j < optionValues.length) {
                                TestProcesses.assertTrue((boolean)optionValues[j].equals(APPEND + MBS_STRING_LIST_OPTION_VALUES[j - MBS_STRING_LIST_OPTION_VALUES.length]));
                                ++j;
                            }
                        } else {
                            TestProcesses.assertTrue((optionValues.length == MBS_STRING_LIST_OPTION_VALUES.length ? 1 : 0) != 0);
                            j = 0;
                            while (j < optionValues.length) {
                                TestProcesses.assertTrue((boolean)optionValues[j].equals(MBS_STRING_LIST_OPTION_VALUES[j]));
                                ++j;
                            }
                        }
                        break;
                    }
                }
            }
            ++i;
        }
    }
}

