/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c99;

import java.io.PrintStream;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignator;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public class ASTPrinter {
    public static void printAST(IASTTranslationUnit root, PrintStream stream) {
        IASTComment[] comments;
        PrintStream out;
        PrintStream printStream = out = stream == null ? System.out : stream;
        if (root == null) {
            out.println("null");
            return;
        }
        PrintVisitor visitor = new PrintVisitor(out);
        IASTPreprocessorStatement[] preStats = root.getAllPreprocessorStatements();
        if (preStats != null) {
            int i = 0;
            while (i < preStats.length) {
                ASTPrinter.print(out, 0, (IASTNode)preStats[i]);
                ++i;
            }
        }
        root.accept((ASTVisitor)visitor);
        IASTProblem[] problems = root.getPreprocessorProblems();
        if (problems != null) {
            int i = 0;
            while (i < problems.length) {
                ASTPrinter.print(out, 0, (IASTNode)problems[i]);
                ++i;
            }
        }
        if ((comments = root.getComments()) != null) {
            int i = 0;
            while (i < comments.length) {
                ASTPrinter.print(out, 0, (IASTNode)comments[i]);
                ++i;
            }
        }
    }

    public static void printAST(IASTTranslationUnit root) {
        ASTPrinter.printAST(root, null);
    }

    public static void printProblems(IASTTranslationUnit root, PrintStream stream) {
        PrintStream out;
        PrintStream printStream = out = stream == null ? System.out : stream;
        if (root == null) {
            out.println("null");
            return;
        }
        ProblemVisitor visitor = new ProblemVisitor(out);
        root.accept((ASTVisitor)visitor);
        IASTProblem[] problems = root.getPreprocessorProblems();
        if (problems != null) {
            int i = 0;
            while (i < problems.length) {
                ASTPrinter.print(out, 0, (IASTNode)problems[i]);
                ++i;
            }
        }
    }

    public static void printProblems(IASTTranslationUnit root) {
        ASTPrinter.printProblems(root, System.out);
    }

    private static void print(PrintStream out, int indentLevel, IASTNode n) {
        ASTNode node = (ASTNode)n;
        int i = 0;
        while (i < indentLevel) {
            out.print("  ");
            ++i;
        }
        String classname = node.getClass().getName();
        out.print(classname);
        out.print(" (" + node.getOffset() + "," + node.getLength() + ") ");
        if (node instanceof IASTName) {
            out.print(" " + ((IASTName)node).toString());
        }
        if (node instanceof IASTPointer) {
            IASTPointer pointer = (IASTPointer)node;
            if (pointer.isConst()) {
                out.print(" const");
            }
            if (pointer.isVolatile()) {
                out.print(" volatile");
            }
        }
        if (node instanceof ICASTArrayModifier && ((ICASTArrayModifier)node).isRestrict()) {
            out.print(" restrict");
        }
        if (node instanceof IASTComment) {
            out.print(new String(((IASTComment)node).getComment()));
        }
        out.println();
    }

    private static class PrintVisitor
    extends CASTVisitor {
        private PrintStream out;
        private int indentLevel = 0;

        PrintVisitor(PrintStream out) {
            this.out = out;
            this.shouldVisitDesignators = true;
            this.shouldVisitNames = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitInitializers = true;
            this.shouldVisitParameterDeclarations = true;
            this.shouldVisitDeclarators = true;
            this.shouldVisitDeclSpecifiers = true;
            this.shouldVisitExpressions = true;
            this.shouldVisitStatements = true;
            this.shouldVisitTypeIds = true;
            this.shouldVisitEnumerators = true;
            this.shouldVisitTranslationUnit = true;
            this.shouldVisitProblems = true;
        }

        private void print(IASTNode node) {
            ASTPrinter.print(this.out, this.indentLevel, node);
        }

        public int visit(IASTComment comment) {
            this.print((IASTNode)comment);
            ++this.indentLevel;
            return super.visit(comment);
        }

        public int visit(ICASTDesignator designator) {
            this.print((IASTNode)designator);
            ++this.indentLevel;
            return super.visit(designator);
        }

        public int visit(IASTDeclaration declaration) {
            this.print((IASTNode)declaration);
            ++this.indentLevel;
            return super.visit(declaration);
        }

        public int visit(IASTDeclarator declarator) {
            this.print((IASTNode)declarator);
            ++this.indentLevel;
            IASTPointerOperator[] pointers = declarator.getPointerOperators();
            int i = 0;
            while (i < pointers.length) {
                this.print((IASTNode)pointers[i]);
                ++i;
            }
            if (declarator instanceof IASTArrayDeclarator) {
                IASTArrayDeclarator decl = (IASTArrayDeclarator)declarator;
                IASTArrayModifier[] modifiers = decl.getArrayModifiers();
                int i2 = 0;
                while (i2 < modifiers.length) {
                    this.print((IASTNode)modifiers[i2]);
                    ++i2;
                }
            }
            return super.visit(declarator);
        }

        public int visit(IASTDeclSpecifier declSpec) {
            this.print((IASTNode)declSpec);
            ++this.indentLevel;
            return super.visit(declSpec);
        }

        public int visit(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
            this.print((IASTNode)enumerator);
            ++this.indentLevel;
            return super.visit(enumerator);
        }

        public int visit(IASTExpression expression) {
            this.print((IASTNode)expression);
            ++this.indentLevel;
            return super.visit(expression);
        }

        public int visit(IASTInitializer initializer) {
            this.print((IASTNode)initializer);
            ++this.indentLevel;
            return super.visit(initializer);
        }

        public int visit(IASTName name) {
            this.print((IASTNode)name);
            ++this.indentLevel;
            return super.visit(name);
        }

        public int visit(IASTParameterDeclaration parameterDeclaration) {
            this.print((IASTNode)parameterDeclaration);
            ++this.indentLevel;
            return super.visit(parameterDeclaration);
        }

        public int visit(IASTProblem problem) {
            this.print((IASTNode)problem);
            ++this.indentLevel;
            return super.visit(problem);
        }

        public int visit(IASTStatement statement) {
            this.print((IASTNode)statement);
            ++this.indentLevel;
            return super.visit(statement);
        }

        public int visit(IASTTranslationUnit tu) {
            this.print((IASTNode)tu);
            ++this.indentLevel;
            return super.visit(tu);
        }

        public int visit(IASTTypeId typeId) {
            this.print((IASTNode)typeId);
            ++this.indentLevel;
            return super.visit(typeId);
        }

        public int leave(IASTComment comment) {
            --this.indentLevel;
            return super.leave(comment);
        }

        public int leave(ICASTDesignator designator) {
            --this.indentLevel;
            return super.leave(designator);
        }

        public int leave(IASTDeclaration declaration) {
            --this.indentLevel;
            return super.leave(declaration);
        }

        public int leave(IASTDeclarator declarator) {
            --this.indentLevel;
            return super.leave(declarator);
        }

        public int leave(IASTDeclSpecifier declSpec) {
            --this.indentLevel;
            return super.leave(declSpec);
        }

        public int leave(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
            --this.indentLevel;
            return super.leave(enumerator);
        }

        public int leave(IASTExpression expression) {
            --this.indentLevel;
            return super.leave(expression);
        }

        public int leave(IASTInitializer initializer) {
            --this.indentLevel;
            return super.leave(initializer);
        }

        public int leave(IASTName name) {
            --this.indentLevel;
            return super.leave(name);
        }

        public int leave(IASTParameterDeclaration parameterDeclaration) {
            --this.indentLevel;
            return super.leave(parameterDeclaration);
        }

        public int leave(IASTProblem problem) {
            --this.indentLevel;
            return super.leave(problem);
        }

        public int leave(IASTStatement statement) {
            --this.indentLevel;
            return super.leave(statement);
        }

        public int leave(IASTTranslationUnit tu) {
            --this.indentLevel;
            return super.leave(tu);
        }

        public int leave(IASTTypeId typeId) {
            --this.indentLevel;
            return super.leave(typeId);
        }
    }

    private static class ProblemVisitor
    extends CASTVisitor {
        private PrintStream out;

        ProblemVisitor(PrintStream out) {
            this.out = out;
            this.shouldVisitProblems = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitStatements = true;
            this.shouldVisitExpressions = true;
        }

        public int visit(IASTProblem problem) {
            ASTPrinter.print(this.out, 1, (IASTNode)problem);
            return 3;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTProblemDeclaration) {
                ASTPrinter.print(this.out, 0, (IASTNode)declaration);
            }
            return 3;
        }

        public int visit(IASTExpression expression) {
            if (expression instanceof IASTProblemExpression) {
                ASTPrinter.print(this.out, 0, (IASTNode)expression);
            }
            return 3;
        }

        public int visit(IASTStatement statement) {
            if (statement instanceof IASTProblemStatement) {
                ASTPrinter.print(this.out, 0, (IASTNode)statement);
            }
            return 3;
        }
    }
}

