/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.refactoring.actions;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.refactoring.Messages;
import org.eclipse.cdt.refactoring.CRefactory;
import org.eclipse.cdt.refactoring.IPositionConsumer;
import org.eclipse.cdt.refactoring.actions.CRenameAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.ITextEditor;

public class CRefactoringActionGroup
extends ActionGroup
implements IPositionConsumer {
    public static final String MENU_ID = "org.eclipse.cdt.ui.refactoring.menu";
    public static final String GROUP_REORG = "reorgGroup";
    public static final String GROUP_TYPE = "typeGroup";
    public static final String GROUP_CODING = "codingGroup";
    private static final String GROUP_UNDO = "undoRedoGroup";
    private String fGroupName = "group.reorganize";
    private CRenameAction fRenameAction;
    private boolean fIsEditor;
    private IWorkbenchSite fSite;

    public CRefactoringActionGroup(IWorkbenchWindow ww, String groupName) {
        if (groupName != null && groupName.length() > 0) {
            this.fGroupName = groupName;
        }
        this.fRenameAction = new CRenameAction();
    }

    public CRefactoringActionGroup(IWorkbenchPart part) {
        this(part, null);
    }

    public CRefactoringActionGroup(IWorkbenchPart part, String groupName) {
        if (groupName != null && groupName.length() > 0) {
            this.fGroupName = groupName;
        }
        this.fRenameAction = new CRenameAction();
        if (part instanceof ITextEditor) {
            this.setEditor((ITextEditor)part);
        } else {
            this.init((IWorkbenchSite)part.getSite());
        }
    }

    public CRefactoringActionGroup(Page part) {
        this.fRenameAction = new CRenameAction();
        this.init((IWorkbenchSite)part.getSite());
    }

    public void init(IWorkbenchSite site) {
        this.fRenameAction.setSite(site);
        this.fSite = site;
    }

    public void setEditor(ITextEditor textEditor) {
        this.fIsEditor = true;
        this.fRenameAction.setEditor((IEditorPart)textEditor);
        textEditor.setAction("Rename", (IAction)this.fRenameAction);
        this.fillActionBars(textEditor.getEditorSite().getActionBars());
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (this.fRenameAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.Rename", (IAction)this.fRenameAction);
            actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.fRenameAction);
            actionBars.updateActionBars();
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        this.updateActionBars();
        if (this.fRenameAction.isEnabled()) {
            MenuManager refactorSubmenu = new MenuManager(Messages.getString("CRefactoringActionGroup.RefactorMenu"), MENU_ID);
            refactorSubmenu.add((IContributionItem)new Separator(GROUP_REORG));
            refactorSubmenu.add((IAction)this.fRenameAction);
            refactorSubmenu.add((IContributionItem)new Separator(GROUP_UNDO));
            menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
        }
    }

    private boolean isApplicableFor(ISelection selection) {
        Object o;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (o = ss.getFirstElement()) instanceof ICElement && o instanceof ISourceReference) {
            return !(o instanceof IInclude) && !(o instanceof ITranslationUnit);
        }
        return false;
    }

    public void updateActionBars() {
        if (!this.fIsEditor) {
            if (this.fSite != null) {
                ISelection sel = this.fSite.getSelectionProvider().getSelection();
                if (this.isApplicableFor(sel)) {
                    CRefactory.getInstance().providePosition(((IStructuredSelection)sel).getFirstElement(), this.fRenameAction);
                } else {
                    this.fRenameAction.setEnabled(false);
                }
            } else {
                this.fRenameAction.setEnabled(false);
            }
        }
    }

    public void setPosition(IFile file, int startPos, String text) {
        this.fRenameAction.setPosition(file, startPos, text);
    }
}

