/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template.c;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.template.c.TemplateMessages;
import org.eclipse.cdt.internal.corext.template.c.TranslationUnitContext;
import org.eclipse.cdt.internal.ui.codemanipulation.StubUtility;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public abstract class TranslationUnitContextType
extends TemplateContextType {
    public TranslationUnitContextType() {
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.WordSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.LineSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Dollar());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Date());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Year());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Time());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.User());
        this.addResolver(new File());
        this.addResolver(new ReturnType());
        this.addResolver(new Method());
        this.addResolver(new Project());
        this.addResolver(new Arguments());
        this.addResolver(new Todo());
    }

    public abstract TranslationUnitContext createContext(IDocument var1, int var2, int var3, ITranslationUnit var4);

    public abstract TranslationUnitContext createContext(IDocument var1, Position var2, ITranslationUnit var3);

    protected static class Arguments
    extends TemplateVariableResolver {
        public Arguments() {
            super("enclosing_method_arguments", TemplateMessages.getString("CContextType.variable.description.enclosing.method.arguments"));
        }

        public String resolve(TemplateContext context) {
            ICElement element = ((TranslationUnitContext)context).findEnclosingElement(74);
            if (element == null && (element = ((TranslationUnitContext)context).findEnclosingElement(73)) == null && (element = ((TranslationUnitContext)context).findEnclosingElement(70)) == null) {
                element = ((TranslationUnitContext)context).findEnclosingElement(71);
            }
            if (element instanceof IFunctionDeclaration) {
                String[] arguments = ((IFunctionDeclaration)element).getParameterTypes();
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < arguments.length) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(arguments[i]);
                    ++i;
                }
                return buffer.toString();
            }
            return null;
        }
    }

    protected static class EnclosingCElement
    extends TemplateVariableResolver {
        protected final int fElementType;

        public EnclosingCElement(String name, String description, int elementType) {
            super(name, description);
            this.fElementType = elementType;
        }

        public String resolve(TemplateContext context) {
            ICElement element = ((TranslationUnitContext)context).findEnclosingElement(this.fElementType);
            return element == null ? null : element.getElementName();
        }
    }

    protected static class File
    extends TemplateVariableResolver {
        public File() {
            super("file", TemplateMessages.getString("CContextType.variable.description.file"));
        }

        public String resolve(TemplateContext context) {
            ITranslationUnit unit = ((TranslationUnitContext)context).getTranslationUnit();
            return unit == null ? null : unit.getElementName();
        }
    }

    protected static class Method
    extends EnclosingCElement {
        public Method() {
            super("enclosing_method", TemplateMessages.getString("CContextType.variable.description.enclosing.method"), 70);
        }
    }

    protected static class Project
    extends TemplateVariableResolver {
        public Project() {
            super("enclosing_project", TemplateMessages.getString("CContextType.variable.description.enclosing.project"));
        }

        public String resolve(TemplateContext context) {
            ITranslationUnit unit = ((TranslationUnitContext)context).getTranslationUnit();
            return unit == null ? null : unit.getCProject().getElementName();
        }
    }

    protected static class ReturnType
    extends TemplateVariableResolver {
        public ReturnType() {
            super("return_type", TemplateMessages.getString("CContextType.variable.description.return.type"));
        }

        public String resolve(TemplateContext context) {
            ICElement element = ((TranslationUnitContext)context).findEnclosingElement(70);
            if (element == null) {
                element = ((TranslationUnitContext)context).findEnclosingElement(74);
            }
            if (element == null) {
                return null;
            }
            if (element instanceof IFunctionDeclaration) {
                return ((IFunctionDeclaration)element).getReturnType();
            }
            return null;
        }
    }

    protected static class Todo
    extends TemplateVariableResolver {
        public Todo() {
            super("todo", TemplateMessages.getString("CContextType.variable.description.todo"));
        }

        protected String resolve(TemplateContext context) {
            TranslationUnitContext cContext = (TranslationUnitContext)context;
            ITranslationUnit tUnit = cContext.getTranslationUnit();
            if (tUnit == null) {
                return "XXX";
            }
            ICProject cProject = tUnit.getCProject();
            String todoTaskTag = StubUtility.getTodoTaskTag(cProject);
            if (todoTaskTag == null) {
                return "XXX";
            }
            return todoTaskTag;
        }
    }
}

