/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.Iterator;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.ICAnnotation;
import org.eclipse.cdt.internal.ui.editor.IProblemAnnotation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class CMarkerAnnotation
extends MarkerAnnotation
implements IProblemAnnotation,
ICAnnotation {
    public static final String C_MARKER_TYPE_PREFIX = "org.eclipse.cdt";
    public static final String ERROR_ANNOTATION_TYPE = "org.eclipse.cdt.ui.error";
    public static final String WARNING_ANNOTATION_TYPE = "org.eclipse.cdt.ui.warning";
    public static final String INFO_ANNOTATION_TYPE = "org.eclipse.cdt.ui.info";
    public static final String TASK_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.task";
    private boolean fIsProblemMarker = MarkerUtilities.isMarkerType((IMarker)this.getMarker(), (String)"org.eclipse.cdt.core.problem");
    private ICAnnotation fOverlay;

    public CMarkerAnnotation(IMarker marker) {
        super(marker);
    }

    public String getMessage() {
        if (this.fIsProblemMarker) {
            return this.getMarker().getAttribute("message", "");
        }
        return "";
    }

    public boolean isError() {
        if (this.fIsProblemMarker) {
            int markerSeverity = this.getMarker().getAttribute("severity", -1);
            return markerSeverity == 2;
        }
        return false;
    }

    public boolean isWarning() {
        if (this.fIsProblemMarker) {
            int markerSeverity = this.getMarker().getAttribute("severity", -1);
            return markerSeverity == 1;
        }
        return false;
    }

    public boolean isTemporaryProblem() {
        return false;
    }

    public String[] getArguments() {
        String[] s = new String[]{"problem", "here"};
        return s;
    }

    public int getId() {
        if (this.fIsProblemMarker) {
            return this.getMarker().getAttribute("org.eclipse.cdt.core.problem", -1);
        }
        return 0;
    }

    public boolean isProblem() {
        return this.fIsProblemMarker;
    }

    public void setOverlay(ICAnnotation cAnnotation) {
        if (this.fOverlay != null) {
            this.fOverlay.removeOverlaid(this);
        }
        this.fOverlay = cAnnotation;
        if (!this.isMarkedDeleted()) {
            this.markDeleted(this.fOverlay != null);
        }
        if (this.fOverlay != null) {
            this.fOverlay.addOverlaid(this);
        }
    }

    public boolean hasOverlay() {
        return this.fOverlay != null;
    }

    public ICAnnotation getOverlay() {
        return this.fOverlay;
    }

    public void addOverlaid(ICAnnotation annotation) {
    }

    public void removeOverlaid(ICAnnotation annotation) {
    }

    public Iterator getOverlaidIterator() {
        return null;
    }

    public ITranslationUnit getTranslationUnit() {
        ICElement element = CoreModel.getDefault().create(this.getMarker().getResource());
        if (element instanceof ITranslationUnit) {
            return (ITranslationUnit)element;
        }
        return null;
    }
}

