/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlighting;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingManager;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingPresenter;
import org.eclipse.cdt.internal.ui.editor.SemanticToken;
import org.eclipse.cdt.internal.ui.text.ICReconcilingListener;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public class SemanticHighlightingReconciler
implements ICReconcilingListener {
    private CEditor fEditor;
    private SemanticHighlightingPresenter fPresenter;
    private SemanticHighlighting[] fSemanticHighlightings;
    private SemanticHighlightingManager.HighlightingStyle[] fHighlightings;
    private List fAddedPositions = new ArrayList();
    private List fRemovedPositions = new ArrayList();
    private int fNOfRemovedPositions;
    private Job fJob;
    private final Object fJobLock = new Object();
    private final Object fReconcileLock = new Object();
    private boolean fIsReconciling = false;
    private SemanticHighlightingPresenter fJobPresenter;
    private SemanticHighlighting[] fJobSemanticHighlightings;
    private SemanticHighlightingManager.HighlightingStyle[] fJobHighlightings;

    public void aboutToBeReconciled() {
    }

    /*
     * Exception decompiling
     */
    public void reconciled(IASTTranslationUnit ast, boolean force, IProgressMonitor progressMonitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5 : 273->277)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void startReconcilingPositions() {
        this.fJobPresenter.addAllPositions(this.fRemovedPositions);
        this.fNOfRemovedPositions = this.fRemovedPositions.size();
    }

    private void reconcilePositions(IASTTranslationUnit ast, PositionCollector visitor) {
        ast.accept((ASTVisitor)visitor);
        List oldPositions = this.fRemovedPositions;
        ArrayList newPositions = new ArrayList(this.fNOfRemovedPositions);
        int i = 0;
        int n = oldPositions.size();
        while (i < n) {
            Object current = oldPositions.get(i);
            if (current != null) {
                newPositions.add(current);
            }
            ++i;
        }
        this.fRemovedPositions = newPositions;
        Collections.sort(this.fAddedPositions, new Comparator(){

            public int compare(Object o1, Object o2) {
                Position p1 = (Position)o1;
                Position p2 = (Position)o2;
                return p1.getOffset() - p2.getOffset();
            }
        });
    }

    private void updatePresentation(TextPresentation textPresentation, List addedPositions, List removedPositions) {
        Runnable runnable = this.fJobPresenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        CEditor editor = this.fEditor;
        if (editor == null) {
            return;
        }
        IWorkbenchPartSite site = editor.getSite();
        if (site == null) {
            return;
        }
        Shell shell = site.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(runnable);
    }

    private void stopReconcilingPositions() {
        this.fRemovedPositions.clear();
        this.fNOfRemovedPositions = 0;
        this.fAddedPositions.clear();
    }

    public void install(CEditor editor, ISourceViewer sourceViewer, SemanticHighlightingPresenter presenter, SemanticHighlighting[] semanticHighlightings, SemanticHighlightingManager.HighlightingStyle[] highlightings) {
        this.fPresenter = presenter;
        this.fSemanticHighlightings = semanticHighlightings;
        this.fHighlightings = highlightings;
        this.fEditor = editor;
        if (this.fEditor != null) {
            this.fEditor.addReconcileListener(this);
        }
    }

    public void uninstall() {
        if (this.fPresenter != null) {
            this.fPresenter.setCanceled(true);
        }
        if (this.fEditor != null) {
            this.fEditor.removeReconcileListener(this);
            this.fEditor = null;
        }
        this.fSemanticHighlightings = null;
        this.fHighlightings = null;
        this.fPresenter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob() {
        final ICElement element = this.fEditor.getInputCElement();
        Object object = this.fJobLock;
        synchronized (object) {
            final Job oldJob = this.fJob;
            if (this.fJob != null) {
                this.fJob.cancel();
                this.fJob = null;
            }
            if (element != null) {
                this.fJob = new Job(CEditorMessages.getString("SemanticHighlighting_job")){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (oldJob != null) {
                            try {
                                oldJob.join();
                            }
                            catch (InterruptedException e) {
                                CUIPlugin.getDefault().log(e);
                                return Status.CANCEL_STATUS;
                            }
                        }
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        2 me = this;
                        ASTProvider astProvider = CUIPlugin.getDefault().getASTProvider();
                        IStatus status = astProvider.runOnAST(element, ASTProvider.WAIT_YES, monitor, new ASTCache.ASTRunnable(this, monitor, me){
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ IProgressMonitor val$monitor;
                            private final /* synthetic */ Job val$me;
                            {
                                this.this$1 = var1_1;
                                this.val$monitor = iProgressMonitor;
                                this.val$me = job;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
                                2.access$0(this.this$1).reconciled(ast, true, this.val$monitor);
                                Object object = SemanticHighlightingReconciler.access$7(2.access$0(this.this$1));
                                synchronized (object) {
                                    if (SemanticHighlightingReconciler.access$8(2.access$0(this.this$1)) == this.val$me) {
                                        SemanticHighlightingReconciler.access$9(2.access$0(this.this$1), null);
                                    }
                                }
                                return Status.OK_STATUS;
                            }
                        });
                        return status;
                    }

                    static /* synthetic */ SemanticHighlightingReconciler access$0(2 var0) {
                        return var0.SemanticHighlightingReconciler.this;
                    }
                };
                this.fJob.setPriority(50);
                this.fJob.schedule();
            }
        }
    }

    public void refresh() {
        this.scheduleJob();
    }

    static /* synthetic */ Object access$7(SemanticHighlightingReconciler semanticHighlightingReconciler) {
        return semanticHighlightingReconciler.fJobLock;
    }

    static /* synthetic */ Job access$8(SemanticHighlightingReconciler semanticHighlightingReconciler) {
        return semanticHighlightingReconciler.fJob;
    }

    static /* synthetic */ void access$9(SemanticHighlightingReconciler semanticHighlightingReconciler, Job job) {
        semanticHighlightingReconciler.fJob = job;
    }

    private class PositionCollector
    extends CPPASTVisitor {
        private SemanticToken fToken;
        private String fFilePath;
        private int fMinLocation;

        public PositionCollector(String filePath) {
            this.shouldVisitTranslationUnit = true;
            this.shouldVisitNames = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitExpressions = true;
            this.shouldVisitStatements = true;
            this.shouldVisitDeclSpecifiers = true;
            this.shouldVisitDeclarators = true;
            this.shouldVisitNamespaces = true;
            this.fToken = new SemanticToken();
            this.fFilePath = filePath;
            this.fMinLocation = -1;
        }

        public int visit(IASTTranslationUnit tu) {
            IASTPreprocessorMacroDefinition[] macroDefs = tu.getMacroDefinitions();
            int i = 0;
            while (i < macroDefs.length) {
                IASTPreprocessorMacroDefinition macroDef = macroDefs[i];
                if (this.fFilePath.equals(macroDef.getContainingFilename())) {
                    this.visit(macroDef.getName());
                }
                ++i;
            }
            return super.visit(tu);
        }

        public int visit(IASTDeclaration declaration) {
            if (!this.fFilePath.equals(declaration.getContainingFilename())) {
                return 1;
            }
            if (this.checkForMacro((IASTNode)declaration)) {
                return 1;
            }
            return 3;
        }

        public int visit(ICPPASTNamespaceDefinition namespace) {
            if (!this.fFilePath.equals(namespace.getContainingFilename())) {
                return 1;
            }
            if (this.checkForMacro((IASTNode)namespace)) {
                return 1;
            }
            return 3;
        }

        public int visit(IASTDeclSpecifier declSpec) {
            if (this.checkForMacro((IASTNode)declSpec)) {
                return 1;
            }
            return 3;
        }

        public int visit(IASTDeclarator declarator) {
            if (this.checkForMacro((IASTNode)declarator)) {
                return 1;
            }
            return 3;
        }

        public int visit(IASTExpression expression) {
            if (this.checkForMacro((IASTNode)expression)) {
                return 1;
            }
            return 3;
        }

        public int visit(IASTStatement statement) {
            if (this.checkForMacro((IASTNode)statement)) {
                return 1;
            }
            return 3;
        }

        public int visit(IASTName name) {
            if (this.checkForMacro((IASTNode)name)) {
                return 1;
            }
            if (this.visitNode((IASTNode)name)) {
                return 1;
            }
            return 3;
        }

        private boolean checkForMacro(IASTNode node) {
            IASTFileLocation useLocation;
            IASTNodeLocation[] nodeLocations = node.getNodeLocations();
            if (nodeLocations.length == 1 && nodeLocations[0] instanceof IASTMacroExpansion && (useLocation = this.getMinFileLocation(nodeLocations)) != null) {
                int useOffset = useLocation.getNodeOffset();
                if (useOffset <= this.fMinLocation) {
                    return true;
                }
                this.fMinLocation = useOffset;
                IASTPreprocessorMacroDefinition macroDef = ((IASTMacroExpansion)nodeLocations[0]).getMacroDefinition();
                IASTFileLocation defLocation = macroDef.getName().getFileLocation();
                int macroLength = defLocation != null ? defLocation.getNodeLength() : macroDef.getName().toCharArray().length;
                IASTNode macroNode = node.getTranslationUnit().selectNodeForLocation(this.fFilePath, useOffset, macroLength);
                if (macroNode != null && this.visitMacro(macroNode, macroLength)) {
                    return true;
                }
            }
            return false;
        }

        private boolean visitMacro(IASTNode node, int macroLength) {
            this.fToken.update(node);
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fJobSemanticHighlightings.length;
            while (i < n) {
                SemanticHighlighting semanticHighlighting = SemanticHighlightingReconciler.this.fJobSemanticHighlightings[i];
                if (SemanticHighlightingReconciler.this.fJobHighlightings[i].isEnabled() && semanticHighlighting.consumes(this.fToken)) {
                    this.addMacroLocation((IASTNodeLocation)node.getFileLocation(), macroLength, SemanticHighlightingReconciler.this.fJobHighlightings[i]);
                    break;
                }
                ++i;
            }
            this.fToken.clear();
            return true;
        }

        private boolean visitNode(IASTNode node) {
            boolean consumed = false;
            this.fToken.update(node);
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fJobSemanticHighlightings.length;
            while (i < n) {
                SemanticHighlighting semanticHighlighting = SemanticHighlightingReconciler.this.fJobSemanticHighlightings[i];
                if (SemanticHighlightingReconciler.this.fJobHighlightings[i].isEnabled() && semanticHighlighting.consumes(this.fToken)) {
                    this.addNodeLocation((IASTNodeLocation)node.getFileLocation(), SemanticHighlightingReconciler.this.fJobHighlightings[i]);
                    consumed = true;
                    break;
                }
                ++i;
            }
            this.fToken.clear();
            return consumed;
        }

        private void addNodeLocation(IASTNodeLocation nodeLocation, SemanticHighlightingManager.HighlightingStyle highlighting) {
            if (nodeLocation == null) {
                return;
            }
            int offset = nodeLocation.getNodeOffset();
            int length = nodeLocation.getNodeLength();
            if (offset > -1 && length > 0) {
                this.addPosition(offset, length, highlighting);
            }
        }

        private void addMacroLocation(IASTNodeLocation macroUseLocation, int macroLength, SemanticHighlightingManager.HighlightingStyle highlighting) {
            if (macroUseLocation == null) {
                return;
            }
            int offset = macroUseLocation.getNodeOffset();
            int length = macroLength;
            if (offset > -1 && length > 0) {
                this.addPosition(offset, length, highlighting);
            }
        }

        private IASTFileLocation getMinFileLocation(IASTNodeLocation[] locations) {
            if (locations == null || locations.length == 0) {
                return null;
            }
            IASTNodeLocation nodeLocation = locations[0];
            if (nodeLocation instanceof IASTFileLocation) {
                return (IASTFileLocation)nodeLocation;
            }
            if (nodeLocation instanceof IASTMacroExpansion) {
                IASTNodeLocation[] macroLocations = ((IASTMacroExpansion)nodeLocation).getExpansionLocations();
                return this.getMinFileLocation(macroLocations);
            }
            return null;
        }

        private void addPosition(int offset, int length, SemanticHighlightingManager.HighlightingStyle highlighting) {
            boolean isExisting = false;
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fRemovedPositions.size();
            while (i < n) {
                SemanticHighlightingManager.HighlightedPosition position = (SemanticHighlightingManager.HighlightedPosition)((Object)SemanticHighlightingReconciler.this.fRemovedPositions.get(i));
                if (position != null && position.isEqual(offset, length, highlighting)) {
                    isExisting = true;
                    SemanticHighlightingReconciler.this.fRemovedPositions.set(i, null);
                    SemanticHighlightingReconciler semanticHighlightingReconciler = SemanticHighlightingReconciler.this;
                    semanticHighlightingReconciler.fNOfRemovedPositions = semanticHighlightingReconciler.fNOfRemovedPositions - 1;
                    break;
                }
                ++i;
            }
            if (!isExisting) {
                SemanticHighlightingManager.HighlightedPosition position = SemanticHighlightingReconciler.this.fJobPresenter.createHighlightedPosition(offset, length, highlighting);
                SemanticHighlightingReconciler.this.fAddedPositions.add(position);
            }
        }
    }
}

